/*
 * Copyright (c) 2015 Adobe Systems.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global require, exports */
"use strict";

var Logger = require("./Logging");

var logger = Logger.createLogger({name: "USBMUXDevice", level: "debug"});

/**
 * Initialize a new USBMUXDevice.
 *
 * @param {!string} deviceID    the unique device id assigned from usbmuxd
 * @param {!string} locationID  some id to specify the location of the device
 * @param {!string} serialNumber    the serial number of the device (UDID)
 * @param {!string} productID   specifies the device used (encoded in Apple product codes)
 *
 * @constructor
 */
function USBMUXDevice(deviceID, locationID, serialNumber, productID) {
    if (!(deviceID !== undefined && locationID !== undefined && serialNumber !== undefined && productID !== undefined)) {
        throw new Error("Provide deviceID, locationID, serialNumber and productID");
    }

    this.deviceID     = deviceID;
    this.locationID   = locationID;
    this.serialNumber = serialNumber;
    this.productID    = productID;

    logger.debug("Created USBMUXDevice");
}

/**
 * Returns a string representation of this instance.
 * @returns {string}
 */
USBMUXDevice.prototype.toString = function () {
    return "[USBMUXDevice: (DeviceID=" + this.deviceID + ", LocationID=" + this.locationID + ", SerialNumber=" + this.serialNumber + ", ProductID=" + this.productID + ")]";
};

/**
 * @see {@link USBMUXDevice}
 */
function create(deviceID, locationID, serialNumber, productID) {
    return new USBMUXDevice(deviceID, locationID, serialNumber, productID);
}

exports.create = create;
