/*
 * Copyright (c) 2018 Adobe Systems Incorporated. All rights reserved.
 *  
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *  
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *  
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 * 
 */

/*jslint vars: true, node: true, plusplus: true, devel: true, nomen: true, indent: 4, esversion: 6*/

(function () {
    "use strict";

    /**
     * A logger object that provides debug, info, warn, error methods
     */
    var _logger;

    /**
     * Supply the underlying logger instance
     * The other methods will fall back on console before initialized.
     * @param {Logger} logger
     */
    exports.init = function (logger) {
        _logger = logger;
    };

    exports.debug = function (...params) {
        if (_logger) {
            _logger.debug(...params);
        } else {
            console.debug(...params);
        }
    };

    exports.info = function (...params) {
        if (_logger) {
            _logger.info(...params);
        } else {
            console.info(...params);
        }
    };

    exports.warn = function (...params) {
        if (_logger) {
            _logger.warn(...params);
        } else {
            console.warn(...params);
        }
    };
    exports.error = function (...params) {
        if (_logger) {
            _logger.error(...params);
        } else {
            console.error(...params);
        }
    };

}());
