//agf_include "main_shared_functions_fragment.glsl"
//agf_include "main_vertex2fragment.glsl"

#ifndef PI
#define PI 3.14159
#endif

#ifdef ENABLE_AGFDiffuseMap
uniform agf_highp sampler2D	diffuse_texture;
uniform agf_highp mat4		diffuse_texture_matrix;
#endif

#ifdef ENABLE_AGFSpecularColorMap
uniform agf_highp sampler2D	specular_intensity_texture;
uniform agf_highp mat4		specular_intensity_texture_matrix;
#endif

#ifdef ENABLE_AGFSpecularExponentMap
uniform agf_highp sampler2D	specular_exponent_texture;
uniform agf_highp mat4		specular_exponent_texture_matrix;
#endif

#ifdef ENABLE_AGFNormalMap
uniform agf_highp sampler2D	normal_map_texture;
uniform agf_highp mat4		normal_map_texture_matrix;
#endif

#ifdef ENABLE_AGFBumpMap
uniform agf_highp sampler2D	bump_gradient_texture;
uniform agf_highp mat4		bump_gradient_texture_matrix;
uniform agf_highp vec4		bumpTextureNormalizer;
#endif
uniform agf_highp float		bumpStrength;

#ifdef ENABLE_ROUGHNESS
uniform agf_highp sampler2D    roughness_texture;
uniform agf_highp mat4        roughness_texture_matrix;
uniform agf_highp vec4        roughness;
#endif

#ifdef ENABLE_AGFMetallicMap
uniform agf_highp sampler2D	metallic_texture;
uniform agf_highp mat4		metallic_texture_matrix;
#endif

#ifdef ENABLE_AGFTranslucenceMap
uniform agf_highp sampler2D   translucence_texture;
uniform agf_highp mat4        translucence_texture_matrix;
#endif

#if NUMBER_OF_ACTIVE_INFINITE_LIGHTS > 0
uniform InfiniteLight	infiniteLights[NUMBER_OF_ACTIVE_INFINITE_LIGHTS];
#endif

#if NUMBER_OF_ACTIVE_SPOT_LIGHTS > 0
uniform SpotLight		spotLights[NUMBER_OF_ACTIVE_SPOT_LIGHTS];
#endif

#if NUMBER_OF_ACTIVE_POINT_LIGHTS > 0
uniform PointLight		pointLights[NUMBER_OF_ACTIVE_POINT_LIGHTS];
#endif

#ifdef	ENABLE_IBL
uniform agf_highp mat4          sphericalHarmonicMatrixRed;
uniform agf_highp mat4          sphericalHarmonicMatrixGreen;
uniform agf_highp mat4          sphericalHarmonicMatrixBlue;
uniform agf_highp mat4          sphericalHarmonicsTransformationMatrix;
#endif

#ifdef ENABLE_AGFSphereEnvironmentMap
uniform agf_highp sampler2D	    environment_texture;
uniform agf_highp mat4		    environment_texture_matrix;
#if SAMPLER_3D_AVAILABLE
uniform agf_highp sampler3D	    discreteShininess3DTex;
#endif
#endif

#ifdef ENABLE_AGFReflectivityMap
uniform agf_highp sampler2D     reflectivity_texture;
uniform agf_highp mat4	        reflectivity_texture_matrix;
#endif

#ifdef ENABLE_AGFSelfIlluminationMap
uniform agf_highp sampler2D     self_illumination_texture;
uniform agf_highp mat4	        self_illumination_texture_matrix;
uniform agf_highp vec4	        self_illumination_texture_range;
#endif

#ifdef	ENABLE_AGFOpacityMap
uniform agf_highp sampler2D     object_opacity_texture;
uniform agf_highp mat4	        object_opacity_texture_matrix;
#endif

uniform Material	            material;
uniform agf_highp float         iblIntensity;
uniform agf_highp vec4		    unscaledIBLColor;
uniform agf_highp mat4		    fmodelViewCamera;
uniform agf_highp mat4		    iEyeToWorldMatrix;
uniform agf_highp mat4		    iEyeToNormalizedBBOXMatrix;

uniform agf_highp mat4		    reflectionTransformationMatrix;
uniform agf_highp vec4		    environmentColor;
uniform agf_highp vec4		    iGlobalAmbientColor;

uniform agf_highp vec4          clippingPlane;
uniform agf_highp vec4          extraReflectionClippingPlane;
uniform agf_highp vec4          refraction_flag; //First component is refraction_flag, second component is piggybacked transparency threshold
uniform agf_highp vec4          useVertexForBase;
uniform agf_highp sampler2D	    background_texture;
uniform agf_highp mat4		    background_texture_matrix;
uniform agf_highp mat4		    refractionTransformationMatrix;
uniform agf_highp vec4		    bumpNormalPreviewFlags; //[0] - normal map strength (1/0), [1] - bump map extra strength. Used in print preview;
#if SAMPLER_3D_AVAILABLE
#ifdef HAS_VOLUME_BUMP_NOISE
uniform agf_highp sampler3D     volumeNoiseTexture;
uniform agf_highp vec4          volumeNoiseBumpParams;
#endif
#endif
uniform agf_highp vec4          agf_bump_2_params;
uniform agf_highp vec2		    agf_force_flat_shading; //First elem forces flat shading, second piggybacked flag for forcing parallel projection reflection

uniform agf_highp sampler2D     brdf_texture; //TODO: pass this in properly

agf_highp float safe_dot(in agf_highp vec3 u, in agf_highp vec3 v) {
  return clamp(dot(u,v), 0.0, 1.0);
}
agf_highp vec3 uv_to_normal(in agf_highp vec2 uv) {
  agf_highp vec3 N;

  agf_highp vec2 uvRange = uv;

  agf_highp float theta = uvRange.x * 2.0 * PI;
  agf_highp float phi = uvRange.y * PI;

  N.x = cos(theta) * sin(phi);
  N.z = sin(theta) * sin(phi);
  N.y = -cos(phi);
  return N;
}

agf_highp vec2 normal_to_uv(in agf_highp vec3 N) {
  // This only works if everything is normalized.
  agf_highp vec3 R = normalize(N);

  // The spherical coordinate math breaks down near vertical, so check within
  // an epsilon to prevent flickering in upward-pointing faces....
  if (1.0-abs(R.y) < 1e-7) {
    return vec2(0.0,(sign(R.y)+1.0)/2.0);
  }

  agf_highp float theta = atan(-R.x, R.z) + PI;
  theta /= 2.0 * PI;

  agf_highp float phi = acos(-R.y);
  phi /= PI;
  return vec2(1.0-theta, 1.0-phi);
}
agf_highp vec3 RGBMIBLDecode ( in agf_highp vec4 rgbm )
{
  agf_highp vec3 hdr = vec3(5.0, 5.0, 5.0) * rgbm.rgb * rgbm.aaa;
  return pow(hdr.rgb, vec3(2.2, 2.2, 2.2) );
}

agf_highp vec3 sample_environment(in agf_highp vec3 N, in agf_highp float roughnessValue) {
#ifdef ENABLE_AGFSphereEnvironmentMap
      agf_highp float ibl_max_levels = 7.0;
      agf_highp vec3 ibl_Normal = (sphericalHarmonicsTransformationMatrix*vec4(N, 0)).xyz; //I think this is sphericalHarmonicsTransformationMatrix
      agf_highp vec2 env_uv = normal_to_uv(ibl_Normal);
    #if LOD_AVAILABLE
      agf_highp vec3 sampledColor = agf_texture_2d_lod(environment_texture, env_uv, roughnessValue*ibl_max_levels).rgb;
    #else
      //This is not going to work properly.  But LOD is not working on Linux.  Two issues:
      //First, we're ignoring roughness
      //Second, when we do this, teh sample comesin very "purple".
      //So, we use the red channel for now and move on.  The default IBL is gray anyway
      agf_highp vec3 sampledColor = texture2D(environment_texture, env_uv).rrr;
    #endif
      agf_highp vec3 remappedColor = sampledColor * iblIntensity;
      return remappedColor * unscaledIBLColor.rgb;
#else //#ifdef ENABLE_AGFSphereEnvironmentMap
      return vec3(0.5,0.5,0.5);
#endif
}

agf_highp vec2 get_brdf(in agf_highp float roughnessValue, in agf_highp float NdV) {
  agf_highp vec2 brdf_uv = vec2(roughnessValue, NdV);
  agf_highp vec2 brdf = texture2D(brdf_texture, brdf_uv).xy;
  
  return brdf.xy;
}

agf_highp vec2 get_specular_brdf(in agf_highp float roughnessValue, in agf_highp vec3 N, agf_highp vec3 V, agf_highp  vec3 vertex_normal) {
  // Horizon correction, per http://marmosetco.tumblr.com/post/81245981087
  const agf_highp float horizon_amount = 1.3;
  agf_highp vec3 reflected = normalize(reflect(-V,N));
  agf_highp float horizon = clamp(1.0 + horizon_amount * dot(reflected, vertex_normal), 0.0, 1.0);
  horizon *= horizon;

  return get_brdf(roughnessValue, safe_dot(N, V)) * horizon;
}

agf_highp vec3 get_specular_ibl(in agf_highp vec3 specular_color, in agf_highp float roughnessValue, in agf_highp vec3 N, in agf_highp vec3 V, in agf_highp vec2 brdf) {
  agf_highp vec3 R = normalize(reflect(-V,N));
  agf_highp vec3 color = sample_environment(R, roughnessValue);
  return color * (specular_color * brdf.xxx + brdf.yyy);
}

// refract with total internal reflection calculation
agf_highp vec3 refract_full(in agf_highp vec3 I, in agf_highp vec3 N, in agf_highp float eta) {
  agf_highp float c = -dot(N,I);
  agf_highp float k = 1.0 - eta * eta * (1.0 - c*c);
  if (k < 0.0)
    return normalize(reflect(I,N));
  else
    return eta * I + (eta * c - sqrt(k)) * N;
}

// refract assuming entry and exit of a unit sphere with IOR eta.
// This is an approximation of true refraction (which would require true ray casting)
// I and N should be unit length, normalized vectors
agf_highp vec3 double_refract(in agf_highp vec3 I, in agf_highp vec3 N, in agf_highp float eta) {
  agf_highp vec3 Tfront = refract_full(I, N, 1.0/eta);
  agf_highp vec3 Nback = normalize(reflect(N, Tfront));
  return refract_full(Tfront, -Nback, eta);
}

void main()
{
//    gl_FragColor.rgb = vec3(1.0, 0.0, 1.0);
//    gl_FragColor.a = 1.0;
//    return;

#if 1
//########################################## CLIPPING PLANES ################################################################################		

agf_highp float clipSign = dot(clippingPlane.xyz, vertOut_vPosition.xyz)+clippingPlane.w;
if (clipSign < 0.0) discard;

agf_highp float extraClipSign = dot(extraReflectionClippingPlane.xyz, vertOut_vPosition.xyz)+extraReflectionClippingPlane.w;
if (extraClipSign < 0.0) discard;

//########################################## END OF CLIPPING PLANES ################################################################################		

		agf_highp vec4 UV = vertOut_fTexCoord0;
		agf_highp vec3 materialSpecularColor =  material.Ks.rgb;
		agf_highp vec3 newNormal = normalize(vertOut_vNormal);
		agf_highp vec4 texLookup = vec4(0.0, 0.0, 0.0, 0.0); //Temporary variable, to use in all the texture Lookups
		

//########################################## OPACITY MANAGEMENT ################################################################################		
		
		agf_highp float finalOpacity = 0.0;
		agf_highp float opacity=material.opacity;



#ifdef	ENABLE_AGFOpacityMap
		texLookup = xformTex2D(object_opacity_texture, UV, object_opacity_texture_matrix);		
#ifdef USE_ALPHA_FOR_OPACITY_MAP
		opacity = texLookup.a*material.opacity;
#else
		agf_highp vec3 materialOpacity3 = vec3(material.opacity, material.opacity, material.opacity);
		//Blending base opacity value with the one in the opacity map. 
		agf_highp vec3 perColorOpacity =  mix(materialOpacity3, texLookup.rgb, texLookup.a);
		//We have got to choose _SINGLE_ opacity value for GL framebuffer
		//We are choosing maximum of the 3
		agf_highp float rg_maxopacity = max (perColorOpacity.r, perColorOpacity.g);
		opacity = max (rg_maxopacity, perColorOpacity.b); 
#endif
#endif
		finalOpacity = opacity;
    
		if (refraction_flag[2]>0.5)
			{
			finalOpacity = material.opacity;
			}
		else
			{
			if (refraction_flag[1]>=0.0)
				{
				if (finalOpacity < refraction_flag[1])
					discard;
				else
					finalOpacity = 1.0;
				}
			}

	if (finalOpacity == 0.0) 
		{
		discard;
		}

#if LOD_AVAILABLE //This makes stochastic transparency be used all the time on iOS -@nikolai3d
	if (useVertexForBase[2] > 0.5) //Stochastic transparency
#endif
		{
		agf_highp float heisenbergOpacity = rand(gl_FragCoord.xy+vertOut_vPosition.zz);

		agf_highp float testOpacity = finalOpacity;

		if (testOpacity < 0.05)
			{
			testOpacity = 0.1*finalOpacity;
			}

		if (heisenbergOpacity > testOpacity)
			{
			discard;
			}

		finalOpacity = 1.0;
		}


        agf_highp float translucence_scalar = material.translucence*0.5;
#ifdef ENABLE_AGFTranslucenceMap
        texLookup = xformTex2D(translucence_texture, UV,translucence_texture_matrix);
        translucence_scalar = mix(material.translucence, texLookup.r, texLookup.a);
#endif
        if(material.density > 1.0 - translucence_scalar)
            translucence_scalar = 1.0 - material.density;
        if(1.0 - translucence_scalar < finalOpacity)
            finalOpacity = 1.0 - translucence_scalar;
    
//########################################## END OF OPACITY MANAGEMENT ################################################################################		
    


    

//###################################################### NORMAL MAP/BUMP MAP CALCULATION (NORMAL ALTERATION) ##############################################
//Tangential basis. Needs to be there for bump maps and/or tangent-space normal maps
        agf_highp vec4 geomPointInEyeSpace = vec4(vertOut_vEye, 1.0);
        if (agf_force_flat_shading[0]>0.5)
        {
            agf_highp vec3 _zero_offsetPointEyeSpace = geomPointInEyeSpace.xyz;
            agf_highp vec3 _zero_dxPES = dFdx(_zero_offsetPointEyeSpace);
            agf_highp vec3 _zero_dyPES = dFdy(_zero_offsetPointEyeSpace);
            agf_highp vec3 _zero_slopeNormal = cross(_zero_dxPES, _zero_dyPES);
            agf_highp vec3 flatNormal = normalize(_zero_slopeNormal);
            if (dot(flatNormal, newNormal)<0.0);
                flatNormal = -flatNormal;
            newNormal = flatNormal;
        }
    
		agf_highp vec3 _t = normalize(vertOut_t);
		agf_highp vec3 _n = normalize(vertOut_n);
		agf_highp vec3 _b = normalize(vertOut_b);

#ifdef ENABLE_AGFNormalMap
		//We will make sure that normal mapping and bump mapping cannot be enabled simultaneously
		//vec4 normalMapLookup = tex2D(normal_map_texture, interpolant.fTexCoord0.xy);
		agf_highp vec4 normalMapLookup = xformTex2D(normal_map_texture, UV, normal_map_texture_matrix);
		normalMapLookup.xyz = (normalMapLookup.xyz-vec3(0.49803921568, 0.49803921568, 0.49803921568))*2.00787401577;
        normalMapLookup.y=-normalMapLookup.y;
  
		agf_highp float normalMapAlpha = normalMapLookup.a*bumpNormalPreviewFlags[1];
		normalMapLookup.a = 0.0;
		//Normal maps are now tangential
		agf_highp vec3 tangentSpaceNormal = normalMapLookup.xyz;
		agf_highp vec3 eyeSpaceNormal;
		eyeSpaceNormal.x = _t.x * tangentSpaceNormal.x + _b.x * tangentSpaceNormal.y + _n.x * tangentSpaceNormal.z;
		eyeSpaceNormal.y = _t.y * tangentSpaceNormal.x + _b.y * tangentSpaceNormal.y + _n.y * tangentSpaceNormal.z;
		eyeSpaceNormal.z = _t.z * tangentSpaceNormal.x + _b.z * tangentSpaceNormal.y + _n.z * tangentSpaceNormal.z;

		if (dot(tangentSpaceNormal, tangentSpaceNormal)<2.5)//White color in normal maps disables it
			{
			newNormal = mix(newNormal, normalize(eyeSpaceNormal), normalMapAlpha);
			}
#endif

		agf_highp vec3 bumpGradient=vec3(0.0, 0.0, 0.0);
#ifdef ENABLE_AGFBumpMap
		//vec4 bumpLookup = tex2D(bump_gradient_texture, interpolant.fTexCoord0.xy);
		agf_highp vec4 bumpLookup = xformTex2D(bump_gradient_texture, UV, bump_gradient_texture_matrix);
#ifdef AGF_BUMP_2
		agf_highp float offset = 0.0;
		agf_highp float fMaxOffset = agf_bump_2_params[0];
		agf_highp float fMinOffset = agf_bump_2_params[1];
		offset = mix(fMinOffset, fMaxOffset, bumpLookup.x);
		agf_highp vec3 offsetPointEyeSpace = geomPointInEyeSpace.xyz-normalize(newNormal)*offset*bumpLookup.a*bumpNormalPreviewFlags[0];
		agf_highp vec3 zero_offsetPointEyeSpace = geomPointInEyeSpace.xyz;


		agf_highp vec3 dxPES = dFdx(offsetPointEyeSpace)/length(dFdx(zero_offsetPointEyeSpace));
		agf_highp vec3 dyPES = dFdy(offsetPointEyeSpace)/length(dFdy(zero_offsetPointEyeSpace));
		agf_highp vec3 slopeNormal = cross(dxPES, dyPES);
		
		agf_highp vec3 zero_dxPES = dFdx(zero_offsetPointEyeSpace)/length(dFdx(zero_offsetPointEyeSpace));
		agf_highp vec3 zero_dyPES = dFdy(zero_offsetPointEyeSpace)/length(dFdx(zero_offsetPointEyeSpace));
		agf_highp vec3 zero_slopeNormal = cross(zero_dxPES, zero_dyPES);
		
		agf_highp vec3 normalDelta = slopeNormal-zero_slopeNormal;
		newNormal = normalize(newNormal+normalDelta);
		bumpGradient = vec3(0.0, 0.0, 0.0);
#else
		agf_highp float x0,x1,y0,y1;
		x0 = xformTex2DOffset(bump_gradient_texture, UV, bump_gradient_texture_matrix, -bumpTextureNormalizer*vec4(1.0, 0.0, 0.0, 0.0)).r;
		x1 = xformTex2DOffset(bump_gradient_texture, UV, bump_gradient_texture_matrix, +bumpTextureNormalizer*vec4(1.0, 0.0, 0.0, 0.0)).r;
		y0 = xformTex2DOffset(bump_gradient_texture, UV, bump_gradient_texture_matrix, -bumpTextureNormalizer*vec4(0.0, 1.0, 0.0, 0.0)).r;
		y1 = xformTex2DOffset(bump_gradient_texture, UV, bump_gradient_texture_matrix, +bumpTextureNormalizer*vec4(0.0, 1.0, 0.0, 0.0)).r;
		bumpGradient.xyz = vec3(-(x1-x0)*unscaledIBLColor.a, -(y1-y0)*unscaledIBLColor.a, 0);
		bumpGradient.xyz = bumpGradient.xyz*(bumpStrength*2.0*bumpLookup.a*bumpNormalPreviewFlags[0]);
#endif
#endif

		agf_highp vec2 noiseBumpGradient = vec2(0.0, 0.0);
#if SAMPLER_3D_AVAILABLE
#ifdef HAS_VOLUME_BUMP_NOISE
//NoiseBump 
		agf_highp vec4 geomPointInBBOXSpace = iEyeToNormalizedBBOXMatrix*geomPointInEyeSpace;
		agf_highp vec4 params;
		params.x = volumeNoiseBumpParams[0];
		params.y = volumeNoiseBumpParams[1];
		params.z = 3.0;
		params.w = 0.0;
		agf_highp float duValue = PerlinNoise3D(volumeNoiseTexture, volumeNoiseBumpParams[2]*geomPointInBBOXSpace.xyz, params);
		agf_highp float dvValue = PerlinNoise3D(volumeNoiseTexture, volumeNoiseBumpParams[2]*geomPointInBBOXSpace.xyz+vec3(0.7, 0.7, 0.7), params);
	    noiseBumpGradient = volumeNoiseBumpParams[3]*vec2(duValue-0.5, dvValue-0.5); //
        if (agf_force_flat_shading[0]>0.5)
        {
            _t=vec3(1.0, 0.0, 0.0);
            _b=vec3(0.0, 1.0, 0.0);
        }
//gl_FragColor = vec4(duValue, dvValue, 1.0, 1.0);
//return;
#endif
#endif

		bumpGradient.xy = noiseBumpGradient+bumpGradient.xy;
		agf_highp vec3 normalDistortionTangentSpace = bumpGradient; //Alpha channel used to modulate bump strength
		agf_highp vec3 normalDistortionEyeSpace;
		normalDistortionEyeSpace.x = _t.x * normalDistortionTangentSpace.x + _b.x * normalDistortionTangentSpace.y;
		normalDistortionEyeSpace.y = _t.y * normalDistortionTangentSpace.x + _b.y * normalDistortionTangentSpace.y;
		normalDistortionEyeSpace.z = _t.z * normalDistortionTangentSpace.x + _b.z * normalDistortionTangentSpace.y;
		newNormal = normalize(newNormal + normalDistortionEyeSpace);


	//Determine if triangle is front/back facing
	if (gl_FrontFacing)//back-facing condition check
	   {
	   newNormal = -newNormal;
	   }
    else
	   {
	   newNormal = newNormal;
	   }

//###################################################### END OF NORMAL ALTERATION ##############################################

//###################################################### START OF COLOR CALCS ##############################################
   agf_highp vec4 finalColor = vec4(0.0, 0.0, 0.0, 0.0);
   agf_highp vec3 materialBaseColor = material.Kd.rgb;
    if (useVertexForBase[0]>0.5)
        {
        materialBaseColor = vertOut_Color.rgb;
        }
    agf_highp vec3 materialDiffuseColor = materialBaseColor;
#ifdef ENABLE_AGFSpecularColorMap
    texLookup =  xformTex2D(specular_intensity_texture, UV, specular_intensity_texture_matrix);
    agf_highp float specAlpha = texLookup.a*material.le_params[1];
    materialSpecularColor = mix(material.Ks.rgb, texLookup.rgb, specAlpha);
#endif

#ifdef ENABLE_AGFDiffuseMap
    texLookup = xformTex2D(diffuse_texture, UV, diffuse_texture_matrix);
    materialDiffuseColor = mix(materialBaseColor, texLookup.rgb, texLookup.a);
#endif
    if (refraction_flag[3]>0.5)
        {
        if (vertOut_Color.r > 0.0 || vertOut_Color.g > 0.0 || vertOut_Color.b > 0.0)
            materialDiffuseColor = vertOut_Color; //Show Repair Color
        }

    agf_highp vec3 diffuseColor = materialDiffuseColor;
    agf_highp vec3 specularColor = vec3(0, 0, 0);
    
    
//###################################################### CALCULATION OF THE SPECULAR EXPONENT  #################################
    agf_highp float shininess = material.shininess;
#ifdef ENABLE_AGFSpecularExponentMap
    //texLookup = tex2D(specular_exponent_texture, interpolant.fTexCoord0.xy);
    texLookup = xformTex2D(specular_exponent_texture, UV, specular_exponent_texture_matrix);
    shininess = mix(material.shininess, (1.0+180.0*texLookup.r), texLookup.a);
#endif

    agf_highp float metallic_scalar = material.metallic;
#ifdef ENABLE_AGFMetallicMap
    texLookup = xformTex2D(metallic_texture, UV,metallic_texture_matrix);
    metallic_scalar = mix(material.metallic, texLookup.b, texLookup.a);
#endif
    
#ifdef USE_ADOBE_MDL_SHADER
    
    agf_highp float roughnessValue = roughness.r;
#ifdef ENABLE_AGFRoughnessMap
    texLookup = xformTex2D(roughness_texture, UV,roughness_texture_matrix);
    roughnessValue = mix(roughnessValue, texLookup.g, texLookup.a);
#endif
    
    specularColor = diffuseColor;
    materialSpecularColor = diffuseColor;
    shininess = 2.0*pow(roughnessValue,-4.0)-2.0;
#endif
    
agf_highp vec3	materialAdjustedRoughnessSpecularColor = materialSpecularColor;


//############################################# DIRECT LIGHTING/SHADOWS CALCULATIONS #################################################
		agf_highp vec3 diff = vec3(0.0, 0.0, 0.0);
        agf_highp int hasLights=0;
#ifdef ENABLE_LIGHTING
		agf_highp vec3 spec = vec3(0.0, 0.0, 0.0);
		agf_highp int i=0;
		agf_highp vec3 diffNoShadowDummy=vec3(0.0, 0.0, 0.0);
		agf_highp float screenSpaceRandomNumber=0.0;

#if NUMBER_OF_ACTIVE_INFINITE_LIGHTS > 0
        hasLights = 1;
		for (i=0;i<NUMBER_OF_ACTIVE_INFINITE_LIGHTS;i++)
			{
			//infiniteLights[i].position = fmodelViewCamera * infiniteLights[i].position;	
			InfiniteLight transformedLight;
			transformedLight = infiniteLights[i];
			transformedLight.position = fmodelViewCamera * infiniteLights[i].position;	
			EvaluateInfiniteLight(newNormal, -(vertOut_vEye), transformedLight, diff, spec, diffNoShadowDummy, shininess,iEyeToWorldMatrix,screenSpaceRandomNumber);
			}
#endif
#if NUMBER_OF_ACTIVE_SPOT_LIGHTS > 0
        hasLights = 1;
		for (i=0;i<NUMBER_OF_ACTIVE_SPOT_LIGHTS;i++)
			{
			SpotLight transformedLight;
			transformedLight = spotLights[i];
			transformedLight.worldPosition = spotLights[i].position;
			transformedLight.position = fmodelViewCamera * spotLights[i].position;	
			transformedLight.direction = fmodelViewCamera * spotLights[i].direction;	
			EvaluateSpotLight(newNormal, -(vertOut_vEye), transformedLight, diff, spec, diffNoShadowDummy, shininess,iEyeToWorldMatrix,screenSpaceRandomNumber);
			}
#endif
#if NUMBER_OF_ACTIVE_POINT_LIGHTS > 0
        hasLights = 1;
		for (i=0;i<NUMBER_OF_ACTIVE_POINT_LIGHTS;i++)
			{
			PointLight transformedLight;

			transformedLight = pointLights[i];
			transformedLight.worldPosition = pointLights[i].position;
			transformedLight.position = fmodelViewCamera * pointLights[i].position;	
			EvaluatePointLight(newNormal, -(vertOut_vEye), transformedLight, diff, spec, diffNoShadowDummy, shininess,iEyeToWorldMatrix,screenSpaceRandomNumber);
			}
#endif
#ifdef FORCE_DIFFUSE_NO_SHADOWS

	diff = diffNoShadowDummy;

#else


#endif

		diff = diff*material.le_params[2];//exposure
		spec = spec*material.le_params[2];//exposure
		//Ambient term should be added here, but since our ambient light component is always 0, we skip it
		diffuseColor.rgb = (diff+material.Ke.rgb)*materialDiffuseColor;

  //falco - Changed this so this calc works with the old AGF Phong code
        //specularColor.rgb = material.le_params[3]*materialAdjustedRoughnessSpecularColor*spec;
		specularColor.rgb = material.le_params[3]*materialSpecularColor*spec;
  
  
#endif

#ifdef ZERO_LIGHTS
		//Special case for full-shaded mode with zero lights
		diffuseColor.rgb = (material.Ke.rgb)*materialDiffuseColor;
		specularColor.rgb = vec3(0.0, 0.0, 0.0);
#endif

#ifdef USE_ADOBE_MDL_SHADER
    {
        if(hasLights > 0)
        {
            diffuseColor.rgb = materialDiffuseColor+specularColor.rgb;
        }
        
        agf_highp vec3 emitted_energy;
        #ifdef ENABLE_AGFSelfIlluminationMap
                agf_highp vec4 selfIlluminationColor;
                selfIlluminationColor = xformTex2D(self_illumination_texture, UV, self_illumination_texture_matrix).rgba;
                agf_highp vec3 rescaledSelfIlluminationColor;
                rescaledSelfIlluminationColor.r = mix(self_illumination_texture_range[0],self_illumination_texture_range[1], selfIlluminationColor.r);
                rescaledSelfIlluminationColor.g = mix(self_illumination_texture_range[0],self_illumination_texture_range[1], selfIlluminationColor.g);
                rescaledSelfIlluminationColor.b = mix(self_illumination_texture_range[0],self_illumination_texture_range[1], selfIlluminationColor.b);
                emitted_energy = mix(material.selfillum.rgb,rescaledSelfIlluminationColor.rgb, selfIlluminationColor.a);
        #else
                emitted_energy = material.selfillum.rgb;
        #endif
        


        agf_highp float reflectivity = 0.08;//material.reflectivity;

          // Set up mdl parameters
          agf_highp float ibl_visibility = iblIntensity * 10.0; 
          agf_highp float ior = material.ior;
          agf_highp vec3 Vcamera = normalize(-vertOut_vEye);
          agf_highp vec3 Nvert = normalize(newNormal);
          agf_highp vec3 V = Vcamera;
          agf_highp vec3 base_color_linear = materialDiffuseColor;
          agf_highp vec3 accumulated_light = diff*base_color_linear;
          agf_highp vec3 N = normalize(newNormal);

          agf_highp vec3 F0 = mix(vec3(reflectivity), base_color_linear, metallic_scalar);
          //Hack - value of 1.0 seems to have issues
          roughnessValue = clamp(roughnessValue, 0.01, 0.99);
          agf_highp vec2 specular_bsdf = get_specular_brdf(roughnessValue, N, V, Nvert);
          agf_highp float transmittance = translucence_scalar * specular_bsdf.x;
          agf_highp float refr_opacity = 1.0;

//Debugging
//         float dp = 1.0-safe_dot(N, V);
//         gl_FragColor.rgb = vec3(dp, specular_bsdf.x, specular_bsdf.y);
//         //gl_FragColor.rgb = vec3(vertOut_vNormal.x, vertOut_vNormal.y, vertOut_vNormal.z);
//         gl_FragColor.a = 1.0;
//         return;

          //
          // Front-facing surface shading with IBL contribution (and back-facing surface shading when there is no refraction)
          //
          agf_highp float NdV = dot(N,V);
          if( NdV >= 0.0 || translucence_scalar < 0.01) {
            // diffuse
            agf_highp float diffuse_energy = (1.0 - reflectivity) * (1.0 - metallic_scalar) * 2.0 / PI;
            agf_highp vec3 diffuse_light = base_color_linear * (sample_environment(N, 0.9)) * vec3(diffuse_energy);
            accumulated_light += (1.0 - transmittance) * diffuse_light * ibl_visibility;

            // reflection
            agf_highp vec3 reflected_light = get_specular_ibl(F0, roughnessValue, N, V, specular_bsdf);
            accumulated_light += reflected_light * ibl_visibility;

            //
            // Emission
            //

            agf_highp vec3 glow_linear = base_color_linear*emitted_energy;
            accumulated_light += glow_linear;

            //
            // Refraction (front-facing surface)
            //
            if (translucence_scalar > 0.01) {
              // Scattering contribution -- guaranteed to be [0.0,1.0)
              agf_highp float scattering = 0.0;
              if (material.density>0.0)
                scattering = pow(0.5, 1.0 / (material.density));

              // refr_opacity is the probability the light will not make it to the backface surface
              refr_opacity = mix( clamp(1.0 - transmittance + reflectivity, 0.0, 1.0), 1.0, scattering );

              // interior color contributes according to density and transmittance
              agf_highp vec3 refr_color = mix(diffuse_light * vec3(1.0 - transmittance), material.interiorColor.rgb, scattering * transmittance );

              // front face surface accumulation
              accumulated_light += refr_color * transmittance;
            }
        } 
        else 
        {
            //
            // Backface rendering when there is refraction (for stochastic refraction hackery)
            // This is a tricky hack to make translucent objects look translucent...
            //

            // always permit half of the rays through so that the user can see surfaces behind this one
            // rough transparent objects are more or less opaque
            refr_opacity = clamp((1.0 + roughnessValue) / 2.0, 0.0, 1.0);

            // We can't know how the real rays would have bounced around the object, but if we pretend the object
            // is a unit sphere, we can approximate the refraction of round objects

            // Calculate normal of entry point (if the object was a unit sphere)... remember this is the back face
            agf_highp vec3 Nfront = -normalize(reflect(-N, -V));

            // Figure out transmitted exit vector of both front and back surface
            agf_highp vec3 T = double_refract(-V, Nfront, ior);

            // Sample environment in refracted direction
            agf_highp vec3 refr_color = base_color_linear * sample_environment(T, roughnessValue);

            // backface refracted color supersedes accumulated color -- we don't do surface shading on backfaces
            accumulated_light = refr_color;
          }


          //finalColor = vec4(diffuseColor.rgb, finalOpacity);
          finalColor = vec4(accumulated_light, finalOpacity);
    }
//#endif //#ifdef ENABLE_AGFSphereEnvironmentMap
#endif //USE_ADOBE_MDL_SHADER

#ifdef USE_PHOTOSHOP_LEGACY_SHADER
    {
//###################################################### ADJUSTMENT OF THE SPECULAR COLOR BASED ON ROUGHNESS VALUE  #############

#ifdef ENABLE_ROUGHNESS
agf_highp float roughnessValue = roughness.r;
#ifdef ENABLE_AGFRoughnessMap
        texLookup = xformTex2D(roughness_texture, UV,roughness_texture_matrix);
        roughnessValue = mix(roughness.r, texLookup.r, texLookup.a);
#endif
    roughnessValue = roughnessValue*0.5;
    
    agf_highp float roughnessSigma = roughnessValue;
    agf_highp float phongSigma = acos(exp(-1.0/(2.0*shininess)));
    agf_highp float newSigma = sqrt(phongSigma*phongSigma+roughnessSigma*roughnessSigma);
    shininess = (-1.0/(2.0*log(cos(newSigma))));
    agf_highp float specColorFadeout = phongSigma/newSigma;
    agf_highp float specColorFadeoutSquared = specColorFadeout*specColorFadeout;
    agf_highp vec3  specColorFadeout3 = vec3(specColorFadeoutSquared, specColorFadeoutSquared, specColorFadeoutSquared);
    materialAdjustedRoughnessSpecularColor = materialSpecularColor*specColorFadeout3;
#endif

#ifdef ZERO_LIGHTS
        //Special case for full-shaded mode with zero lights
        diffuseColor.rgb = (material.Ke.rgb)*materialDiffuseColor;
        specularColor.rgb = vec3(0.0, 0.0, 0.0);
#endif

//############################################# IMAGE-BASED LIGHTING (SPHERICAL HARMONICS) #################################################
    agf_highp vec3 iblDiffuseOnly=vec3(0.0, 0.0, 0.0);
#ifdef ENABLE_IBL
        agf_highp vec4 normal1 = newNormal.xyzz;
        normal1.w = 0.0;
        agf_highp vec4 normalIBL = (sphericalHarmonicsTransformationMatrix * normal1);
        normalIBL.w = 0.0;
        normalize(normalIBL);
        normalIBL.w = 1.0;
        agf_highp vec3   diffuse_intensity =  materialDiffuseColor ;
        iblDiffuseOnly = vec3(    dot(normalIBL, (sphericalHarmonicMatrixRed*normalIBL)),
                                dot(normalIBL, (sphericalHarmonicMatrixGreen*normalIBL)),
                                dot(normalIBL, (sphericalHarmonicMatrixBlue*normalIBL)) );
         agf_highp vec3 diffuseIBL = diffuse_intensity * iblDiffuseOnly;
         //diffuseIBL = texSPHERE(IBLTexture, normalIBL.xyz).rgb; //For Debugging env. orientation only - use tex sample instead of spherical harmonic
        diffuseColor.rgb += diffuseIBL;
#endif

if (material.selfillum.a < 0.5)
    {
        //ALBEDO-only mode
        diffuseColor.rgb = materialDiffuseColor;
        specularColor.rgb = vec3(0.0, 0.0, 0.0);
    }
if (material.selfillum.a == 2.0)
    {
        //Diffuse-lighting-only mode
        diffuseColor.rgb = diff+material.Ke.rgb+iblDiffuseOnly;
        specularColor.rgb = vec3(0.0, 0.0, 0.0);
    }
    
    finalColor.rgb = diffuseColor.rgb+specularColor.rgb;
    finalColor.a = material.opacity;

#if defined(ENVIRONMENT_PASS_SHADER) || defined(OPACITY_SELF_ILLUM_PASS_SHADER)
    finalColor = vec4(0.0, 0.0, 0.0, 1.0);
#endif



//############################################# ENVIRONMENT MAPPING + IBL SPECULAR HIGHLIGHTS #################################################

agf_highp vec4 reflColor = environmentColor;
agf_highp vec4 iblSpecularHighlightsContribution = vec4(0.0, 0.0, 0.0, 0.0);

        //Update the reflection vector
        agf_highp vec4 t_reflect;
        agf_highp vec3 reflectionVector;
        if (agf_force_flat_shading[1]>0.5)
            t_reflect.xyz = reflect(vec3(0, 0, -1), newNormal); //Parallel Projection
        else
            t_reflect.xyz = reflect(normalize(vertOut_vPosition.xyz), newNormal); //Perspective Projection
        t_reflect.w = 0.0;
#ifdef ENABLE_AGFSphereEnvironmentMap

        reflectionVector = (reflectionTransformationMatrix * t_reflect).xyz;
        texLookup = texSPHERE(environment_texture,environment_texture_matrix, reflectionVector);
        reflColor.rgb = mix(unscaledIBLColor.rgb, texLookup.rgb, texLookup.a);
        //reflColor.rgb = vec3(0, 0, 0);
        
        agf_highp float texStep = 1.0/16.0;
        agf_highp float texOffset = 1.0/(16.0*2.0);
#ifdef ENABLE_ADVANCED_REFRACTION_REFLECTION
#ifdef ENABLE_IBL_SPECULAR_HIGHLIGHTS

        agf_highp vec3 minShinyColor = texLookup.rgb;
        agf_highp vec3 maxShinyColor = texLookup.rgb;
        agf_highp vec3 mediumShinyColor = texLookup.rgb;
#if SAMPLER_3D_AVAILABLE
        texLookup=texSPHEREMULTI(discreteShininess3DTex, environment_texture_matrix, vec4(1.0/9.0, 1.0/9.0, 2.0*texStep+texOffset, 1.0), reflectionVector);
        minShinyColor = mix(environmentColor.rgb, texLookup.rgb, texLookup.a);

        texLookup=texSPHEREMULTI(discreteShininess3DTex, environment_texture_matrix, vec4(1.0/1.0, 1.0/1.0, 0.0*texStep+texOffset, 1.0), reflectionVector);
        maxShinyColor = mix(environmentColor.rgb, texLookup.rgb, texLookup.a);

        texLookup=texSPHEREMULTI(discreteShininess3DTex, environment_texture_matrix, vec4(1.0/3.0, 1.0/3.0, 1.0*texStep+texOffset, 1.0), reflectionVector);
        mediumShinyColor = mix(environmentColor.rgb, texLookup.rgb, texLookup.a);
#endif //#if SAMPLER_3D_AVAILABLE
        agf_highp float lt = 0.0;
        
        if (shininess<20.0)
            {
            lt = shininess/20.0;
            iblSpecularHighlightsContribution.rgb = mix(minShinyColor, mediumShinyColor, lt);
            }
        else
            {
            lt = (shininess-20.0)/492.0;
            iblSpecularHighlightsContribution.rgb = mix(mediumShinyColor, maxShinyColor, lt);
            }
        iblSpecularHighlightsContribution.rgb = iblSpecularHighlightsContribution.rgb*materialSpecularColor.rgb*iGlobalAmbientColor.a;
        iblSpecularHighlightsContribution.a = 0.0;
#endif
        
#if SAMPLER_3D_AVAILABLE
#ifdef ENABLE_ROUGHNESS
        agf_highp vec4 color0 = reflColor.rgba;
        agf_highp vec4 color1 = texSPHEREMULTI(discreteShininess3DTex, environment_texture_matrix, vec4(1.0, 1.0, 3.0*texStep+texOffset, 1.0), reflectionVector);
        agf_highp float t = roughnessValue/0.1;
        agf_highp vec4 roughReflectionColor = mix(color0, color1, t);
         if (roughnessValue>0.1)
             {
             agf_highp float texZ;
             t = (roughnessValue-0.1)/0.9;
             texZ = mix(3.0*texStep+texOffset, 12.0*texStep+texOffset, t);
             roughReflectionColor = texSPHEREMULTI(discreteShininess3DTex, environment_texture_matrix, vec4(1.0/1.0, 1.0, texZ, 1.0), reflectionVector);
             }
        
        reflColor.rgb = roughReflectionColor.rgb;
#endif //ENABLE_ROUGHNESS
#endif //#if SAMPLER_3D_AVAILABLE

#endif
        
        
#endif
        reflColor.a = 0.0;

//############################################# ADJUSTING reflColor with REFLECTIVITY VALUE #################################################

        agf_highp vec3 materialReflectivity3 = vec3(material.reflectivity);
#ifdef ENABLE_AGFReflectivityMap
        agf_highp vec3 reflectivity;
        texLookup = xformTex2D(reflectivity_texture, UV,reflectivity_texture_matrix);
        reflectivity = mix(materialReflectivity3, texLookup.rgb, texLookup.a); //Default reflectivity is non-reflective, for now
        reflColor.rgb = reflColor.rgb*reflectivity;
#else
        reflColor.rgb = reflColor.rgb*materialReflectivity3;
#endif

if (material.selfillum.a < 1.5)
    {
   //Do not add reflections for lighting-only mode
    finalColor = finalColor + reflColor + iblSpecularHighlightsContribution;
    }

//########################################## ADDING SELF-ILLUMINATION ########################################################################
#ifdef ENABLE_AGFSelfIlluminationMap
        agf_highp vec4 selfIlluminationColor;
        selfIlluminationColor = xformTex2D(self_illumination_texture, UV, self_illumination_texture_matrix).rgba;
        agf_highp vec3 rescaledSelfIlluminationColor;
        rescaledSelfIlluminationColor.r = mix(self_illumination_texture_range[0],self_illumination_texture_range[1], selfIlluminationColor.r);
        rescaledSelfIlluminationColor.g = mix(self_illumination_texture_range[0],self_illumination_texture_range[1], selfIlluminationColor.g);
        rescaledSelfIlluminationColor.b = mix(self_illumination_texture_range[0],self_illumination_texture_range[1], selfIlluminationColor.b);
        agf_highp vec3 blendedSelfIlluminationColor = mix(material.selfillum.rgb,rescaledSelfIlluminationColor.rgb, selfIlluminationColor.a);
        finalColor.rgb = finalColor.rgb + blendedSelfIlluminationColor;
#else
        finalColor.rgb = finalColor.rgb + material.selfillum.rgb;
#endif
        //float opacity = mainColor.a;





//########################################## REFRACTION #####################################################################################
#ifdef ENABLE_ADVANCED_REFRACTION_REFLECTION
        if (refraction_flag[0]>0.5)
        {
        agf_highp vec3 refractedRay;
        agf_highp vec4 t_refract;
        t_refract.xyz = refract(normalize(vertOut_vPosition.xyz), newNormal, 1.0/material.ior);
        t_refract.w = 0.0;
        refractedRay = (refractionTransformationMatrix * t_refract).xyz;
        agf_highp vec4 refractedColor;
        refractedColor = texSPHERE(background_texture,background_texture_matrix, refractedRay);
        finalColor.rgb = mix(refractedColor.rgb, finalColor.rgb, opacity);
        finalColor.a = refractedColor.a;
        }
#endif


//########################################## FINAL PROCESSING ################################################################################

        finalColor.a = finalOpacity;
    }
#endif //USE_PHOTOSHOP_LEGACY_SHADER



#ifdef ENABLE_ALPHA_PREMULTIPLY
		finalColor.rgb = finalColor.rgb*finalColor.a;
#endif

#if 0
 //Testing the noise function
		agf_highp vec4 geomPointInEyeSpace = vec4(vertOut_vEye, 1.0);
		agf_highp vec4 geomPointInBBOXSpace = iEyeToNormalizedBBOXMatrix*geomPointInEyeSpace;
		agf_highp vec3 params;
		params.x = 2.0;//material.reflectivity*4.0;
		params.y = 1.8;//material.opacity*4.0;
		params.z = 3.0;
		agf_highp float noiseValue = PerlinNoise3D(volumeNoiseTexture, 5.0*geomPointInBBOXSpace.xyz, params);
		finalColor.rgb = vec3(noiseValue, noiseValue, noiseValue);
		finalColor.a = 1.0;
#endif

//	float noiseTest = crand(gl_FragCoord.xy);
//	finalColor.rgb = vec3(noiseTest, noiseTest, noiseTest);

#ifdef FORCE_DIFFUSE_NO_SHADOWS

	gl_FragColor.rgb = diffuseColor.rgb;
	gl_FragColor.a = 1.0;

#else

	gl_FragColor = finalColor;

#endif

#endif

}
