/** This file contains common JavaScript constructs used by the Photoshop
native extension implementation.
*/

// --------------------------------------------------------------------------------

/** Wrapper function used by executeAsModal to track the state of a target
*/
async function _internalExecuteAsModalWrapper(jsFunction, executionControl) {
    try {
        let result = await jsFunction(executionControl);
        executionControl.resolve(result)
    }
    catch (error) {
        executionControl.reject(error);
    }
}
