/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */

var logger      = require("../LogUtils"),
    Path        = require("path"),
    Q           = require("q"),
    StringUtils = require("../StringUtils");

var JSXRunner;

(function () {

    "use strict";

    /** inits the jmeta data read with a jsx runner like a faux dependency injection tool */
    var init = function(jsxrunner) {
        JSXRunner = jsxrunner;

    };
    /**
     * Read copyright & contact info metadata from the currently active document in photoshop
     * to get the in memory settings instead of the ones saved to disk
     *
     * @param {bool} includeUserMetadata include user metadata for copyright and contact info
     */
    var readMetadata = function (includeUserMetadata) {
        if(!JSXRunner) {
            logger.warn("Please call init with a jsxrunner");
            return  Q.defer().reject();
        }

        var deferred = Q.defer(),
            json2JsPath = Path.resolve(__dirname, "./json2.js"),
            escapedJson2JsPath = StringUtils.escapeForCodeContext(json2JsPath);

        JSXRunner.executeJSX("readFileMetadata", {json2Path: escapedJson2JsPath, includeUserMetadata:includeUserMetadata}).then(function (data) {
            if (data.charAt(0) !== "[") {
                deferred.reject();
            } else {
                deferred.resolve(data);
            }
        });
        return deferred.promise;
    };

    /**
     * Write copyright & contact info metadata to the (newly-exported asset) file at the given path
     */
    var writeMetadata = function (path, metadata) {
        if(!JSXRunner) {
            logger.warn("Please call init with a jsxrunner");
            return  Q.defer().reject();
        }
        var json2JsPath = Path.resolve(__dirname, "./json2.js"),
            escapedJson2JsPath = StringUtils.escapeForCodeContext(json2JsPath),
            escapedPath = StringUtils.escapeForCodeContext(path),
            escapedMD = metadata;

        return JSXRunner.executeJSX("writeFileMetadata", {json2Path:escapedJson2JsPath, filePath: escapedPath, metadataStr: escapedMD});
    };

    module.exports = {
        readMetadata: readMetadata,
        writeMetadata: writeMetadata,
        init: init
    };
}());
