//agf_include "vertex2fragment_uv2.glsl"

agf_highp float shadeAAlineAlongOneDimension(agf_highp vec4 texelCorners, agf_highp vec2 lineRanges)
{
	agf_highp float leftside = lineRanges[0];
	agf_highp float rightside = lineRanges[1];
	agf_highp float d00 = texelCorners[0] - leftside;
	agf_highp float d01 = texelCorners[1] - leftside;
	agf_highp float d10 = texelCorners[2] - leftside;
	agf_highp float d11 = texelCorners[3] - leftside;
	agf_highp float positiveWeight = 0.0;
	agf_highp float negativeWeight = 0.0;
	if (d00 > 0.0) positiveWeight += d00; else	negativeWeight += (-d00);
	if (d01 > 0.0) positiveWeight += d01; else	negativeWeight += (-d01);
	if (d10 > 0.0) positiveWeight += d10; else	negativeWeight += (-d10);
	if (d11 > 0.0) positiveWeight += d11; else	negativeWeight += (-d11);
	agf_highp float alpha = 0.0;
	if (positiveWeight > 0.0)
	{
		if (negativeWeight > 0.0)
			alpha = positiveWeight / (positiveWeight + negativeWeight);
		else
		{
			positiveWeight = 0.0;
			negativeWeight = 0.0;
			d00 = rightside - texelCorners[0];
			d01 = rightside - texelCorners[1];
			d10 = rightside - texelCorners[2];
			d11 = rightside - texelCorners[3];
			if (d00 > 0.0) positiveWeight += d00; else	negativeWeight += (-d00);
			if (d01 > 0.0) positiveWeight += d01; else	negativeWeight += (-d01);
			if (d10 > 0.0) positiveWeight += d10; else	negativeWeight += (-d10);
			if (d11 > 0.0) positiveWeight += d11; else	negativeWeight += (-d11);
			alpha = positiveWeight / (positiveWeight + negativeWeight);
		}
	}
	return alpha;
}
uniform agf_highp vec4 groundPlaneColorOpacity;
uniform agf_highp vec4 groundPlaneDistanceFadeColorOpacity;
uniform agf_highp vec2 groundPlaneLineThickness;
uniform agf_highp vec3 groundPlaneUColor;
uniform agf_highp vec3 groundPlaneVColor;
uniform agf_highp vec4 printPlateSizeUV;
uniform agf_highp vec3 printPlateColor;
uniform agf_highp vec2 tickEveryUV;

void main()
{
	agf_highp float U = vertOut_UV.x;
	agf_highp float V = vertOut_UV.y;
	agf_highp vec2 dX = dFdx(vertOut_UV.xy);
	agf_highp vec2 dY = dFdy(vertOut_UV.xy);
	agf_highp float dXu = dX.x;
	agf_highp float dXv = dX.y;
	agf_highp float dYu = dY.x;
	agf_highp float dYv = dY.y;
	agf_highp vec2 uvPixSize;
	uvPixSize.x = sqrt(dXu*dXu + dYu*dYu);
	uvPixSize.y = sqrt(dXv*dXv + dYv*dYv);
	//
	agf_highp vec2  uvSpacingFactor = vec2(1.0, 1.0);
	uvSpacingFactor.x = float((uvPixSize.x / 0.25));
	uvSpacingFactor.y = float((uvPixSize.y / 0.25));
	agf_highp float averageSpacing = (max(uvSpacingFactor.x, uvSpacingFactor.y));
	agf_highp vec2 kernelSize = vec2(0.5, 0.5);
	agf_highp float clutterOpacityFactor = 1.0;
	agf_highp vec2 uvMultiplier = vec2(1.0, 1.0);
	if (averageSpacing > 1.0)
	{
		clutterOpacityFactor = 1.0 / (averageSpacing*averageSpacing);
		//kernelSize *= 1.0/(averageSpacing);
	}
	agf_highp vec2 thickness = vec2(groundPlaneLineThickness[0], groundPlaneLineThickness[0]);
	agf_highp vec3 color = groundPlaneColorOpacity.rgb;
	if (abs(U) < 2.0*uvPixSize.x)
	{
		color = groundPlaneVColor;
		thickness.x = groundPlaneLineThickness[1];
		thickness.y = groundPlaneLineThickness[1];
	}
	if (abs(V) < 2.0*uvPixSize.y)
	{
		color = groundPlaneUColor;
		thickness.x = groundPlaneLineThickness[1];
		thickness.y = groundPlaneLineThickness[1];
	}
	agf_highp vec2 uv00 = vertOut_UV.xy - kernelSize.x*dX - kernelSize.y*dY + vec2(0.5, 0.5);
	agf_highp vec2 uv01 = vertOut_UV.xy - kernelSize.x*dX + kernelSize.y*dY + vec2(0.5, 0.5);
	agf_highp vec2 uv11 = vertOut_UV.xy + kernelSize.x*dX + kernelSize.y*dY + vec2(0.5, 0.5);
	agf_highp vec2 uv10 = vertOut_UV.xy + kernelSize.x*dX - kernelSize.y*dY + vec2(0.5, 0.5);
	uv00 *= uvMultiplier;
	uv01 *= uvMultiplier;
	uv11 *= uvMultiplier;
	uv10 *= uvMultiplier;
	agf_highp vec2 iUV00 = vec2(floor(uv00));
	agf_highp vec2 iUV01 = vec2(floor(uv01));
	agf_highp vec2 iUV11 = vec2(floor(uv11));
	agf_highp vec2 iUV10 = vec2(floor(uv10));
	agf_highp float lineFaloffAlpha = 0.0;
	agf_highp vec2 nuv00 = uv00 - iUV00;
	agf_highp vec2 nuv01 = uv01 - iUV01;
	agf_highp vec2 nuv11 = uv11 - iUV11;
	agf_highp vec2 nuv10 = uv10 - iUV10;
	agf_highp vec2 lineD;
	agf_highp float alphaU = 0.0;
	agf_highp float alphaV = 0.0;
	agf_highp vec2 min0 = min(iUV00, iUV01);
	agf_highp vec2 min1 = min(iUV11, iUV10);
	agf_highp vec2 min_int = min(min0, min1);
	if (iUV00.x > min_int.x) nuv00.x += 1.0;
	if (iUV01.x > min_int.x) nuv01.x += 1.0;
	if (iUV10.x > min_int.x) nuv10.x += 1.0;
	if (iUV11.x > min_int.x) nuv11.x += 1.0;
	if (iUV00.y > min_int.y) nuv00.y += 1.0;
	if (iUV01.y > min_int.y) nuv01.y += 1.0;
	if (iUV10.y > min_int.y) nuv10.y += 1.0;
	if (iUV11.y > min_int.y) nuv11.y += 1.0;
	agf_highp float xticks = tickEveryUV.x;
	agf_highp float yticks = tickEveryUV.y;
	agf_highp vec2 uLineD = vec2(0.5 - thickness.x*uvPixSize.x*0.5, 0.5 + thickness.x*uvPixSize.x*0.5);
	agf_highp vec4 uCorners = vec4(nuv00.x, nuv01.x, nuv10.x, nuv11.x);
	alphaU = max(alphaU, shadeAAlineAlongOneDimension(uCorners, uLineD));
	agf_highp float i = 0.0;
	agf_highp float tf = 0.0;
	agf_highp float onPrintPlate = 0.0;
	if (printPlateSizeUV.x > 0.0 && printPlateSizeUV.y > 0.0)
		{
		if (abs(U) < printPlateSizeUV.x*0.5 && abs(V) < printPlateSizeUV.y*0.5)
			{
			onPrintPlate = 1.0;
			}
		}
	if (abs(V) < 0.4 && onPrintPlate > 0.5)
	{
		for (i = 0.0; i <= 1.0 + xticks; i = i + xticks)
		{
			tf = 0.25;
			if (i >= 1.0)
			{
				tf = 0.5;
			}
			else
			{
				if (abs(V) > 0.2)  tf = 0.0;
			}
			if (tf > 0.0)
			{
				agf_highp vec2 uTickD = vec2(i - thickness.x*uvPixSize.x*tf, i + thickness.x*uvPixSize.x*tf);
				alphaU = max(alphaU, shadeAAlineAlongOneDimension(uCorners, uTickD));
			}
		}
	}
	agf_highp vec2 vLineD = vec2(0.5 - thickness.y*uvPixSize.y*0.5, 0.5 + thickness.y*uvPixSize.y*0.5);
	agf_highp vec4 vCorners = vec4(nuv00.y, nuv01.y, nuv10.y, nuv11.y);
	alphaV = shadeAAlineAlongOneDimension(vCorners, vLineD);
	if (abs(U) < 0.4 && onPrintPlate > 0.5)
	{
		for (i = 0.0; i <= 1.0 + yticks; i = i + yticks)
		{
			tf = 0.25;
			if (i >= 1.0)
			{
				tf = 0.5;
			}
			else
			{
				if (abs(U) > 0.2)  tf = 0.0;
			}
			if (tf > 0.0)
			{
				agf_highp vec2 vTickD = vec2(i - thickness.x*uvPixSize.x*tf, i + thickness.x*uvPixSize.x*tf);
				alphaV = max(alphaV, shadeAAlineAlongOneDimension(vCorners, vTickD));
			}
		}
	}
	lineFaloffAlpha = clamp(1.0 - (1.0 - alphaU)*(1.0 - alphaV), 0.0, 1.0);
	agf_highp float alpha = groundPlaneColorOpacity.a*((1.0 - clutterOpacityFactor)*groundPlaneDistanceFadeColorOpacity.a + clutterOpacityFactor*lineFaloffAlpha);
	agf_highp vec4 lineColor = vec4(color.r, color.g, color.b, alpha);
	if (onPrintPlate > 0.5)
	{
		lineColor.rgb = mix(printPlateColor, lineColor.rgb, alpha);
		lineColor.a = 1.0;
	}
	else
	{
		if (printPlateSizeUV.z < 0.5)
		{
			lineColor.a = 0.0; //In-3Dprint-dialog case
		}
	}
	lineColor.a = lineColor.a * printPlateSizeUV.a;
	gl_FragColor = lineColor;
}
