
#define M_PI		3.1415926535898
/***********************************************************************/
agf_highp vec2 uvSPHERE(in agf_highp vec3 iSphereVector)
{
   agf_highp  vec2 uv;
    uv.y = (acos(abs(iSphereVector.y))/M_PI);
    if (iSphereVector.y<0.0) uv.y = 1.0-uv.y;
    uv.x = (atan(iSphereVector.x, iSphereVector.z)+M_PI)/(2.0*M_PI);
    return uv;
}
/***********************************************************************/
agf_highp vec4 texSPHERE(in agf_highp sampler2D sphereTex, in agf_highp mat4 textureMatrix, in agf_highp vec3 lookup_vector)
{
    agf_highp vec2 index;
    agf_highp vec3 reflectDir;
    agf_highp vec4 sphereColor;
    index = uvSPHERE(lookup_vector);
    agf_highp vec4 homogeneousUVindex = vec4(index, 0, 1);
    sphereColor = xformTex2D(sphereTex, homogeneousUVindex, textureMatrix);
    return sphereColor;
}
agf_highp vec4 texSPHEREIdentity(in agf_highp sampler2D sphereTex, in agf_highp vec3 lookup_vector)
{
    agf_highp vec2 index;
    agf_highp vec3 reflectDir;
    agf_highp vec4 sphereColor;
    index = uvSPHERE(lookup_vector);
    sphereColor = texture2D(sphereTex, index);
    return sphereColor;
}
/***********************************************************************/






	  
