/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// A WorkflowEnvironment is create with each start of a workflow processing.
// It provides information and functionality which can be used by any
// workflow executable (actions/conditions)
//
function WorkflowEnvironment(/*Workflow*/ inWorkflow)
{
	var workflow = Utils.getParamValue(inWorkflow, Utils.REQUIRED);

	this.id 		= workflow.getID();
	this.step 		= NaN;
	this.stepLength = workflow.getStepLength();
	this.event 		= null;
	this.display 	= [];
	this.userData	= {};	// user data object to store any data during workflow processing

	//////////////////////////////////////////////////////////////////////////////
	//
	// Test if both parameter values are equal. Also consider that one or both
	// values might be moniker
	//
	this.equal = function(/*String*/ inValue1, /*String*/ inValue2)
	{
		// make sure we are working with strings!
		var str1 = String(Utils.getParamValue(inValue1, Utils.OPTIONAL, ''));
		var str2 = String(Utils.getParamValue(inValue2, Utils.OPTIONAL, ''));

		// The function getMoniker(...) returns an Array of moniker, because different
		// moniker could have the same value. And so each returned moniker needs
		// to be compared with all other
		//
		var mon1 = MonikerMapper.get().getMoniker(str1);
		var mon2 = MonikerMapper.get().getMoniker(str2);

		var match = false;

		for (var n1=0; n1<mon1.length && !match; n1++)
		{
			for (var n2=0; n2<mon2.length; n2++)
			{
				match = (mon1[n1] == mon2[n2]);
			}
		}

		return match;
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Set override value. inID could be a moniker
	//
	this.setOverride = function(/*String*/ inID, /*Any*/ inValue)
	{
		var identifier = MonikerMapper.get().getValue(inID);
		ScriptedWorkflowSupport.instance.setOverrideData(identifier, inValue);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Set one or more override. The input object needs to follow the format:
	// {
	//     "identifier1" : value1,
	//     "identifier2" : value2,
	//     :
	// }
	//
	// Each identifier could be a moniker also.
	//
	this.setOverrides = function(/*{*String* id1 : *Any* value1, *String* id2 : *Any* value2, ...}*/ inOverrides)
	{
		if (Utils.isValidProperty(inOverrides, Object))
		{
			for (var id in inOverrides)
			{
				if (inOverrides.hasOwnProperty(id))
				{
					this.setOverride(id, inOverrides[id]);
				}
			}
		}
	}

	this.clearOverrides = function()
	{
		ScriptedWorkflowSupport.instance.clearOverrides();
	}
}

//////////////////////////////////////////////////////////////////////////////
//
WorkflowEnvironment.current = null;

//////////////////////////////////////////////////////////////////////////////
//
// Create new WorkflowEnvironment
//
WorkflowEnvironment.create = function(/*Workflow*/ inWorkflow)
{
	WorkflowEnvironment.current = new WorkflowEnvironment(inWorkflow);
}

//////////////////////////////////////////////////////////////////////////////
//
// Dispose current WorkflowEnvironment
//
WorkflowEnvironment.dispose = function()
{
	WorkflowEnvironment.current = null;
}