/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

var kEventTypesFile = 'eventtypes.json';

//////////////////////////////////////////////////////////////////////////////
//
// ScriptEventTypes provides all script event types which are used for
// user action tracking.
//
// The event types are provided by the application in the file eventtypes.json
// located in the scripts folder with the format:
//  [
//		"eventtype_1",
//		"eventtype_2",
//		:
//  ]
//
function ScriptEventTypes()
{
	var eventtypes = [];
	var initialized = false;

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return Array of all known script event types
	//
	this.getAll = function()
	{
		return eventtypes;
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return true if inType exists
	// (Returns also true if the file couldn't be laoded)
	//
	this.exists = function(/*String*/ inType)
	{
		return (eventtypes.indexOf(inType) >= 0 || inType == '*' || (initialized && eventtypes.length == 0));
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	function loadEventTypes(/*String*/ inPath)
	{
		var path = Utils.getParamValue(inPath, Utils.OPTIONAL, '');

		logInfo('About to load event types file from ' + path);

		try
		{
			DataRequestManager.requestJSONData(inPath, function(/*Boolean*/ inSuccess, /*Object*/ inJSON)
			{
				initialized = true;

				logInfo('Loading event types file ' + (inSuccess ? 'succeeded' : 'failed') + ', ' + path);

				if (inSuccess && Utils.isValidProperty(inJSON))
				{
					eventtypes = inJSON;
				}

				StartupController.get().setInitialized(StartupController.ITEM_EVENTTYPES);
			});
		}
		catch(exc)
		{
			StartupController.get().setInitialized(StartupController.ITEM_EVENTTYPES);
			logExc(exc);
		}
	}

	loadEventTypes(ScriptedWorkflowSupport.instance.scriptsRoot + '/' + kEventTypesFile);
}

//////////////////////////////////////////////////////////////////////////////
//
StartupController.addItem(StartupController.ITEM_EVENTTYPES);
ScriptEventTypes.instance = new ScriptEventTypes();

//////////////////////////////////////////////////////////////////////////////
//
ScriptEventTypes.get = function()
{
	return ScriptEventTypes.instance;
}