/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
function ContinuationManager()
{
	var handler = {};
	var current = null;

	//////////////////////////////////////////////////////////////////////////////
	//
	//
	this.start = function(/*WorkflowStepContinuation*/ inContinuation, /*Function*/ inCallback)
	{
		current = handler[inContinuation.handler];

		Utils.throwInvalid(current);

		if (Utils.isValidProperty(current))
		{
			current.start(inContinuation, inCallback);
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	//
	this.stop = function()
	{
		if (Utils.isValidProperty(current))
		{
			current.stop();
		}

		current = null;
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	//
	this.addHandler = function(/*String*/ inName, /*IContinuationHandler*/ inHandler)
	{
		var name = Utils.getParamValue(inName, Utils.REQUIRED);
		var hdl = Utils.getParamValue(inHandler, Utils.REQUIRED);

		Utils.throwInvalid(name, String);

		if (Utils.isValidProperty(handler[name]))
		{
			logWarn("Handler type '" + name + "' already exists.");
		}

		handler[name] = hdl;
	}
}

//////////////////////////////////////////////////////////////////////////////
//
//
ContinuationManager.instance = null;
ContinuationManager.get = function()
{
	if (!Utils.isValidProperty(ContinuationManager.instance))
	{
		ContinuationManager.instance = new ContinuationManager();
	}

	return ContinuationManager.instance;
}
