/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

// TriggerFactory provides details for specific trigger types
// See: ScriptEventTrigger

function TriggerFactory()
{
	var factories = {};

	//////////////////////////////////////////////////////////////////////////////
	//
	// Create handler for trigger type
	//
	this.create = function(/*String*/ inTriggerType, /*String*/ inFormatVersion, /*Workflow*/ inWorkflow)
	{
		logInfo('Create trigger, type: "' + inTriggerType + '"');

		var type = Utils.getParamValue(inTriggerType, Utils.REQUIRED);

		Utils.throwInvalid(factories[type]);

		return factories[type](inFormatVersion, inWorkflow);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return true if a factory for inTriggerType exists
	//
	this.exists = function(/*String*/ inTriggerType)
	{
		return Utils.isValidProperty(factories[inTriggerType]);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Add factory function
	//
	this.addFactory = function(/*String*/ inTriggerType, /*Function*/ inFactory)
	{
		logInfo('Register factory, type: "' + inTriggerType + '"');

		var type    = Utils.getParamValue(inTriggerType, Utils.REQUIRED);
		var factory = Utils.getParamValue(inFactory, Utils.REQUIRED);

		Utils.throwInvalid(type, String);
		Utils.throwInvalid(factory, Function);

		if (!Utils.isValidProperty(factories[type]))
		{
			factories[type] = factory;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
//
//
TriggerFactory.instance = null;
TriggerFactory.get = function()
{
	if (!Utils.isValidProperty(TriggerFactory.instance))
	{
		TriggerFactory.instance = new TriggerFactory();
	}

	return TriggerFactory.instance;
}

//////////////////////////////////////////////////////////////////////////////
//
// Create trigger for trigger type
//
TriggerFactory.create = function(/*String*/ inTriggerType, /*String*/ inFormatVersion, /*Workflow*/ inWorkflow)
{
	return TriggerFactory.get().create(inTriggerType, inFormatVersion, inWorkflow);
}

//////////////////////////////////////////////////////////////////////////////
//
// Return true if a factory for inTriggerType exists
//
TriggerFactory.exists = function(/*String*/ inTriggerType)
{
	return TriggerFactory.get().exists(inTriggerType);
}

//////////////////////////////////////////////////////////////////////////////
//
// Add factory function
//
TriggerFactory.addFactory = function(/*String*/ inTriggerType, /*Function*/ inFactory)
{
	try
	{
		TriggerFactory.get().addFactory(inTriggerType, inFactory);
	}
	catch(exc)
	{
		logExc(exc);
	}
}
