/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#include "ScreenQuadInclude.fx"
#include "ColorSpaceConversionsInclude.fx"

/*
**	Surface Diff Constants
*/

texture SoftwareVideoTexture
<
    string ResourceType = "2D"; 
>;

texture GPUVideoTexture
<
    string ResourceType = "2D"; 
>;

sampler2D SoftwareImageSampler = sampler_state
{
    texture = <SoftwareVideoTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
}; 

sampler2D GPUImageSampler = sampler_state
{
    texture = <GPUVideoTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
}; 

/*
**	Pixel Shader
*/
void SurfaceDiffPS_2_0(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
    float4 videoPixelSoftware = tex2D(SoftwareImageSampler, vTex);
    float4 videoPixelGPU = tex2D(GPUImageSampler, vTex);
	oCol = abs(videoPixelGPU - videoPixelSoftware);
   	oCol.a = 1.0;

	// Bump up the contrast so that differences get magnified.
    //float4 YCbCrA = RGBAToYCbCrA601(oCol);
	//YCbCrA.r = YCbCrA.r * 2.0;
    //oCol = YCbCrA601ToRGBA(YCbCrA);
}

technique Effect
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_1_1 ScreenQuadVS();
        PixelShader  = compile ps_2_0 SurfaceDiffPS_2_0();
    }  
}

