/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
#ifndef SCREENQUADINCLUDE_FX
#define SCREENQUADINCLUDE_FX

// Transformations
float4x4 WorldViewProjection : WORLDVIEWPROJECTION
<
	string UIWidget="None";
>;

// Texure offset
float2	QuadScreenSize : VIEWPORTPIXELSIZE < string UIWidget="None"; >;

// Texture Offset Correction
float2 QuadTexOffset = 0.5f;

struct QuadVertexOutput 
{
   	float4 Position	: POSITION;
    float2 UV		: TEXCOORD0;
};
 
/*
** Vertex Shaders
*/
QuadVertexOutput ScreenQuadVS(
		float3 Position : POSITION, 
		float3 TexCoord : TEXCOORD0
) 
{
    QuadVertexOutput OUT;
    OUT.Position = mul(float4(Position, 1), WorldViewProjection);

	float2 offset = 0;
	offset = float2(QuadTexOffset.x/(QuadScreenSize.x),QuadTexOffset.y/(QuadScreenSize.y));

    OUT.UV = float2(TexCoord.xy + offset); 

    return OUT;
}

#endif
