/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#include "ScreenQuadInclude.fx"
#include "VideoSourceTextureInclude.fx"
#include "ColorSpaceConversionsInclude.fx"

/*
**	ProcAmp	Constants
*/
float Brightness <
	string UIWidget
	 = "slider";
	float UIMin = 0.0;
	float UIMax = 4.0;
	float UIStep = 0.001;
> = 1.0f;

float Contrast <
	string UIWidget
	 = "slider";
	float UIMin = 0.0;
	float UIMax = 4.0;
	float UIStep = 0.001;
> = 1.0f;

float Saturation <
	string UIWidget
	 = "slider";
	float UIMin = 0.0;
	float UIMax = 4.0;
	float UIStep = 0.001;
> = 1.0f;

float Hue <
	string UIWidget
	 = "slider";
	float UIMin = 0.0;
	float UIMax = 2.0;
	float UIStep = 0.001;
> = 1.0f;

/*
**	ProcAmp Pixel Shader
*/
void ProcAmpPS_2_0(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
    float4 videoPixel = tex2D(ImageSampler, vTex);
    float alpha = videoPixel.a;
 
	// Convert to straight RGBA
	if (alpha > 0.0f)   
	{
	   videoPixel /= alpha;
	}
    
    // Use the normalized YCbCrA values which takes into account the offset as well as scaling required 
    float4 YCbCrA = RGBAToYCbCrA601Normalized(videoPixel);//straight RGB->YCbCr

	//		a = (0 * a)          + (1 * a)            + 0
	//		y = (0 * y)          + (Cont * y)         + Brightness
	//		u = (u*cos(Hue)*Sat) + (v*-sin(Hue)*Sat)  + 0
	//		v = (v*cos(Hue)*Sat) + (u*sin(Hue)*Sat)   + 0

	YCbCrA.r = YCbCrA.r * Contrast + (Brightness);

	float rad = 2 * 3.14 * (Hue / 360);
	float temp = (YCbCrA.g * cos(rad) - YCbCrA.b * sin(rad)) * Saturation;
	YCbCrA.b = (YCbCrA.b * cos(rad) + YCbCrA.g * sin(rad)) * Saturation;
	YCbCrA.g = temp;
	YCbCrA.a = alpha;

	// Convert back to premultiplied RGB
	oCol = YCbCrA601NormalizedToPremultipliedRGBA(YCbCrA);
}

/*
**	Straight RGBA copy
*/
void ProcAmpOriginalPS_2_0(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
	oCol = tex2D(ImageSampler, vTex);
}

technique Effect
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_1_1 ScreenQuadVS();
        PixelShader  = compile ps_2_0 ProcAmpPS_2_0();
    }  
   	pass P1
	{
		// shaders
		PixelShader  = compile ps_2_0 ProcAmpOriginalPS_2_0();
	}  
}

