/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#include "ScreenQuadInclude.fx"
#include "VideoSourceTextureInclude.fx"

/*
**	MotionOpacity Constants
*/
 	
float Opacity <
	string UIWidget
	 = "slider";
> = 1.0f;

/*
**	MotionOpacity Pixel Shader
*/
void MotionOpacityEffectPS_1_1(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
	// Get the premultiplied texture color
    oCol = tex2D(ImageSampler, vTex);
    // Output as premultiplied alpha
    oCol *= Opacity;
}

technique MotionOpacityEffect
{
    pass P0
    {
        // shaders
		VertexShader = compile vs_1_1 ScreenQuadVS();
        PixelShader  = compile ps_1_1 MotionOpacityEffectPS_1_1();
    }  
}

