/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#include "ScreenQuadInclude.fx"
#include "VideoSourceTextureInclude.fx"

/*
**	HostMediaSourceInterlace	Constants
*/
uniform float TextureOffsetFactor = 0.0f;

sampler2D DeinterlaceImageSampler = sampler_state
{
    texture = <VideoSourceTexture>;
    MipFilter = LINEAR;
    MinFilter = POINT;
    MagFilter = POINT;
}; 

/*
**	HostMediaSourceDeinterlace Pixel Shader - Discard Lower Field
*/
void HostMediaSourceDeinterlaceUpperFieldPS_2_0(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
	oCol = tex2D(DeinterlaceImageSampler, vTex);
}

/*
**	HostMediaSourceDeinterlace Pixel Shader - Discard Upper Field
*/
void HostMediaSourceInterlaceLowerFieldPS_2_0(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
	vTex.y += TextureOffsetFactor;	// Half height point sampled texture
	oCol = tex2D(DeinterlaceImageSampler, vTex);
}

technique EffectUpperField
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_1_1 ScreenQuadVS();
        PixelShader  = compile ps_2_0 HostMediaSourceDeinterlaceUpperFieldPS_2_0();
    }  
}

technique EffectLowerField
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_1_1 ScreenQuadVS();
        PixelShader  = compile ps_2_0 HostMediaSourceInterlaceLowerFieldPS_2_0();
    }  
}

