/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#include "ScreenQuadInclude.fx"
#include "ColorSpaceConversionsInclude.fx"

/*
**	Surface Diff Constants
*/

texture IncomingTexture
<
    string ResourceType = "2D"; 
>;

texture OutgoingTexture
<
    string ResourceType = "2D"; 
>;

double DissolveValue <
	string UIWidget
	 = "slider";
> = 1.0f;

sampler2D IncomingImageSampler = sampler_state
{
    texture = <IncomingTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
}; 

sampler2D OutgoingImageSampler = sampler_state
{
    texture = <OutgoingTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
}; 

/*
**	Pixel Shader
*/
void CrossDissolvePS_2_0(
    in  float2 vTex  : TEXCOORD0,
    out float4 oCol  : COLOR0)
{
    float4 videoPixelIncoming = tex2D(IncomingImageSampler, vTex);
    float alphaIncoming = videoPixelIncoming.a;
 
	// Convert to straight RGBA
	if (alphaIncoming > 0.0f)   
	{
	   videoPixelIncoming /= alphaIncoming;
	}

	float4 videoPixelOutgoing = tex2D(OutgoingImageSampler, vTex);
    float alphaOutgoing = videoPixelOutgoing.a;

	// Convert to straight RGBA
	if (alphaOutgoing > 0.0f)   
	{
	   videoPixelOutgoing /= alphaOutgoing;
	}
 
 	if (alphaOutgoing == 0)
	{
		//Use all of incoming
		oCol.rgb = videoPixelIncoming.rgb;
		oCol.a = alphaIncoming * (1.0f - DissolveValue);
	}
	else if (alphaIncoming == 0)
	{
		//Use all of outgoing
		oCol.rgb = videoPixelOutgoing.rgb;
		oCol.a = alphaOutgoing * DissolveValue;
	}
	else if (alphaIncoming == alphaOutgoing)
	{
		// When alphas are equal, do a straight interpolation
		oCol.rgb = videoPixelOutgoing.rgb * DissolveValue + videoPixelIncoming.rgb * (1.0f - DissolveValue);
		oCol.a = alphaIncoming;
	}
	else
	{
		float srcOutgoingAlphaWeighted = alphaOutgoing * DissolveValue;
		float srcIncomingAlphaWeighted = alphaIncoming * (1.0f - DissolveValue);
		float newAlpha = srcOutgoingAlphaWeighted + srcIncomingAlphaWeighted;
		float recipNewAlpha = 1.0f/newAlpha;

		oCol.rgb = (videoPixelOutgoing.rgb * srcOutgoingAlphaWeighted + videoPixelIncoming.rgb * srcIncomingAlphaWeighted) * recipNewAlpha;
		oCol.a = newAlpha;
	}
	
	// Convert back to premultiplied RGB
	oCol.rgb *= oCol.a;
}

technique CrossDissolve
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_1_1 ScreenQuadVS();
        PixelShader  = compile ps_2_0 CrossDissolvePS_2_0();
    }  
}