/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
#ifndef COLORSPACECONVERSIONSINCLUDE_FX
#define COLORSPACECONVERSIONSINCLUDE_FX


/*
** RGB to YCbCr601 conversion
*/
float4 RGBAToYCbCrA601(in float4 inRGBAPixel)
{
// These matricies scale between 601YCbCr(219) and R'G'B'[0,1] 
// Picked up from PixelTypeConversions.cpp {R_RGBtoYCbCr, G_RGBtoYCbCr, B_RGBtoYCbCr}
    
    float4 kRGBToY601Table = 
    {
    	65.738f/256.0f,		129.057f/256.0f,	25.064f/256.0f,		0.0f
    };
    float4 kRGBToCb601Table = 
    {
    	-37.945f/256.0f,	-74.494f/256.0f,	112.439f/256.0f, 	0.0f
    };
    float4 kRGBToCr601Table = 
    {
    	 112.439f/256.0f, 	-94.154f/256.0f, 	-18.285f/256.0f,	0.0f
    };
    
   	return float4(	dot(inRGBAPixel, kRGBToY601Table) + 16.0/255.0,
   					dot(inRGBAPixel, kRGBToCb601Table) + 0.5,
   				   	dot(inRGBAPixel, kRGBToCr601Table) +  0.5,
   					inRGBAPixel.a);    
}

/*
** RGB[0,1] to normalized YCbCr601 conversion -  which takes into account the offset as well as scaling required 
*/
float4 RGBAToYCbCrA601Normalized(in float4 inRGBAPixel)
{
    float4 YCbCrA = RGBAToYCbCrA601(inRGBAPixel);

    YCbCrA.r = ( 255.0 * YCbCrA.r  - 16.0 ) / 219.0; // Y is now in the space [0,1]
    YCbCrA.g = (255.0 * YCbCrA.g  - 128.0) / 224.0; // Cb is now in the space [-0.5,0.5]
    YCbCrA.b = (255.0 * YCbCrA.b - 128.0) / 224.0;// Cr is now in the space [-0.5,0.5]
    
    return YCbCrA;
}

/* 
** YCbCr601 to premultiplied RGB conversion
*/
float4 YCbCrA601ToPremultipliedRGBA(in float4 inYCbCrA601Pixel)
{
// These matricies scale between 601YCbCr(219) and R'G'B'[0,1] 
// Picked up from PixelTypeConversions.cpp {Y_YCbCrToRGB, U_YCbCrToRGB, V_YCbCrToRGB}

// First subtract the YCbCr offsets from the input pixel
	inYCbCrA601Pixel.r -= 16.0/255.0;
	inYCbCrA601Pixel.g -= 0.5f;
	inYCbCrA601Pixel.b -= 0.5f;

	float4 kYCbCr601ToRTable = 
    {
    	298.082f/256.0f, 			0.0f, 		408.583f/256.0f, 		0.0
    };
    float4 kYCbCr601ToGTable = 
    {
    	298.082f/256.0f,		-100.291f/256.0f,		-208.12f/256.0f, 	0.0
    };
    float4 kYCbCr601ToBTable = 
    {
    	298.082f/256.0f, 		516.411f/256.0f, 		0.0, 		0.0
    };

   	float4 RGBA = float4(	dot(inYCbCrA601Pixel, kYCbCr601ToRTable),
   							dot(inYCbCrA601Pixel, kYCbCr601ToGTable),
   						 	dot(inYCbCrA601Pixel, kYCbCr601ToBTable),
   							inYCbCrA601Pixel.a);
   	
   	// Convert to premultiplied RGB	
   	RGBA.rgb *= RGBA.a;

	return RGBA;
}

/* 
** YCbCr601[0,1] to premultiplied RGB [0,1] conversion - which takes into account the offset, scaling and clamping required 
*/
float4 YCbCrA601NormalizedToPremultipliedRGBA(in float4 inYCbCrA601Pixel)
{
	// Multiply by the scaling factor and then add the YCbCr offsets
	// Then clamp to [0,1]
	inYCbCrA601Pixel.r = saturate((inYCbCrA601Pixel.r * 219.0  + 16.0 ) / 255.0);
	inYCbCrA601Pixel.g = saturate(inYCbCrA601Pixel.g * 224.0 / 255.0 + 0.5f);
	inYCbCrA601Pixel.b = saturate(inYCbCrA601Pixel.b * 224.0 / 255.0  + 0.5f);

	return YCbCrA601ToPremultipliedRGBA(inYCbCrA601Pixel);
}

/* 
** YCbCr709 to premultiplied RGB conversion
*/
float4 YCbCrA709ToPremultipliedRGBA(in float4 inYCbCrA709Pixel)
{
// First subtract the YCbCr offsets from the input pixel
	inYCbCrA709Pixel.r -= 16.0/255.0;
	inYCbCrA709Pixel.g -= 0.5f;
	inYCbCrA709Pixel.b -= 0.5f;

    float4 kYCbCr709ToRTable = 
    {
    	1.164383562f, 	0.0,	1.792741071f,		0.0
    };
    float4 kYCbCr709ToGTable = 
    {
    	1.164383562f,	-0.213248614f, -0.532909329f, 	0.0
    };
    float4 kYCbCr709ToBTable = 
    {
    	1.164383562f, 	2.112401786f, 	0.0, 	0.0
    };
    	 
   	float4 RGBA = float4(	dot(inYCbCrA709Pixel, kYCbCr709ToRTable),
   							dot(inYCbCrA709Pixel, kYCbCr709ToGTable),
   							dot(inYCbCrA709Pixel, kYCbCr709ToBTable),
   							inYCbCrA709Pixel.a);
   					
	// Convert to premultiplied RGB	
   	RGBA.rgb *= RGBA.a;

	return RGBA;
}

#endif
