
var isRunningInsideELive = navigator.userAgent.match(/(Elements)|(ELive)|(OLS)|(Adobe)/gi);
function getQueryParams(params) {
    var paramsStr = "";
    for (var key in params) {
        if (params.hasOwnProperty(key)) {
            if (paramsStr == "") {
                paramsStr = "?";
            } else {
                paramsStr += "&";
            }
            
            var val = params[key];
            if(val.constructor === Array){
                //Handle multivalue arguements
                var mulValParams = "";
                for(var index in val){
                    if(mulValParams != ""){
                        mulValParams += "&";
                    }
                    mulValParams = mulValParams + key + "=" + encodeURIComponent(val[index]);
                }              
                paramsStr = paramsStr + mulValParams;
            }else{
                paramsStr = paramsStr + key + "=" + encodeURIComponent(val);
            }  
        }
    }

    return paramsStr;
}

function sendEventToApp(eventName, params, isRunningOnWindows, callback) {
    if (isRunningInsideELive) {
        try {
            params = (typeof params === "undefined") ? {} : params;
            params.timestamp = new Date().getTime();
            callback = (typeof callback === "undefined") ? null : callback;
            var eventScheme;
            if (isRunningOnWindows == "yes") {
                eventScheme = "cemjsaction://";
            } else if (isRunningOnWindows == "no") {
                eventScheme = "http://cemjsaction/";
            } else {
                return;
            }

            var eventURL = eventScheme + eventName + getQueryParams(params);
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (xmlhttp.readyState == 4) {
                    if (xmlhttp.status == 200) {
                        if (callback != null)
                            callback(JSON.parse(xmlhttp.responseText));
                    }
                }
            }

            xmlhttp.open("GET", eventURL, true);
            xmlhttp.send();
        } catch (err) {

        }
    }
}

//This function is deprecated. Please use sendEventToApp instead
function sendEvent(eventName, params) {
    if (isRunningInsideELive) {
        var eventScheme = "cemaction://";
        var eventURL = eventScheme + eventName + getQueryParams(params);
        window.location.href = eventURL;
    }
}

