var wasInitiallyOnline = navigator.onLine;
var listeningOnlineEvents = false;
var retryInProgress = false;
var spinner;
function retryNow(){
    if(!retryInProgress){
        retryInProgress = true;
        document.getElementById('retryButton').style.visibility='hidden';
		//document.getElementById('spinner').style.visibility='visible';
		spinner.spin(document.getElementById('spinner'));
        sendEvent("retryGetOnline", {});
    }
}

function onRetryComplete(){
    retryInProgress = false;
    document.getElementById('retryButton').style.visibility='visible';
	//document.getElementById('spinner').style.visibility='hidden';
	spinner.stop();
}

function onRetryClicked(){
	retryNow();
}

function installOnlineHandler(){
	if(!listeningOnlineEvents){
		listeningOnlineEvents = true;
		window.addEventListener("online", function(e) {
			retryNow();
		}, false);
	}	
}

function installOfflineHandler(){	
	window.addEventListener("offline", function(e) {
		installOnlineHandler();
	}, false);
}

function onPageLoad(){
	spinner = new Spinner().spin();
	if(!wasInitiallyOnline){
		if(navigator.onLine){
			retryNow();
		}
		else{
			installOnlineHandler();
		}		
	}else{
		installOfflineHandler();
	}
}
