	if ( window && window.nativeWindow && window.nativeWindow.stage ) {
		window.nativeWindow.stage.frameRate = 60;
		//alert( "set!" );
	}
	
	var map = null;
	var overlay = null;
	var searchCalloutOverlay = null;
	var markerClusterer = null;
	var clickedCluster = null;
	var mapClickActive = true;
	var dragDropTargetCluster = null;
	var bouncingMarker = null;
	var searchMarker = null;
	var currentMarkersMap = new Object();
	var markersMap = new Object();
	var previousAvailableSet = new Object();
	var previousSelectedSet = new Object();
	var addedMarkers = [];
	var deletedMarkers = [];
	var selectedMarkers = [];
	var searchMarkerImage;
	var mapTypes = {};
	var addLocationText = "Get Location Name";
	var editText = "Edit";
	var seeAllText = "See all";
	var editLocationToolTip = "Edit location information for selected media";
	var clickedPin = null;
	var waitingTimeOut = null;				//To prevent panning of map due to media selection while dragging a single media from filmstrip to map
	var searchCallout = null;
	var draggedPin = null;
	var disableDragging = false;
	var timerActive = false;
	var currCatalogVersion = 1;
	var smallIconString = "small/";
    var baseThumbUrl = "http://markers-storage/thumb/";
    var mapboxClient = null;
	var accessToken = null;
	var supportedLocaleToken = ["en", "es", "fr", "de", "ja" , "ru", "zh", "pt", "ar", "it", "ko", "nl", "pl", "pt", "ru", "sv", "tr"];
	var normalThumbMap = new Object(); // or var map = {};
	var hoverThumbMap = new Object();
	var locale = "en_us";

	var getHoverThumbnail = function() {
		
		var markerId = arguments[0];
		if(typeof(markerId) == 'undefined')
			return;
		var k = markerId;
		if(typeof(hoverThumbMap[k]) == 'undefined')
		{
			var queryParams = {};
			queryParams['QStringArgument'] = k;
			var callbackFunc = (response, id=markerId) => {
				hoverThumbMap[id] = "data:image/png;base64," + response;
			};
			CEMHelper.sendEventToApp(CEMHelper.sEventName.kGetHoverThumbnail,queryParams,callbackFunc);
		}
		return hoverThumbMap[k];
	}

	var localizeMapLabels = function() {
		//Localizing labels of locations on map
		map.addControl(new MapboxLanguage({
		  defaultLanguage: locale[0]
		}));
	} 

	var getLocale = function() {
		var queryParams = {};
		queryParams['QStringArgument'] = 'null';
		var callbackFunc = (response) => {
			var localeToken = response.split("_")[0];
			if(!supportedLocaleToken.includes(localeToken))
				localeToken = "en";
			locale = [localeToken];
			localizeMapLabels();
		};
		CEMHelper.sendEventToApp(CEMHelper.sEventName.kGetLocaleToken,queryParams,callbackFunc);
	}

	var  getNormalThumbnail = function() {
		var markerId = arguments[0];
		if(typeof(markerId) == 'undefined')
			return;
		var k = markerId;
		if(typeof(normalThumbMap[k]) == 'undefined')
		{
			var queryParams = {};
			queryParams['QStringArgument'] = markerId;
			var callbackFunc = (response, id=markerId) => {
				normalThumbMap[id] = "data:image/png;base64," + response;
				//update the cluster image as well
				markerClusterer.updateClusterFrontImage(id);
			};
			CEMHelper.sendEventToApp(CEMHelper.sEventName.kGetNormalThumbnail, queryParams, callbackFunc);
		}
		return normalThumbMap[k];	
	}
	
	var defaultMapStyle = "hybrid";
	var defaultLat  = 37.09024;					//US
	var defaultLng = -95.712891 ;
	var defaultZoom = 4;

	var lastDragTime = 0;
	var dragTimeout = 300;

	
	var geocoder;
	
	Object.size = function(obj) {
		var size = 0, key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) size++;
		}
		return size;
	};

		var lightStyle = [
			{ featureType: "all", elementType: "geometry", stylers: [ { visibility: "simplified" }, { saturation: -90 }, { hue: "#ffe500" }, { lightness: 20 }, { gamma: 0.7 } ] },
			{ featureType: "water", elementType: "geometry", stylers: [ { lightness: -10 }, { saturation: -30 }, { hue: "#ffd500" }, { gamma: 0.34 } ] },
			{ featureType: "all", elementType: "labels", stylers: [ { visibility: "on" }, { lightness: 23 }, { gamma: 0.87 }, { saturation: -83 } ] },
			{ featureType: "road.local", elementType: "labels", stylers: [ { lightness: 0 } ] },
			{ featureType: "road.arterial", elementType: "labels", stylers: [ { gamma: 1.63 }, { hue: "#ffbb00" }, { saturation: -93 }, { lightness: 0 } ] },
			{ featureType: "road.highway", elementType: "labels", stylers: [ { lightness: 20 }, { saturation: -13 }, { gamma: 0.84 }, { visibility: "on" } ] }
		];

		var darkStyle = [ 
			{ featureType: "landscape", elementType: "geometry", stylers: [ { saturation: -100 }, { lightness: -53 } ] },
			{ featureType: "road", elementType: "geometry", stylers: [ { saturation: -83 }, { lightness: -44 } ] },
			{ featureType: "poi", elementType: "geometry", stylers: [ { saturation: -96 }, { lightness: -50 } ] },
			{ featureType: "road.arterial", elementType: "labels", stylers: [ { lightness: -50 }, { saturation: -80 } ] },
			{ featureType: "road.local", elementType: "labels", stylers: [ { saturation: -80 }, { lightness: -50 } ] },
			{ featureType: "road.highway", elementType: "labels", stylers: [ { lightness: -54 } ] },
			{ featureType: "water", elementType: "all", stylers: [ { saturation: -39 }, { lightness: -62 } ] },
			{ featureType: "poi", elementType: "labels", stylers: [ { lightness: -30 } ] },
			{ featureType: "transit", elementType: "labels", stylers: [ { lightness: -7 }, { saturation: -66 } ] },
			{ featureType: "administrative", elementType: "geometry", stylers: [ { saturation: -79 }, { lightness: -56 } ] },
			{ featureType: "administrative.locality", elementType: "all", stylers: [ { gamma: 1.47 }, { lightness: -56 } ] },
			{ featureType: "administrative.province", elementType: "all", stylers: [ { lightness: -27 } ] },
			{ featureType: "administrative.neighborhood", elementType: "all", stylers: [ { lightness: -67 }, { gamma: 1.26 } ] } 
		];	

	var callCallback = function() {
		var funcName = arguments[0];
		var javascript = "";
		var j = arguments.length;
		var c = j - 1;
		for( var i = 1; i < j; i++ ) {
			var arg = arguments[ i ];
			if( typeof( arg ) == 'string' ) {
				arg = arg.replace( /"/g, '\\"' );
				javascript = javascript + '"' + arg + '"';
			}
			else if( typeof( arg ) == 'number' ) {
				javascript = javascript + arg;
			}
			else if( typeof( arg ) == 'boolean' ) {
				javascript = javascript + arg;
			}
			else if( arg == null || typeof( arg ) == 'undefined' ) {
				javascript = javascript + 'undefined';
			}
			else {
				javascript = javascript + 'undefined';
			}
			if( i < c ) {
				javascript = javascript + ", ";
			}
		}
		if(javascript=="")
			javascript = "null";
		
		var queryParams = {};
		queryParams['QStringArgument'] = javascript;
		var callbackFunc = (response) => {};
		CEMHelper.sendEventToApp(funcName, queryParams, callbackFunc);
	};
	
	
	function viewLabel(controlDiv, txt) {

	  controlDiv.style.padding = '5px';

	  var textLabel = document.createElement('div');
	  textLabel.style.fontFamily = '"myriad pro",Arial,sans-serif';
	  textLabel.style.fontSize = '14px';
	  textLabel.style.paddingLeft = '2px';
	  textLabel.style.paddingTop = '2px';
	  textLabel.innerHTML = txt;
	  controlDiv.appendChild(textLabel);

	}

	
	
	var MAX_LATITUDE = 85.5;
    var kMapTypeIds;

    function getToken() {
		var queryParams = {};
		queryParams['QStringArgument'] = 'null';
		var callbackFunc = (response) => {
			accessToken = response;
			initialize();
		};
		CEMHelper.sendEventToApp(CEMHelper.sEventName.kGetAccessToken,queryParams,callbackFunc);
	}
	
	function initialize() {
		mapboxgl.accessToken = accessToken;
		map = new mapboxgl.Map({
			container: 'map_canvas',
			style: 'mapbox://styles/mapbox/streets-v9',
			center: [-103.59179687498357, 40.66995747013945],
			minZoom: 3,
			maxZoom: 21,
			attributionControl: false
		});
	    mapTypes["basic"] = "Basic";
	    mapTypes["streets"] = "Streets" 
	    mapTypes["bright"] = "Bright";
	    mapTypes["light"] = "Light";
	    mapTypes["dark"] = "Dark";
	    mapTypes["satellite"] = "Satellite";

		callCallback("getLocalizedMapStrings");
		//fetch locale token from cpp side
		getLocale();

		// Control implemented as ES5 prototypical class
		function AttributionControl() {}

		AttributionControl.prototype.onAdd = function(map) {
		    this._map = map;
		    this._container = document.createElement('div');
		    this._container.innerHTML = '<div class="mapboxgl-ctrl mapboxgl-ctrl-attrib">\
		    	<a href="https://www.mapbox.com/about/maps/" target="_blank">&copy Mapbox</a>\
		    	<a href="http://www.openstreetmap.org/about/" target="_blank">&copy OpenStreetMap</a>\
		     </div>'
		    return this._container;
		};

		AttributionControl.prototype.onRemove = function () {
		     this._container.parentNode.removeChild(this._container);
		     this._map = undefined;
		};

		var attributeControl = new AttributionControl();

		map.on('load', function(){
		    map.addControl(attributeControl, 'bottom-right');
		});

		// Add zoom and rotation controls to the map.
		map.addControl(new mapboxgl.NavigationControl({
			showCompass: false
		}));
		
		var textAnchorX = 5;				//top padding
		var textAnchorY = 0;               //left padding (0 => align center)
		var groupOffsetY = 0;

		var hoverIconString = {
		
			addLocationFieldText : addLocationText,
			editFieldText : editText,
			seeAllFieldText : seeAllText
		
		};
		
		var clusterOptions = {
			gridSize: 89,
			maxZoom: 21,
			zoomOnClick: false,
			hoverIconStrings : hoverIconString,
			styles: [{
					height: 70,
					url: baseUrl + "O_Cluster_Pin.png",
					url_selected: baseUrl + "O_Cluster_Pin_S.png",
					width: 100,
					opt_anchor: [textAnchorX + 3, textAnchorY],
                    opt_offset_y: groupOffsetY,
					opt_textColor: 'white'
					},
					{
					height: 70,
					url: baseUrl + "O_Red_Pin.png",
					url_normal: baseUrl + "O_Red_Pin.png",
					url_selected: baseUrl + "O_Blue_Pin.png",
					url_over: baseUrl + "O_Red_Pin_Drop.png",
					width: 100,
					opt_offset_y: groupOffsetY,
					opt_anchor: [textAnchorX, textAnchorY],
					opt_textColor: 'white'
					}]
			
		};
				
		markerClusterer = new MarkerClusterer( map, clusterOptions );
		markerClusterer.addListener( 'clusterChanged',function() {
			callCallback("clusterRecreated");
		});
		

		map.on('load', setTimeout(function() {
			callCallback("OnMapLoaded");
		}, 1000));
		
		/*

		if ( google.maps.MaxZoomService )
			maxZoomService = new google.maps.MaxZoomService();

		geocoder = new google.maps.Geocoder();
		
		var latlng = new google.maps.LatLng( defaultLat, defaultLng );

		kMapTypeIds = [
			google.maps.MapTypeId.ROADMAP, 
			google.maps.MapTypeId.HYBRID, 
			google.maps.MapTypeId.TERRAIN, 
			"lrLight",
			"lrDark"
		];
		
		var mapOptions = {
			zoom: defaultZoom,
            center: latlng,
            mapTypeId: defaultMapStyle,
        	backgroundColor: '#707070',
			zoomControl: true,
			zoomControlOptions: {
				style: google.maps.ZoomControlStyle.LARGE
			},
			panControl: true,
			scaleControl: true,		
			navigationControl: true,
			overviewMapControl: true,
			streetViewControl: false,
			mapTypeControl: true,
			tilt: 0,
			minZoom: 3,
			mapTypeControlOptions: {
				mapTypeIds: kMapTypeIds,
				style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
			}
		};
		
		map = new google.maps.Map(document.getElementById("map_canvas"), mapOptions);
		callCallback("getLocalizedMapStrings");	  
			
		searchMarkerImage = new google.maps.MarkerImage( searchYellowMarker,
			new google.maps.Size( 50, 30 ),
			new google.maps.Point( 0, 0 ),
			new google.maps.Point( 25, 29 ) );
			
		
	
		var textAnchorX = 5;				//top padding
		var textAnchorY = 0;               //left padding (0 => align center)
		var groupOffsetY = 0;

		var hoverIconString = {
		
			addLocationFieldText : addLocationText,
			editFieldText : editText,
			seeAllFieldText : seeAllText
		
		};
		
		
		var clusterOptions = {
			gridSize: 89,
			maxZoom: 21,
			zoomOnClick: false,
			hoverIconStrings : hoverIconString,
			styles: [{
					height: 70,
					url: baseUrl + "O_Cluster_Pin.png",
					url_selected: baseUrl + "O_Cluster_Pin_S.png",
					width: 100,
					opt_anchor: [textAnchorX + 3, textAnchorY],
                    opt_offset_y: groupOffsetY,
					opt_textColor: 'white'
					},
					{
					height: 70,
					url: baseUrl + "O_Red_Pin.png",
					url_normal: baseUrl + "O_Red_Pin.png",
					url_selected: baseUrl + "O_Blue_Pin.png",
					url_over: baseUrl + "O_Red_Pin_Drop.png",
					width: 100,
					opt_offset_y: groupOffsetY,
					opt_anchor: [textAnchorX, textAnchorY],
					opt_textColor: 'white'
					}]
			
		};
		
		google.maps.event.addListener(map, 'click', function(e) {
                contextmenu:true;
            });
		
		markerClusterer = new MarkerClusterer( map, clusterOptions );
		google.maps.event.addListener( markerClusterer, 'clusterChanged',function() {

			callCallback("clusterRecreated");
		});
			
		*/
		markerClusterer.addListener( 'clusterclick', function( clusters ) {
			//alert('clusterClicked');
			mapClickActive = false;
			if ( clusters == null || clusters.length == 0 )
				return;
			
			var cluster = clusters[ 0 ];
			var markers = cluster.markers_;
						
			clickedCluster = cluster;
			var count = getClickedClusterCount();
			var center = cluster.getCenter();
			clickedPin = cluster;
											
			if ( count && count > 0 ) {
				selectedMarkers = [];
				for ( var i = 0, marker; marker = markers[ i ]; i++ ) {			
					if ( marker.id ) {
						//marker.selected = true;
						var markerInfo = new Object();	
						markerInfo.id = marker.id;
						markerInfo.lat = marker.getLngLat().lat;
						markerInfo.lng = marker.getLngLat().lng;
						selectedMarkers.push(markerInfo);
					}
				}
				// all the details are in selected markers array
				
				updateMarkers();
			
				var mediaIdList = createMediaList(selectedMarkers);	

				//here we will pass the tagId of leaf node to ensure custom tag feature working 
				// if no leaf node (states separated) then 0
				var tagId = 0;
				if(cluster.hasCommonTags())
				{
					tagId = cluster.getFirstTagId();
				}
				
				var firstTagAndMediaIdList = String(tagId) + "," + mediaIdList ;
				
				callCallback( "onClusterMarkersClick", firstTagAndMediaIdList );
			}								

	
		} );
		

		markerClusterer.addListener( 'clusterdoubleclick', function( clusters ) {
			mapClickActive = true;							//in click event mapclickactive get false.
			var selectedCluster = clusters[0];
			if(!clusters[0]) return;
			
 			showSelectedClusterMedia(selectedCluster);							//media gets selected in click event					
			callCallback( "onClusterDoubleClick" );
		} );

		markerClusterer.addListener( 'clusterrightclick', function( clusters ) {
			var cluster = clusters[ 0 ];
			var markers = cluster.markers_;
			clickedCluster = cluster;
			var mediaIdList = createMediaList(markers);

			var tagId = 0;
			if(cluster.hasCommonTags())
			{
				tagId = cluster.getFirstTagId();
			}
			
			var firstTagAndMediaIdList = String(tagId) + "," + mediaIdList ;
				
			callCallback( "onClusterRightClick", firstTagAndMediaIdList );
				
		} );
	
		markerClusterer.addListener( 'clustermousedown', function( event, clusters ) {
			if(event.button == 2) return;							//2 denotes right mouse button, 1- left, 3- middle
		} );
		
		markerClusterer.addListener( 'clustermousemove', function( event, clusters ) {
			
		} );
		
		markerClusterer.addListener( 'clustermouseup', function( clusters ) {
			
		} );
		
		markerClusterer.addListener( 'clusterdragmove', function( draggedCluster ) {
			if(draggedCluster)
			{	
				if(draggedPin && draggedPin !== draggedCluster)
				{
					pinMoveCancelled(draggedPin);
				}
				draggedPin = draggedCluster;
				
				clearSearchCallout();
				var pos = draggedCluster.getCenter();
				dragDropTargetCluster = markerClusterer.canAcceptMarkerDropImp( pos, false, dragDropTargetCluster );
			}
			
		} );
		
		markerClusterer.addListener( 'clusterdragend', function( draggedCluster ) {

			//alert("mainScript: drag end " + draggedCluster);
			if(draggedPin && draggedPin !== draggedCluster)
			{
				pinMoveCancelled(draggedPin);
			}
			
			clearSearchMarker();
			draggedPin = draggedCluster;
			var pos = draggedCluster.getCenter();
			var existingImageId = 0;

			if(dragDropTargetCluster)
			{	
				existingImageId = dragDropTargetCluster.markers_[0].id;
				pos = dragDropTargetCluster.getCenter();
				markerClusterer.clusterMoved(draggedCluster, pos);
			}
			
			var clusterMarkers = draggedCluster.markers_;
			var mediaListStr = createMediaList(clusterMarkers);
			callCallback("onClusterDragEnd", pos.lat, pos.lng, existingImageId, mediaListStr);
		} );
		
		
			
		markerClusterer.addListener( 'trashIconClicked', function(clusters) {
		
			mapClickActive = false;
		
			if ( clusters == null || clusters.length == 0 )
				return;
		
			var cluster = clusters[ 0 ];
			var markers = cluster.markers_;
			
			var mediaIdList = createMediaList(markers);	
			callCallback("onTrashIconClick",mediaIdList);	
		
		
		}
		);
		markerClusterer.addListener( 'seeAllClicked', function(clusters) {
			
			mapClickActive = false;
			if ( clusters == null || clusters.length == 0 )
				return;
			var cluster = clusters[ 0 ];
			showSelectedClusterMedia(cluster);
		
		
		
		}
		);
		markerClusterer.addListener( 'editClusterClicked', function(clusters) {
			
			mapClickActive = false;
			
			if ( clusters == null || clusters.length == 0 )
				return;
		
			var cluster = clusters[ 0 ];
			var markers = cluster.markers_;
			
				var mediaIdList = createMediaList(markers);	
				callCallback("onEditClusterClicked",mediaIdList);
		
		
		}
		);
	
		markerClusterer.addListener( 'requestReverseGeocodeLocation', function(clusters) {
		
			if ( clusters == null || clusters.length == 0 )
				return;
				
			var cluster = clusters[ 0 ];
			var markers = cluster.markers_;
			
			var mediaIdList = createMediaList(markers);	
			var center = cluster.getCenter();
			var arg = center.lat + "," + center.lng + "," + mediaIdList ;
			//alert("requesting reverse");
			callCallback("requestReverseGeocodeLocation",arg);
		}
		);

		markerClusterer.addListener( 'getLocationNameForClusterViaMediaList', function(clusters) {
		
			if ( clusters == null || clusters.length == 0 )
				return;
			var cluster = clusters[ 0 ];
			var markers = cluster.markers_;
			
			var mediaIdList = createMediaList(markers);	
			var bound = cluster.getCenter();
			var arg = bound.lat + "," + bound.lng + "," + mediaIdList ;
			callCallback("getLocationNameForClusterViaMediaList",arg);
		}
		);
		/*
		overlay = new google.maps.OverlayView();
		overlay.draw = function() {};
		overlay.setMap( map );
			
		google.maps.event.addListenerOnce(map, 'idle', setTimeout(function() {
			callCallback("OnMapLoaded");
		}, 1000));
		*/
		map.on('click', function( event ) {
			dropDownClicked(true) // close the different map selection menu
			var now = new Date().getTime();
			if(!mapClickActive) {														//click on cluster also results in map click 
				mapClickActive = true;
				return;
			}
			//this condition not needed as of now since cluster dragged functionality has been rewritten . Modify it as per need.	
			//if ( now - lastDragTime > dragTimeout ) {
			
			selectedMarkers = [];
			updateMarkers();
			callCallback( "onMapClick", event.lngLat.lat, event.lngLat.lng );

		} );
		
		
		map.on( 'mousedown', function( event ) {
			callCallback( "onMapMouseDown", event.lngLat.lat, event.lngLat.lng );
		} );

		map.on( 'mousemove', function( event ) {
			callCallback( "onMapMouseMove", event.lngLat.lat, event.lngLat.lng );
		} );

		map.on( 'mouseup', function( event ) {
			callCallback( "onMapMouseUp", event.lngLat.lat, event.lngLat.lng);
		} );

		map.on( 'mouseout', function( event ) {
			if(draggedPin && draggedPin.isClusterDragged())
			{
				pinMoveCancelled(draggedPin);
			}
			callCallback( "onMapMouseOut", event.lngLat.lat, event.lngLat.lng );
		} );

		map.on( 'rightclick', function( event ) {
			callCallback( "onMapRightClick", event.lngLat.lat, event.lngLat.lng );
		} );

		map.on( 'dblclick', function( event ) {
			callCallback( "onMapDoubleClick", event.lngLat.lat, event.lngLat.lng );
		} );
		
		map.on( 'zoomend', function() {
			if(draggedPin) {
				draggedPin = null;
				clearSearchCallout();
			}
	//		if(draggedPin && isClusterPin(draggedPin)) {
	//			clearSearchCallout();
	//			draggedCluster = null;
	//			draggedPin = null;
	//			clusterDragState = dragStates.NODRAG;	
	//		}									//new clusters might be formed.

			// we are not retaining selection in zoom in/out cases 
			//in order to have single cluster selection for honoring custom tag
			selectedMarkers = [];
			updateMarkers();

			callCallback( "onZoomChanged", map.getZoom() );
			map.fire("bounds_changed");
		} );

		map.on( 'drag', function() {
			map.fire("center_changed");
			map.fire("bounds_changed");
		} );

		//TODO anggupta-temp: Find center_changed event in mapbox gl js // will drag work?
		map.on( 'center_changed', function() {
			var center = map.getCenter();
			callCallback( "onCenterChanged", center.lat, center.lng );
		} );

		//TODO anggupta-temp: Find bounds_changed event in mapbox gl js
		map.on( 'bounds_changed', function() { // will drag and zoomend work?
			var bounds = map.getBounds();
			var ne = bounds.getNorthEast();
			var sw = bounds.getSouthWest();
			callCallback( "onBoundsChanged", ne.lat, ne.lng, sw.lat, sw.lng );
		} );
		
		//TODO anggupta-temp: Find maptypeid_changed event in mapbox gl js
		map.on( 'maptypeid_changed', function() { //this will be taken care at a later point while changing the maps
			var mapTypeId = map.getMapTypeId();
			callCallback( "onMapTypeChanged", mapTypeId );
		} );
		

		
			
			//--------------------search callout code-------------------------------------------------------------
		searchCalloutOverlay = function(latLngPos, map, txt, anchorElementHeight) {  
			// Now initialize all properties.  
			//alert("initialize searchcalloutoverlay");
			this.pos_ = latLngPos;  
			this.map_ = map;  
			this.div_= null;  
			this.text_ = txt;
			this.bDivDrawn_ = false;
			this.offsetX_ = 0;        //offset from center point. Set when div is first drawn . 
			this.offsetY_ = anchorElementHeight - 7;     //7 is random .    
			// Explicitly call setMap() on this overlay  
			this.onAdd();
			this.draw();          
		} ;
		//searchCalloutOverlay.prototype = new google.maps.OverlayView();
		
		//get gps location which is referred by this callout
		searchCalloutOverlay.prototype.getGeoLocation = function() { 
			return this.pos_;
		};
		
		searchCalloutOverlay.prototype.onAdd = function() {  
			// Create the DIV and set some basic attributes.  
			//alert("onAdd");
			var div = document.createElement('DIV');  
			div.style.borderStyle = "none";  
			div.style.borderWidth = "0px";  
			div.style.position = "relative";
			div.style.zIndex =  100;
			
			var textDiv = document.createElement('DIV'); 
			textDiv.id = "s_text"; 
			textDiv.style.borderStyle = "none";  
			textDiv.style.borderWidth = "0px"; 
			textDiv.style.position = "absolute"; 
			textDiv.style.color = "black";
			textDiv.style.fontSize = "13px";
			textDiv.style.fontFamily = "'Myriad Web Pro', 'Myriad Pro', sans-serif";			//TODO: need to localize it for japane
			textDiv.style.verticalAlign = "center";
			
			var preTag = document.createElement('PRE');
			preTag.style.display = "inline";
			preTag.style.fontFamily = "inherit";
			
			var text = document.createTextNode(this.text_);
			preTag.appendChild(text);
			textDiv.appendChild(preTag);
			
			var leftDiv = document.createElement('DIV');  
			leftDiv.id = "s_leftdiv";
			leftDiv.style.borderStyle = "none";  
			leftDiv.style.borderWidth = "0px";  
			leftDiv.style.position = "absolute"; 
		  
			leftDiv.style.backgroundImage = "url(" + callOutLeft + ")"; 
			leftDiv.style.width = "8px";													//width of image
			leftDiv.style.height = "35px";													//height of image
					 
			var centerDiv = document.createElement('DIV');  
			centerDiv.id = "s_centerdiv";
			centerDiv.style.borderStyle = "none";  
			centerDiv.style.borderWidth = "0px";  
			centerDiv.style.position = "absolute"; 
		  
			centerDiv.style.backgroundImage = "url(" + callOutCenter + ")";  
			centerDiv.style.backgroundRepeat = "repeat-x";
			centerDiv.style.height = "35px"; 
			
			
			var rightDiv = document.createElement('DIV');  
			rightDiv.id = "s_rightdiv";
			rightDiv.style.borderStyle = "none";  
			rightDiv.style.borderWidth = "0px";  
			rightDiv.style.position = "absolute"; 
		  
			rightDiv.style.backgroundImage = "url(" + callOutRight + ")";   
			rightDiv.style.width = "8px";  
			rightDiv.style.height = "35px"; 
			
			
			var buttonDiv = document.createElement('DIV'); 
			buttonDiv.id = "s_button"; 
			buttonDiv.style.borderStyle = "none";  
			buttonDiv.style.borderWidth = "0px";  
			buttonDiv.style.position = "absolute";
			buttonDiv.style.verticalAlign = "center";
			buttonDiv.style.display = "inline-block";
			
			
			var acceptButton = document.createElement("input");
			acceptButton.type = "image";
			acceptButton.id = "acceptButton"
			acceptButton.src = greenTickImage;
			acceptButton.style.width = "19px";
			acceptButton.style.height = "18px";
			acceptButton.style.position = "absolute";
			
			
			var rejectButton = document.createElement("input");
			rejectButton.type = "image";
			rejectButton.id = "rejectButton";
			rejectButton.src = redCrossImage;
			rejectButton.style.width = "18px";
			rejectButton.style.height = "18px";
			rejectButton.style.position = "absolute";
			
			buttonDiv.appendChild(acceptButton);
			buttonDiv.appendChild(rejectButton);
			
			
			div.appendChild(leftDiv);
			div.appendChild(centerDiv);
			div.appendChild(rightDiv);
			div.appendChild(buttonDiv);
			div.appendChild(textDiv);
			
			var that = this;
			google.maps.event.addDomListener(acceptButton, "click", function(evt) {
								evt.stopPropagation();
								if(!draggedPin)
								{
									//alert("will assign: " + that.pos_);
									assignSearchLocation(that.pos_);
								}
								else
								{
									movePin(draggedPin);
									clearSearchMarker();
								}
							});
			google.maps.event.addDomListener(rejectButton, "click", function(evt) {
								evt.stopPropagation();
								clearSearchMarker();
								if(draggedPin)
								{
									pinMoveCancelled(draggedPin);
								}
							});
			
		  
			// Set the overlay's div_ property to this DIV  
			this.div_ = div;  
		  
			// We add an overlay to a map via one of the map's panes.  
			// We'll add this overlay to the overlayImage pane.  

			this.map_.getCanvasContainer().appendChild(this.div_);
			
			this.draw = this.draw.bind(this);
            this.map_.on('move', this.draw);
            this.map_.on('moveend', this.draw);
		}  
	  
			//drawing overlay on map  
		searchCalloutOverlay.prototype.draw = function() { 
			var centerX = this.map_.project(this.pos_).x;  
			var centerY = this.map_.project(this.pos_).y;  
			//alert("draw");
			var div = this.div_;  
			if(this.bDivDrawn_) {
       			//just reposition the parent div according to new overlayprojection
				var originX = centerX - this.offsetX_;
				var originY = centerY - this.offsetY_;
				div.style.left = originX + 'px';
				div.style.top = originY + 'px';
				
				return;
			} 
			
			//drawing for first time
			
			var textDiv = document.getElementById("s_text");
			var leftDiv = document.getElementById("s_leftdiv");
			var centerDiv = document.getElementById("s_centerdiv");
			var rightDiv = document.getElementById("s_rightdiv");
			var buttonDiv = document.getElementById("s_button");
			var acceptBtn = document.getElementById("acceptButton");
			var rejectBtn = document.getElementById("rejectButton");
			
			var textDivWidth = textDiv.clientWidth;
			var leftDivWidth = leftDiv.clientWidth;
			var buttonDivWidth = acceptBtn.clientWidth + rejectBtn.clientWidth;
			var rightDivWidth = rightDiv.clientWidth;
			
			var centerDivWidth = textDivWidth + 8 + buttonDivWidth + 3;               //8 space b/w text and button, 3 - space b/w both buttons
			
			this.offsetX_ += leftDivWidth +(centerDivWidth/2) - 1;  				// 1 for center alignment
			this.offsetY_ += 35;											// 35 - height of callout
			
			var originX = centerX - this.offsetX_;				
			var originY = centerY - this.offsetY_;										
			
			div.style.left = originX + 'px';
			div.style.top = originY + 'px';
			
			leftDiv.style.left = '0px';
			leftDiv.style.top = '0px';
			
			rightDiv.style.left = leftDivWidth + centerDivWidth + 'px';		
			rightDiv.style.top = '0px';
			
			centerDiv.style.width = centerDivWidth + "px";
			centerDiv.style.left = leftDivWidth + 'px';
			centerDiv.style.top = '0px';
			
			textDiv.style.left = leftDivWidth + 'px';
			textDiv.style.top =  10 + 'px';
					
			acceptBtn.style.left = (leftDivWidth + textDivWidth + 8) + 'px';
			acceptBtn.style.top =  10 + 'px';		
			
			rejectBtn.style.left = (leftDivWidth + textDivWidth + 8 + acceptBtn.clientWidth + 3) + 'px';
			rejectBtn.style.top = 10 + 'px';		

			this.bDivDrawn_ = true;
		}  
		
		searchCalloutOverlay.prototype.onRemove = function() {
            this.map_.off('move', this.draw);
            this.map_.off('moveend', this.draw);
			
			if(this.div_ && this.div_.parentNode)
				this.div_.parentNode.removeChild(this.div_);
			this.div_ = null;
		}
		
	}

	var updateMapTypeText = function () {
		var labels = layerList.getElementsByTagName('label');
		var dropDownButtonText = document.getElementById('textLabel');
		var dropDown = document.getElementsByClassName('dropdown')[0];
		for (var i = 0; i < labels.length; i++) {
			labels[i].innerHTML = mapTypes[labels[i].id];
		}
		dropDownButtonText.innerHTML = mapTypes[dropDownButtonText.innerHTML.toLowerCase()];
		dropDown.style.visibility = "";
	}

	var updateLightDarkMap = function () {
		var lightMapType = new google.maps.StyledMapType( lightStyle, {name: lightMapTxt});
		var darkMapType = new google.maps.StyledMapType( darkStyle, {name: darkMapTxt} );
		map.mapTypes.set( "lrLight", lightMapType );
		map.mapTypes.set( "lrDark", darkMapType );

	}

	var updateAddLocationAndEditTexts = function()
	{
		for ( var i = 0, cluster; i < markerClusterer.getTotalClusters() ; i++ ) {
			cluster = markerClusterer.clusters_[i];
			cluster.clusterIcon_.addLocationText_.innerHTML 	= addLocationText;
			cluster.clusterIcon_.seeAllText_.innerHTML 		= seeAllText;
			cluster.clusterIcon_.editText_.innerHTML 		= editText; 
		}
	}
	var setLocalizedStrings = function(str) {
		var strList = str.split(",");
				
		if(strList.length == 11) {
			calloutText = strList[0];
		    mapTypes["basic"] = strList[1];
		    mapTypes["streets"] = strList[2] 
		    mapTypes["bright"] = strList[3];
		    mapTypes["light"] = strList[4];
		    mapTypes["dark"] = strList[5];
		    mapTypes["satellite"] = strList[6];
			addLocationText = strList[7]; 
			editText  = strList[8]; 
			seeAllText = strList[9];
			editLocationToolTip = strList[10]; 
		}
	//bug4155782 we have to make light and dark maps after this call because localization texts
	// are updated async in cempod
	updateMapTypeText();
	updateAddLocationAndEditTexts();

	}
	
	var createMediaList = function (markers){
		
		if(markers.length)
		{
			var mediaIdList = "" + String(markers[0].id);
			for(var i=1; i < markers.length; i++)
			{
			
				mediaIdList = mediaIdList + "," + String(markers[i].id);
			}	
			return mediaIdList;
		}
	}
		
		
	var assignSearchLocation = function(position) {
		//alert("in assign");
		if(!position) return;

		var searchMarkerDragged = false;
		if(searchMarker)
			searchMarkerDragged = searchMarker.dragged;
			
		callCallback('onAssignSearchLocation', position.lat, position.lng, searchMarkerDragged);
		clearSearchMarker();
	}
	
	var movePin = function(dragPin) {
		//alert("moving pin" + dragPin);
		if(!dragPin) return;
		
		var mediaIdListString = "";
		var pinPos;	
		if(isClusterPin(dragPin))
		{	
			//alert("cluster drag");
			var markers = dragPin.markers_;
			mediaIdListString = createMediaList(markers);
			dragDropTargetCluster = markerClusterer.canAcceptMarkerDropImp( dragPin.getCenter(), false, dragDropTargetCluster );
			//alert("movePin: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
			if(dragDropTargetCluster)
			{
				pinPos = dragDropTargetCluster.getCenter();
			}
			else
				pinPos = dragPin.getCenter();
		}
		else
		{
			mediaIdListString = "" + String(dragPin.id);
			dragDropTargetCluster = markerClusterer.canAcceptMarkerDropImp( dragPin.getLngLat(), false, dragDropTargetCluster );
			//alert("movePin: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
			if(dragDropTargetCluster)
			{
				pinPos = dragDropTargetCluster.getCenter();
			}
			else
				pinPos = dragPin.getLngLat();
		}
		
		callCallback("onPinRelocated", pinPos.lat, pinPos.lng, mediaIdListString);
	}
	
	var pinMoveCancelled = function(dragPin) {
		//alert(dragPin);
		if(!dragPin) return;
		
		if(isClusterPin(dragPin))
		{
			//alert("cluster drag cancel");
			var originalPos = currentMarkersMap[dragPin.markers_[0].id].getLngLat();
			markerClusterer.clusterMoved(dragPin, originalPos);
		}
		else
		{
			//alert(dragPin.id);
			callCallback("restoreMarkerPosition", dragPin.id);
		}
		draggedPin = null;
		callCallback("onPinMoveCancelled");
	}
	
	var restoreMarkerPosition = function(imageId, lat, lng) {
		if(currentMarkersMap[imageId])
			currentMarkersMap[imageId].setLngLat(new mapboxgl.LngLat(lng, lat));
	}
	
	var setMapStyle = function(style) {
		var mapTypeId;
		switch(style)
		{
		case "roadmap":
			mapTypeId = google.maps.MapTypeId.ROADMAP;
			break;
		case "hybrid":
			mapTypeId = google.maps.MapTypeId.HYBRID;
			break;
		case "lrLight":
			mapTypeId = "lrLight";
			break;
		case "lrDark":
			mapTypeId = "lrDark";
			break;
		default:
			mapTypeId = google.maps.MapTypeId.ROADMAP;
		}	
		map.setMapTypeId(mapTypeId);
	}



	var showHoverTip = function(str)
	{

		callCallback("onShowLocationHoverTip", str);

	}
	
	var hideHoverTip = function()
	{
				var str = "";
				callCallback("onHideLocationHoverTip", str);
	}






	
	var isClusterPin = function(pin) {
		if(pin instanceof mapboxgl.Marker)
			return false;
		else
			return true;
	}
	
	//masingha: Either this method name seems ambiguous with its implementation. 
	var forceShowMarkersForMedia = function(imageIdList) {
			if(imageIdList.length <= 0 ) return;
		
			var mediaList = imageIdList.split(',');
			var imageId = mediaList[0];
			for ( var i = 0, cluster; i < markerClusterer.getTotalClusters() ; i++ ) {
				cluster = markerClusterer.clusters_[i];
				var imageIdLista;
				for ( var j = 0, marker; marker = cluster.markers_[ j ]; j++ ) {
					if(imageId == marker.id){
						showSelectedClusterMedia(cluster);
						break;
					}
				}
			}
	}	

	
	var showSelectedClusterMedia =  function(selectedCluster){
		var pinBounds = new mapboxgl.LngLatBounds();
		
		if(selectedCluster)
		{
			if(selectedCluster.isGroupCluster)
				pinBounds.extend(selectedCluster.getCenter());
			else
			{
				var markers = selectedCluster.markers_;
				for(var i = 0; i < markers.length; ++i)
				{
					pinBounds.extend(markers[i].getLngLat());
				}
				
			}
		}
	
		if( pinBounds != null ) {
			var ne = pinBounds.getNorthEast();
			var sw = pinBounds.getSouthWest();
			callCallback("onSeeAllMediaClick", ne.lat, ne.lng, sw.lat, sw.lng);
		}
		mapClickActive = false;
	}	
		
		
	//bOnExistingPin: will be used for positioning the callout above element
	var showSearchCallout = function(txt, lat, lng, bOnExistingPin) {
		//alert("search callout to b shon");
		clearSearchCallout();
		var latLng = new mapboxgl.LngLat(lng, lat);  
		var anchorElementHeight = bOnExistingPin ? 76 : 30;                 //76 - height of smallThumbNormal, 30- height of search pin
		searchCallout = new searchCalloutOverlay(latLng, map, txt, anchorElementHeight);  
	};

	var clearSearchCallout = function() {
		if(searchCallout) {
			//searchCallout.setMap(null);
			searchCallout.onRemove();
		}
	};		
	
	var updateSearchCalloutText =  function(txt) {
		if(searchCallout)
		calloutText = txt;
		if(searchMarker) {
			showSearchCallout(txt, searchCallout.getGeoLocation().lat, searchCallout.getGeoLocation().lng, false);
		}
	}
	
	var clearMarkerSelection = function() {
		if(selectedMarkers.length) {
			selectedMarkers = [];
			updateMarkers();
		}
	}
	
	var getClusters = function() {

			var imageIdList = "";
			for ( var i = 0, cluster; i < markerClusterer.getTotalClusters() ; i++ ) {
				cluster = markerClusterer.clusters_[i];
				imageIdList = imageIdList + "new cluster";
				for ( var j = 0, marker; marker = cluster.markers_[ j ]; j++ ) {
					imageIdList = imageIdList + "," + marker.id;
				}
				if( i+1 < markerClusterer.getTotalClusters())
					imageIdList = imageIdList + ",";
			}
			return imageIdList ;
	}	


	var getClustersInView = function() {

			var imageIdList = "";
			var bFirstCluster = true;
			for ( var i = 0, cluster; i < markerClusterer.getTotalClusters() ; i++ ) {
				cluster = markerClusterer.clusters_[i];
				var pos = cluster.getCenter();
				if(lngLatBoundsContainPoint(map.getBounds(), pos))
				{
					if(!bFirstCluster)
						imageIdList = imageIdList + ",";
					else
						bFirstCluster = false;
					imageIdList = imageIdList + "new cluster";
					for ( var j = 0, marker; marker = cluster.markers_[ j ]; j++ ) {
						imageIdList = imageIdList + "," +marker.id;;
					}
				}
				
			}
			return imageIdList ;
	}		

	var getSelectedImageIds = function() {
		if(!selectedMarkers.length || !selectedMarkers[0]) return "";
		
		var imageIdList = "" + selectedMarkers[0].id;
		for(var i = 1; i < selectedMarkers.length; ++i)
		{
			imageIdList = imageIdList + "," + selectedMarkers[i].id;
		}
		return imageIdList;
	}	
	
	var fitMarkersToBounds = function () {
		var bounds = new mapboxgl.LngLatBounds();
		var boundsChanged = false;
		// Create bounds from markers
		for( var imageId in currentMarkersMap ) {
			if(currentMarkersMap[imageId]) {
				boundsChanged = true;
				var latlng = currentMarkersMap[imageId].getLngLat();
				bounds.extend(latlng);
			}
		}
    
		if(!boundsChanged) return;

		// Don't zoom in too far on only one marker
		if (bounds.getNorthEast().equals(bounds.getSouthWest())) {
		   var extendPoint1 = new mapboxgl.LngLat(bounds.getNorthEast().lng + 0.01, bounds.getNorthEast().lat + 0.01);
		   var extendPoint2 = new mapboxgl.LngLat(bounds.getNorthEast().lng - 0.01, bounds.getNorthEast().lat - 0.01);
		   bounds.extend(extendPoint1);
		   bounds.extend(extendPoint2);
		}

		map.fitBounds(bounds);

	};
	
	var showMarkersForMedia = function (mediaListStr) {

		var bounds = new mapboxgl.LngLatBounds();
		var mediaList = mediaListStr.split(',');
		
		// Create bounds from markers
		for( var i = 0; i < mediaList.length; i++) {
			var imageId = mediaList[i];
			if(currentMarkersMap[imageId]) {
				var latlng = currentMarkersMap[imageId].getLngLat();
				bounds.extend(latlng);
			}
		}

		// Don't zoom in too far on only one marker
		if (bounds.getNorthEast().equals(bounds.getSouthWest())) {
		   var extendPoint1 = new mapboxgl.LngLat(bounds.getNorthEast().lng + 0.01, bounds.getNorthEast().lat + 0.01);
		   var extendPoint2 = new mapboxgl.LngLat(bounds.getNorthEast().lng - 0.01, bounds.getNorthEast().lat - 0.01);
		   bounds.extend(extendPoint1);
		   bounds.extend(extendPoint2);
		}

		map.fitBounds(bounds);

	};
	
	var bringMarkerInView = function(mediaId) {
		if(!mediaId) return;
		var marker = currentMarkersMap[mediaId];
		if(marker)
		{
			var pos = marker.getLngLat();
			if(!lngLatBoundsContainPoint(map.getBounds(), pos))
				setCenter(pos.lat, pos.lng);
				
		}
	}
			
	var locationToViewPoint = function( location ) {
		if ( location == null ) return;
		if ( map == null ) return;
		return map.project( location );
	}
	
	var viewPointToLocation = function( point ) {
		if ( location == null ) return;
		if ( map == null ) return;
		var latLng = map.unproject( point );
		if ( latLng.lng > 180 )
			latLng.lng -= 360;
		if ( latLng.lng < -180 )
			latLng.lng += 360;
		return latLng;
	}
   
    function getZoom() {
		return map.getZoom();
	}
	
	function getBounds() {
		if ( map != null ) {
			var result = map.getBounds();
			if( result != null ) {
				var ne = result.getNorthEast();
				var sw = result.getSouthWest();
				
				return ne.lat + "," + ne.lng + "," + sw.lat + "," + sw.lng;
			}
		}
	}
	
	var getCenter = function() {
		if ( map != null ) {
			var result = map.getCenter();
			if(result != null ) {
				return result.lat + "," + result.lng;
			}
		}
	}
	
	var loadMarkersForMedia = function(mediaListStr) {
		var mediaList = mediaListStr.split(',');
		var mediaNotInCache = "0";
		clearMarkers();
		for(var i = 0; i < mediaList.length; i++)
		{
			var imageId = mediaList[i];
			if(markersMap[imageId])
			{
				var marker = markersMap[imageId];
				if(marker != null)
				{
					var markerInfo = new Object();
					markerInfo.id = imageId;	
					markerInfo.lat = marker.getLngLat().lat;
					markerInfo.lng = marker.getLngLat().lng;
					addedMarkers.push( markerInfo );
				}
			}
			else
			{
				mediaNotInCache += "," + String(imageId);
			}
		}
		
		updateMarkers();
		if(mediaNotInCache.length > 1)
			callCallback("getGPSForMedia", mediaNotInCache);
	}
				
	
	var clearMarkers = function() {
	
		//callCallback("startTimer", "clearMarkers");
		markerClusterer.clearMarkers();
		
		for( var imageId in currentMarkersMap ) {
			var marker = currentMarkersMap[ imageId ];
			if ( marker != null ) {
				// make sure it is invisible and garbage collected
				marker.setVisible( false );
				//marker.setMap( null );
				delete marker;
			}
			currentMarkersMap[ imageId ] = null;
		}
		delete currentMarkersMap;
		currentMarkersMap = new Object();
		delete previousAvailableSet;
		previousAvailableSet = new Object();
		delete previousSelectedSet;
		previousSelectedSet = new Object();
		selectedMarkers = [];
		clickedCluster = null;
		dragDropTargetCluster = null;
		clearSearchCallout();
		draggedPin = null;
		//callCallback("endTimer", "clearMarkers");
	}
	
	var bounceMarker = function( markerId ) {
	
		if ( bouncingMarker ) {
			if ( bouncingMarker.setAnimation )
				bouncingMarker.setAnimation( null );
			bouncingMarker = null;
		}
	
		if ( markerId && markerId != "" && currentMarkersMap[ markerId ] ) {
			bouncingMarker = currentMarkersMap[ markerId ];
			if ( bouncingMarker && bouncingMarker.setAnimation && google.maps.Animation ) {
				bouncingMarker.setAnimation( google.maps.Animation.BOUNCE );
			}
		}
		
		setTimeout( function() { 
			if ( bouncingMarker ) {
				if ( bouncingMarker.setAnimation )
					bouncingMarker.setAnimation( null );
				bouncingMarker = null;
			}
		}, 20 );
	}
	
	var doMarkerDragEntered = function( lat, lng ) {
		if(waitingTimeOut)
			clearTimeout(waitingTimeOut);
		var pt = new mapboxgl.LngLat(lng, lat);
		dragDropTargetCluster = markerClusterer.canAcceptMarkerDropImp( pt, false, dragDropTargetCluster );
		//alert("dragEntered: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
	}
	
	var doMarkerDrag = function( lat, lng ){
		var pt = new mapboxgl.LngLat(lng, lat );
		dragDropTargetCluster = markerClusterer.canAcceptMarkerDropImp( pt, false, dragDropTargetCluster );
		//alert("drag: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
	}
	
	var doMarkerDragEnd = function( lat, lng ){
		var pt = new mapboxgl.LngLat( lng, lat );
		dragDropTargetCluster = markerClusterer.canAcceptMarkerDropImp( pt, false, dragDropTargetCluster );
		//alert("dragEnd: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
	
		var success = false;
		if (dragDropTargetCluster) {
			var pos = dragDropTargetCluster.getCenter();
			var mediaId = dragDropTargetCluster.markers_[0].id;
			dragDropTargetCluster = null;
			if (pos) {
				return (pos.lat + "," + pos.lng + "," + mediaId);
			}
		}
		return "";
	}
	
	var fitBounds = function( neLat, neLng, swLat, swLng ){
		var ne = new mapboxgl.LngLat( neLng, neLat );
		var sw = new mapboxgl.LngLat( swLng, swLat );
		var bounds = new mapboxgl.LngLatBounds( sw, ne );
		map.fitBounds( bounds );
	}
	
	var setZoom = function(zoom){
		map.setZoom(zoom);
	}
	
	var getLocationFromImageId = function( imageId ){
		
		var marker = currentMarkersMap[ imageId ];
	
		if ( marker ) {
			var pos = marker.getLngLat();
			callCallback( "sendJSResults", pos.lat, pos.lng );
		}
	}
	
	var setClusterSize = function( size ){

		markerClusterer.setGridSize( size );
		markerClusterer.resetViewport();
		markerClusterer.redraw();
	}
	
	//TODO anggupta-temp: maxZoom for mapbox impl
	var getMaxZoom = function() {
		if ( map == null ) return;
		var mapTypeId = map.getMapTypeId();
		if ( mapTypeId == null ) return;

		if ( ( mapTypeId == google.maps.MapTypeId.SATELLITE
				|| mapTypeId == google.maps.MapTypeId.HYBRID )
			&& maxZoomOverride ) {

			return maxZoomOverride;
		}

		var mapType = map.mapTypes.get( mapTypeId );
		if ( mapType == null ) return;
		return mapType.maxZoom;
	}
	
	var maxZoomChanged = function( result ) {

		if ( result && result.status == google.maps.MaxZoomStatus.OK ) {
			if ( result.zoom != maxZoomOverride ) {
				maxZoomOverride = result.zoom;
				callCallback( "onMaxZoomChanged", result.zoom );
			}
		} else {
			maxZoomOverride = null;
		}
	}

	var checkMaxZoom = function() {
		if ( map == null ) return;
		if ( maxZoomService == null ) return;
		
		var mapTypeId = map.getMapTypeId();
		var center = map.getCenter();

		if ( mapTypeId == google.maps.MapTypeId.SATELLITE
			|| mapTypeId == google.maps.MapTypeId.HYBRID ) {

			maxZoomService.getMaxZoomAtLatLng( center, maxZoomChanged );
		}
	}
	
	var getClickedClusterCount = function() {
		if ( clickedCluster ) {
			return clickedCluster.markers_.length;
		} else {
			return null;
		}
	}

	var getClickedClusterImageId = function( index ) {	
		if ( clickedCluster == null ) return -1;
		if ( index < 0 || index >= clickedCluster.markers_.length ) return -1;
		return clickedCluster.markers_[ index ].id;
	}

	var selectAllPhotosInClickedCluster = function() {
		if ( clickedCluster ) {
			var count = getClickedClusterCount();
			if ( count && count > 0 ) {
				var clickedClusterIds = [];
				
					
				
				for ( var i = 0; i < count; ++i ) {
					var id = getClickedClusterImageId( i );
					if ( id ) {
						clickedClusterIds.push( id );
					}
				}		

				var jsonResults = JSON.stringify( clickedClusterIds );			
				callCallback( "onClusterMarkersClick", jsonResults );
			}
		}
	}
	
	var revealPhotosInClickedCluster = function() {
		if ( clickedCluster ) {
			map.fitBounds( clickedCluster.getBounds() );
			clickedCluster = null; 
		}
	}
	
	var highlightMarkers = function(imageIdListStr) {
		var imageIdList = imageIdListStr.split(',');
		if(imageIdList.length <= 0 ) return;
		
		var mapBounds = map.getBounds();
		var isAnyMarkerVisible = false;
		selectedMarkers = [];
		for (var i = 0; i < imageIdList.length; ++i) {
			var imageId = imageIdList[i];
			if(imageId in currentMarkersMap) {
				var marker = currentMarkersMap[imageId];
				if(marker) {
					var markerInfo = new Object();
					var markerPosition = marker.getLngLat();
					markerInfo.id = marker.id;
					markerInfo.lat = markerPosition.lat;
					markerInfo.lng = markerPosition.lng;
					selectedMarkers.push(markerInfo);
					isAnyMarkerVisible = lngLatBoundsContainPoint(mapBounds, markerPosition);
				}
			}
		}
		updateMarkers();
		if(!isAnyMarkerVisible)
			waitingTimeOut = setTimeout( function() { 
										if(selectedMarkers.length)
											setCenter(selectedMarkers[0].lat, selectedMarkers[0].lng);
							}, 1000);		//bring pin associated with first selected media to focus
	}
	
	var setCenter = function( lat, lng, jumpTo ) {
	
		var currentCenter = map.getCenter();
		var currentLat = currentCenter.lat;
		var currentLng = currentCenter.lng;
		
		if ( lat == null )
			lat = currentLat;
		if ( lng == null )
			lng = currentLng;
			
		if ( lat == currentLat && lng == currentLng )
			return;
	
		var point = new mapboxgl.LngLat( lng, lat );
		
		if ( jumpTo )
			map.setCenter( point );
		else
			map.panTo( point );
		
	}
	
	var dropMarker = function( lat, lng, calloutText, bOnExistingPin ){
	
		if(searchMarker)
			return;
	

		var latlng = new mapboxgl.LngLat( lng, lat );
		
		if(! bOnExistingPin) {
		    var el = document.createElement('div');
		    var img = document.createElement('img');
		    img.setAttribute('draggable', false);
			img.src = searchYellowMarker;
			el.appendChild(img);

		    searchMarker = new mapboxgl.Marker(el)
		        .setLngLat(latlng)
		        .addTo(map);
			searchMarker.dragged = 0;

		    function onMove(e) {
		        var coords = e.lngLat;
		        searchMarker.setLngLat([coords.lng, coords.lat]);
				searchMarker.dragged = 1;
				clearSearchCallout();			
		    }

		    function onUp(e) {
		        var coords = e.lngLat;
				showSearchCallout(calloutText, searchMarker.getLngLat().lat, searchMarker.getLngLat().lng, false);
		        map.off('mousemove', onMove);
		    }

		    var noOfJumps = 0, goingUp = true, previousZoom = getZoom();

		    var jumpMarker = function() {
		    	if(!searchMarker) {
		    		requestAnimationFrame(jumpMarker);
		    	}
		    	else {
			    	var current_point = map.project(searchMarker.getLngLat());
			    	var original_point = map.project(latlng);
			    	if(previousZoom == getZoom() && Math.abs(current_point.y - original_point.y) < 35 && Math.abs(current_point.x - original_point.x) < 0.001) {
				    	if(goingUp) {
				    		current_point.y--;
				    		if(current_point.y-original_point.y<-30)
				    			goingUp = false;
				    	}
				    	else{
				    		current_point.y++;
				    		if(current_point.y-original_point.y>0) {
				    			goingUp = true;
					    		noOfJumps++;
					    	}

				    	}
				    	if(noOfJumps<4){
					    	searchMarker.setLngLat(map.unproject(current_point));
					    	requestAnimationFrame(jumpMarker);
				    	}
				    	else{
						    el.addEventListener('mousedown', function(e) {
						        e.stopPropagation();
						        map.on('mousemove', onMove);
						        map.once('mouseup', onUp);
						    });
					    	searchMarker.setLngLat(latlng);
				    	}
				    }
				    else{
				    	previousZoom = getZoom()
				    	searchMarker.setLngLat(latlng);
				    	requestAnimationFrame(jumpMarker);
				    }
				}
		    }

		 	jumpMarker();

		}
		
		showSearchCallout(calloutText, latlng.lat, latlng.lng, bOnExistingPin);
							
	
	};
	
	var clearSearchMarker = function(){
		if(searchMarker){
			searchMarker.remove();
			searchMarker = null;	
		}
		clearSearchCallout();
	};
		
	var lockMarkers = function( locked ){
		disableDragging = locked;
		for( var imageId in currentMarkersMap ) {
			var marker = currentMarkersMap[ imageId ];
			if ( marker != null ) {
				marker.setDraggable( !locked );
			}
		}

		// lock/unlock all clusters. 
		markerClusterer.updateClustersAsNeeded( true );
		
	}
	
	
	var updateHoverViewIcons = function(bEnable)
	{		
		markerClusterer.updateEnableHoverIcons(bEnable);
		markerClusterer.updateClustersAsNeeded( true );
	
	}
	
	
	
	var selectClusterContainingImage = function( imageId ){
		var imageMarker = currentMarkersMap[ imageId ];
	
		if ( imageMarker ) {
			for ( var i = 0, cluster; cluster = markerClusterer.clusters_[ i ]; i++ ) {
				for ( var j = 0, marker; marker = cluster.markers_[ j ]; j++ ) {
					if ( marker == imageMarker ) {
						clickedCluster = cluster;
						return;
					}
				}
			}
		}
	}
	
	var clearClickedCluster = function() {
		clickedCluster = null;
	}
	
	var getClickedClusterType = function() {
		if ( getClickedClusterCount() > 1 ) {
			var isGroup = clickedCluster.isGroupCluster;
			if( isGroup == true ) {
				callCallback( "sendJSResults", "group" );
			} else {
				callCallback( "sendJSResults", "cluster" );
			}
		}
	}
	
	var getClickedClusterCenter = function() {
		if ( clickedCluster != null ) {
			var pos = clickedCluster.getCenter();
			if( pos != null ) {
				callCallback( "sendJSResults", pos.lat, pos.lng );
			}
		}
	}
	
	var getLocationToViewPoint = function( lat, lng ) {
		if ( map != null ) {
			var latlng = new mapboxgl.LngLat( lng, lat );
			var point = locationToViewPoint( latlng );
			return point.toString();
		}
	}
	
	var getViewPointToLocation = function( x, y ) {
		if ( map != null ) {
			var point = new mapboxgl.Point( x, y );
			var latlng = viewPointToLocation( point );
			return latlng.toString();
		}	
	}

	
//this will be called after alias is applied to any tag
//it will iterate for whole clusters and recompute the strings for tagIds present	
	var clustersCheckForAliasUpdate = function() {
	
	setTimeout( function() {
		var clusterArray = [];
		clusterArray = markerClusterer.getClusters();
		
		for (var i = 0, cluster; cluster = clusterArray[i]; i++) {
			
			var tagIdList = cluster.getTagIdList();
			var lat = cluster.getCenter().lat;
			var lng = cluster.getCenter().lng;
			
			var cmnTags = 0;
			if(cluster.hasCommonTags())
			 cmnTags = 1;
			
			var arg = cmnTags + "," + lat + "," + lng + "," + tagIdList ;
			
			callCallback("getLocationNameForClusterViaTagIdList",arg);
			
		}
	},0);
	
};
	
	var updateLocationOfCluster = function(strList, tagIdList, bHaveCommonTags, lat, lng) {
		var resultList = strList;
		var centerPt = new mapboxgl.LngLat( lng, lat );
		markerClusterer.updateClusterText( centerPt, resultList, bHaveCommonTags, tagIdList);
	
	}
	
	function element( name, content){
		var xml;
		if (!content){
			xml='<' + name + '/>';
		}
		else {
			xml='<'+ name + '>' + content + '</' + name + '>';
		}
		return xml;
	}

	function processResults(results, geoCodeType) {
		var mappedResults = [];
		var status = "OK";
		// transform the results into something more JSON-friendly
		//check for empty or zero results
		if(results[0] !== undefined){

			for ( var i = 0; i < results.length; i++ ) {
				var result = results[i];
				if(result.context == null)
					result.context = [];
				result.context.unshift(result);
				var components = []
				for (var j = 0; j < result.context.length; j++) {
					var component = "";
					switch ( result.context[j]['id'].split('.')[0]) {
						case "landmarks":
							component = component + element("district", result.context[j]['text']);
							break;
						case "poi":
							component = component + element("point_of_interest", result.context[j]['text']);
							break;
						case "neighborhood":
							component = component + element("neighborhood", result.context[j]['text']);
							break;	
						case "address":
							component = component + element("street_address", result.context[j]['text']);
							break;	
						case "locality":
							component = component + element("administrative_area_level_3", result.context[j]['text']);
							break;
						case "place":
							component = component + element("locality",  result.context[j]['text']);
							break;
						case "district":
							component = component + element("administrative_area_level_2",  result.context[j]['text']);
							break;	
						case "region":
							component = component + element("administrative_area_level_1",  result.context[j]['text']);
							break;
						case "country": 
							component = component + element("country",  result.context[j]['text']);
							break;
						default : 
							break;
					}
					components.push(element("component", component));
				}
				var componentResults = element("components", components);

				var lat, lng;
				lat = result.center[1];
				lng = result.center[0];
				if ( result.bbox == null ) {
					result.bbox = [lng, lat, lng, lat];
			    }

				mappedResults.push(element("result", 
									element("title", result["place_name"]) + 
									element("location", element("lat", lat) + element("lng", lng)) +
									element("components", componentResults) +
									element("bounds", element("neLat", result.bbox[3]) + element("neLng", result.bbox[2]) + element("swLat", result.bbox[1]) + element("swLng", result.bbox[0]))));

		    }
			var xmlResults = element("results", mappedResults);	
			if(geoCodeType == "geoCode")
				callCallback( "geocodeCallback", status, xmlResults );
			else if(geoCodeType == "reverseGeoCode")
				callCallback( "reverseGeocodeCallback", status, 1, xmlResults );
			else
				callCallback( "reverseGeocodeCallback", status, 0, xmlResults );

		}
		else{
			status = "ZERO_RESULTS";
			if(geoCodeType == "geoCode")
				callCallback( "geocodeCallback", status, xmlResults );
			else if(geoCodeType == "reverseGeoCode")
				callCallback( "reverseGeocodeCallback", status, 1, xmlResults );
			else
				callCallback( "reverseGeocodeCallback", status, 0, xmlResults );
		}
		
	}
	
	var geoCode = function() {
		var addressString = arguments[0];
		var lat = arguments[1];
		var lng = arguments[2];
		var geoCodeType = arguments[3];

	    if(!mapboxClient)
	    	mapboxClient = new MapboxClient(mapboxgl.accessToken);

		if ( lat && lng && lat != "" && lng!="") {
			mapboxClient.geocodeReverse({ latitude: lat, longitude: lng }, { dataset: 'mapbox.places-permanent' , language : locale }, function(err,data) {
				var results = [];
				results.push(data.features[0]);
				processResults(results, geoCodeType);
			});
		}
		else if ( addressString !="NO_ADDRESS_FOUND" &&  addressString != "" ) {
			mapboxClient.geocodeForward(addressString, { dataset: 'mapbox.places' , language : locale }, function(err,data) {
				var results = [];
				for(var i = 0; i < data.features.length; i++) {
					results.push(data.features[i]);
				}
				processResults(results, geoCodeType);
			});
		}
	}
	
	var processUIEvents = function() {
		if(!timerActive) return;
		callCallback("processUIEvents");
	}
	
	var stopProcessUITimer = function() {
		timerActive = false;
	}
	
	var notifyGPSTagSuccess = function (success) {
		if(!success)
		{
			pinMoveCancelled(draggedPin);
		}
		draggedPin = null;
	}	
	
	var initialMarkerLayout = function ( latList, lngList, idList){
		//callCallback("startTimer", "markerLayout");
		var latitudeList = latList.split(',');
		var longitudeList = lngList.split(',');
		var mediaList = idList.split(',');
			
		for(var i=0; i<mediaList.length; i++){
			var markerInfo = new Object();
			markerInfo.id = mediaList[i];	
			markerInfo.lat = latitudeList[i];
			markerInfo.lng = longitudeList[i];
			addedMarkers.push( markerInfo );
		}
		timerActive = true;
		//processUIEvents();
		
		updateMarkers();
		//callCallback("endTimer", "markerLayout");
		/*//alert(time.report());*/
		
		stopProcessUITimer();
	}
	
	var addImage = function ( idList, lat, lng ){
		
		//alert("add image");			
		var mediaList = idList.split(',');
		
		for(var i=0; i<mediaList.length; i++){
			var markerInfo = new Object();
			markerInfo.id = mediaList[i];	
			markerInfo.lat = lat;
			markerInfo.lng = lng;
			addedMarkers.push( markerInfo );
		}
		updateMarkers();
	}
	
	var removeImage = function ( idList ){
		//alert("remove image");	
		
		var mediaList = [];
		mediaList = idList.split(",");
		
		for(var i=0; i<mediaList.length; i++){
			var markerInfo = new Object();
			markerInfo.id = mediaList[i];
			deletedMarkers.push( markerInfo );
		}
		updateMarkers();
	}
	
	var updateMarkers = (function() {
	//alert("updateMarkers");
	
	//callCallback("startTimer", "Enter updateMarker");	
	/*
	if ( resetMarkers ) {	
			previousAvailableSet = null;
			previousSelectedSet = null;
			clearMarkers();
		}*/
	timerActive = true;
	//processUIEvents();		
	
	var availableSet = new Object();

	//callCallback("startTimer", "Iterating markerMap");
	for (var v in currentMarkersMap) {
		var markerInfo = new Object();
		markerInfo.id = currentMarkersMap[v].id;	
		markerInfo.lat = currentMarkersMap[v].getLngLat().lat;
		markerInfo.lng = currentMarkersMap[v].getLngLat().lng;
		availableSet[markerInfo.id] = markerInfo;
	}
	
	//callCallback("endTimer", "Iterating markerMap");
	//alert("availableSet: "+Object.size(availableSet));
	//alert("addedmarkers: "+addedMarkers.length);
 
	//callCallback("startTimer", "Iterating addedMarkers");	
	for (var i = 0; i < addedMarkers.length; ++i) {
		var id = addedMarkers[i].id;
		availableSet[id] = addedMarkers[i];
	}
	//callCallback("endTimer", "Iterating addedMarkers");
	//alert("availableSet: "+Object.size(availableSet));
	for ( i = 0; i < deletedMarkers.length; ++i) {
		var id = deletedMarkers[i].id;
		delete availableSet[id];
	}
	
	//alert("availableSet: "+Object.size(availableSet));
	var selectedSet = new Object();
	
	//callCallback("startTimer", "Iterating selectedmarkers");
	for ( i = 0; i < selectedMarkers.length; ++i) {
		var id = selectedMarkers[i].id;
		selectedSet[id] = selectedMarkers[i];
	}
	//callCallback("endTimer", "Iterating selectedmarkers");
//	alert("selectedSet: "+Object.size(selectedSet));

	var added = [];
	var addedSet = new Object();
	var removed = [];
	var moved = [];
	var selected = [];
	var deselected = [];

	//callCallback("startTimer", "Iterating availableSet");
	for(var id in availableSet) {
		var markerInfo = availableSet[id];
		if(previousAvailableSet[id]) {
			var previousMarker = previousAvailableSet[ id ];
			if (markerInfo.lat && markerInfo.lng && previousMarker.lat && previousMarker.lng && 
				  !identicalCoordinates( markerInfo.lat, markerInfo.lng, previousMarker.lat, previousMarker.lng )) {
				moved.push(markerInfo);
			}
		}
		else {
			added.push(markerInfo);
			addedSet[ markerInfo.id ] = markerInfo;
		}
			
		if (selectedSet[ id ] && !previousSelectedSet[ id ]) {
			selected.push(markerInfo.id );
		}
		else if (!selectedSet[ id ] && previousSelectedSet[ id ]) {
			deselected.push(markerInfo.id );
		}
	}
	
	//callCallback("endTimer", "Iterating availableSet");
	//alert("added: "+added.length + "moved: "+moved.length + "addedSet: "+Object.size(addedSet) + "selected: "+selected.length +"deselected: "+deselected.length );
	//callCallback("startTimer", "Iterating previousavailableSet");
	for(var id in previousAvailableSet) {
		var markerInfo = previousAvailableSet[id];
		if (!availableSet[ id ]) {
			removed.push(markerInfo );
		}
	}
	//callCallback("endTimer", "Iterating previousavailableSet");	
	//alert("removed: "+removed.length);
	
	if (added.length > 0 || removed.length > 0 || moved.length > 0 || selected.length > 0 || deselected.length > 0) {
		
		markerClusterer.setReady_( false );

		var clickedClusterIdSet = null;
		
		/*
			if ( clickedCluster && clickedCluster.markers_ ) {
						
						// this cluster may be deleted and recreated by the update, so we need to record 
						// which photos it contains and reselect the cluster that contains them after the 
						// update.
					
						clickedClusterIdSet = [];
						for ( var i = 0, marker; marker = clickedCluster.markers_[ i ]; i++ ) {			
							if ( marker.id ) {
								clickedClusterIdSet[ marker.id ] = true;
							}
						}
					}*/
			

		var selectedMarkerIdSet = [];
		var deselectedMarkerIdSet = [];
		var selectedMarkerCount = 0;
		var deselectedMarkerCount = deselected.length;
		
		//callCallback("startTimer", "Iterating deselected");

		for ( var i = 0, id; id = deselected[ i ]; ++i )
			deselectedMarkerIdSet[ id ] = true;

		//callCallback("endTimer", "Iterating deselected");
		//callCallback("startTimer", "Iterating selected");
		for ( var i = 0, id; id = selected[ i ]; ++i ) {
			if ( deselectedMarkerIdSet[ id ] != true ) {
				selectedMarkerIdSet[ id ] = true;
				selectedMarkerCount++;
			}
		}
		//callCallback("endTimer", "Iterating selected");
		//alert("selectedIdSet"+selectedMarkerIdSet.length + "deselectedIdSet"+deselectedMarkerIdSet.length	);	
		
		var removedCnt = 0;

		for (var i=0; i < removed.length; i++) {
			var theImageId = removed[ i ].id;
			//alert("removing");
			var marker = currentMarkersMap[ theImageId ];
			if ( marker ) {
			
				removedCnt = removedCnt + 1;
			
				markerClusterer.removeMarker( marker, true );
				
				// make sure it is invisible and garbage collected
				marker.setVisible( false );
				//marker.setMap( null );
				delete marker;
			}
			
			currentMarkersMap[ theImageId ] = null;
			delete currentMarkersMap[theImageId];
			if(markersMap[theImageId])
			{
				//alert("we are good");
				markersMap[ theImageId ] = null;
				delete markersMap[theImageId];
			}
		}

		var needsRefresh = false;
		//callCallback("startTimer", "moving markers");
		for (var i=0; i < moved.length; i++) {
			var markerInfo = moved[ i ];
			var theImageId = markerInfo.id;

			//alert( "moved marker: " + theImageId );

			var marker = currentMarkersMap[ theImageId ];
			if ( marker ) {

				//alert( "found moved marker position: "  + marker.getLngLat());

				// constrain the marker's location so it doesn't fall far outside of the map
				var lat = Math.max( -MAX_LATITUDE, Math.min( MAX_LATITUDE, markerInfo.lat ) );

				var myLatlng = new mapboxgl.LngLat( markerInfo.lng, lat );
				
				//callCallback("startTimer", "moving markers in markerclusterer");
				var wasRemoved = markerClusterer.removeMarkerFromClusters_( marker, true);
				
				marker.setLngLat( myLatlng );
				
				var wasAdded = markerClusterer.addMarkerToClusters_( marker, true);
				//callCallback("endTimer", "moving markers in markerclusterer");
				needsRefresh = needsRefresh || wasRemoved || wasAdded;

				//alert( "wasRemoved? " + wasRemoved + ", wasAdded? " + wasAdded + ", needsRefresh? " + needsRefresh );
				
			}
		}
		//callCallback("endTimer", "moving markers");
		
//alert( "adding " + added.length + " new markers to clusterer..." );
		
		var noRedraw = added.length > 100;
		//callCallback("startTimer", "Iterating added");
		for (var i=0; i < added.length; i++) {
			if(!timerActive) break;									//there might be case when marker processing is ongoing and user leaves the room.
			
			var markerInfo = added[ i ];
			var theImageId = markerInfo.id;

			// constrain the marker's location so it doesn't fall far outside of the map
			var lat = Math.max( -MAX_LATITUDE, Math.min( MAX_LATITUDE, markerInfo.lat ) );
			//var myLatLng = new google.maps.LatLng( lat, markerInfo.lng );
			var myLatLng = new mapboxgl.LngLat(markerInfo.lng, lat)
			
			if(markersMap[theImageId])
			{
				var marker = markersMap[theImageId];
				marker.setLngLat(myLatLng);
			}
			
			else
			{
				var marker = new MarkerInfo();
				marker.setLngLat(myLatLng);

				//callCallback("startTimer", "adding eventlisteners");
				//anggupta: I think this is unused code.
				/*addMouseoverListener( marker);
				marker.hookup = function(marker) {
					addClickListener( marker);
					addDblClickListener(marker);
					addRightClickListener( marker);
					addMouseoutListener( marker);
					addDragStartListener( marker);
					addDragListener( marker);
					addDragEndListener( marker);
					marker.hookup = null;
				};*/
			//callCallback("endTimer", "adding eventlisteners");
			
				markersMap[theImageId] = marker;
			}

			marker.clickable = true;
		    marker.setDraggable(!disableDragging); // = !disableDragging; // apparently, marker.draggable = true doesn't work, but marker.setDraggable(true) works.
			marker.raiseOnDrag = false;
			marker.id = theImageId;
			marker.visible = false;			
			marker.selected = false;

			if ( markerInfo.selected ) {
				marker.selected = true;			
			} 

			currentMarkersMap[ theImageId ] = marker;
		//callCallback("startTimer", "adding marker to markerclusterer");
			markerClusterer.addMarker( marker, noRedraw );
		//callCallback("endTimer", "adding marker to markerclusterer");
		}
		
		//callCallback("endTimer", "Iterating added");
		var selectionAddedCount = 0;
		var selectionRemovedCount = 0;
		//callCallback("startTimer", "Iterating clusters");
		for ( var i = 0, cluster; cluster = markerClusterer.clusters_[ i ]; i++ ) {
				var clusterChanged = false;
				for ( var j = 0, marker; marker = cluster.markers_[ j ]; j++ ) {
					if ( marker ) {
						if ( !marker.selected && selectedMarkerIdSet[ marker.id ] ) {
							//anggupta-temp marker.setIcon( /*selectedMarkerImage*/baseThumbUrl + currCatalogVersion + "=" + marker.id );

							marker.selected = true;
							clusterChanged = true; 
							selectionAddedCount++;
						} else if ( marker.selected && deselectedMarkerIdSet[ marker.id ] ) {
							//anggupta-temp marker.setIcon( /*normalMarkerImage*/baseThumbUrl + currCatalogVersion + "=" + marker.id );

							marker.selected = false;
							clusterChanged = true;
							selectionRemovedCount++;
						}
					}
				}
	
				if ( clusterChanged && cluster.markers_.length >= 1 )
					cluster.updateIcon();
		}
		//callCallback("endTimer", "Iterating clusters");

		// If we selected or deselected fewer markers than we were supposed to that means they do not yet have clusters. This
		// can happen if you click on a photo in the filmstrip that is has not yet been shown in the map at the current zoom level,
		// so it's not in any cluster yet. If that happens, take the hit of iterating over all markers in the clusterer to update
		// their selected state.
		//callCallback("startTimer", "Iterating allmarkers");
		if ( selectionAddedCount < selectedMarkerCount || selectionRemovedCount < deselectedMarkerCount ) {		
			for ( var i = 0, marker; marker = markerClusterer.markers_[ i ]; i++ ) {
				if ( !marker.selected && selectedMarkerIdSet[ marker.id ] ) {
					//marker.setIcon( /*selectedMarkerImage*/baseThumbUrl + currCatalogVersion + "=" + marker.id );
					marker.selected = true;
				} else if ( marker.selected && deselectedMarkerIdSet[ marker.id ] ) {
					//marker.setIcon( /*normalMarkerImage*/baseThumbUrl + currCatalogVersion + "=" + marker.id );
					marker.selected = false;
				}
			}
		}
		
		//callCallback("endTimer", "Iterating allmarkers");
		//if ( needsRefresh || removed > 0 ) {
		
		//callCallback("startTimer", "updating markerclusterer");
		if ( removedCnt > 0 ) {
//no need of recreating clusters as currently one cluster is removed in total
//			markerClusterer.resetViewport();
		} else if ( moved.length > 0 ) {
			//markerClusterer.redraw();

			markerClusterer.updateClustersAsNeeded(); // updates selected vs. unselected state
		} else if ( selected.length > 0 || deselected.length > 0 ) {

			markerClusterer.updateClustersAsNeeded(); // updates selected vs. unselected state
		}

		markerClusterer.setReady_(false);
		markerClusterer.setReady_(true);
		markerClusterer.redraw();

		
		//markerClusterer.updateClustersAsNeeded();
		
		//callCallback("endTimer", "updating markerclusterer");
		
		/*
				if ( clickedClusterIdSet ) {
				
							// reselect the cluster that best matches the set of photos in the
							// clicked cluster before the update
						
							var bestMatchCount = 0;
							
							for ( var i = 0, cluster; cluster = markerClusterer.clusters_[ i ]; i++ ) {
								var matches = 0;
								for ( var j = 0, marker; marker = cluster.markers_[ j ]; j++ ) {
									if ( marker && clickedClusterIdSet[ marker.id ] )
										matches++;
								}
								if ( matches > bestMatchCount ) {
									clickedCluster = cluster;
									bestMatchCount = matches;
								}
							}*/		
	}	
	addedMarkers = [];
	deletedMarkers = [];
	//selectedMarkers = [];

	previousSelectedSet = selectedSet;
	previousAvailableSet = availableSet;
	//callCallback("endTimer", "Enter updateMarker");
	
	stopProcessUITimer();
	
	});
			
	var addClickListener = function( marker) {
				google.maps.event.addListener( marker, 'click', function() {	
				//alert('clusterclicked');
					var center = marker.getLngLat();
					clickedPin = marker;
					var centerX, centerY;
					if ( center ) {
						center = locationToViewPoint( center );
						centerX = center.x;
						centerY = center.y;
					}
					
					if ( bouncingMarker ) {
						if ( bouncingMarker.setAnimation )
							bouncingMarker.setAnimation( null );
						bouncingMarker = null;
					}
					
					selectedMarkers = [];
					var markerInfo = new Object();
					markerInfo.id = marker.id;
					markerInfo.lat = marker.getLngLat().lat;
					markerInfo.lng = marker.getLngLat().lng;
					selectedMarkers.push(markerInfo);
					updateMarkers();
					
					callCallback( "onMarkerClick", marker.id, centerX, centerY);
				} );
			};
			
			
			var addDblClickListener = function( marker) {
				google.maps.event.addListener( marker, 'dblclick', function() {	
						showSelectedClusterMedia(marker);
				});
			};
			
			
			var addRightClickListener = function( marker) {
				
				google.maps.event.addListener( marker, 'rightclick', function() {		
					var center = marker.getLngLat();
					var centerX, centerY;
					if ( center ) {
						center = locationToViewPoint( center );
						centerX = center.x;
						centerY = center.y;
					}
					callCallback( "onMarkerRightClick", marker.id );
				} );
			
			};
			
			var addMouseoverListener = function( marker) {
				google.maps.event.addListener( marker, 'mouseover', function() {
					//alert("mouse over");
					if(marker.hookup) {
						marker.hookup(marker);
						marker.hookup = null;
					}
					callCallback( "onMarkerMouseover", marker.id);
				} );
				
			};
	
			var addMouseoutListener = function( marker) {
				
				google.maps.event.addListener( marker, 'mouseout', function() {
					
					callCallback( "onMarkerMouseout", marker.id);
				} );
				
			};
	
			var addDragStartListener = function( marker) {
				//alert("drag start");
				google.maps.event.addListener( marker, 'dragstart', function( mouseEvent ) {
					callCallback( "onMarkerDragStart", mouseEvent.lngLat.lat, mouseEvent.lngLat.lng, marker.id);
					dragDropTargetCluster = markerClusterer.canAcceptMarkerDrop( marker, false, dragDropTargetCluster );
					//alert("dragStart: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
				} );
			};
		
			var addDragListener = function( marker) {
				google.maps.event.addListener( marker, 'drag', function( mouseEvent ) {
					lastDragTime = new Date().getTime();
					clearSearchCallout();
					dragDropTargetCluster = markerClusterer.canAcceptMarkerDrop( marker, false, dragDropTargetCluster );
					//alert("dragMoveMarker: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
					callCallback( "onMarkerDrag", mouseEvent.lngLat.lat, mouseEvent.lngLat.lng, marker.id);						
				} );
			};
		
			var addDragEndListener = function( marker) {
				google.maps.event.addListener( marker, 'dragend', function( mouseEvent ) {
					//alert("in dragendlistener");
					if(draggedPin && draggedPin !== marker)
					{
						//alert("clear existing drag");
						pinMoveCancelled(draggedPin);
					}
					//alert("clearing searchmarker");
					clearSearchMarker();
					draggedPin = marker;
					//alert("check for existing pin");
					dragDropTargetCluster = markerClusterer.canAcceptMarkerDrop( marker, false, dragDropTargetCluster );
					//alert("markerDragEnd: " + dragDropTargetCluster.getCenter().lat + "," + dragDropTargetCluster.getCenter().lng);
					var success = false;
					var existingImageId = 0;
					if (dragDropTargetCluster) {
					//	alert("existing pin found");
						existingImageId = dragDropTargetCluster.markers_[0].id;
						var pos = dragDropTargetCluster.getCenter();
						if (pos) {
							success = true;
							marker.setLngLat(pos);
							callCallback( "onMarkerDragEnd", pos.lat, pos.lng, existingImageId );
						}
					}
					
					if (!success) {
						callCallback( "onMarkerDragEnd", mouseEvent.lngLat.lat, mouseEvent.lngLat.lng, existingImageId );
					}
					
					dragDropTargetCluster = null;
				} );
			};

	function identicalCoordinates( lat1, lng1, lat2, lng2 ) {
		if (Math.abs( lat1 - lat2 ) <= 1.0e-10 && Math.abs( lng1 - lng2 ) <= 1.0e-10) {
			return true;
		}
		return false;
	}
	
	var setInitialMapParams = function(lat, lng, zoom, mapStyle)
	{
		if(lat && lng)
		{
			defaultLat = lat;
			defaultLng = lng;
		}
		if(zoom > 2)
			defaultZoom = zoom;
			
		if(mapStyle.length)
			defaultMapStyle = mapStyle;
	}
	
	
	
	var updateCurrVersion = function()
	{
		currCatalogVersion++;
	}
