/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2020 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by all applicable intellectual property laws,
 * including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/

//class to handle the interaction between browser cempod and UI.

class CEMHelper {
    static getQueryParams(params) {
        var paramsStr = "";
        for (var key in params) {
            if (params.hasOwnProperty(key)){
                if(paramsStr == ""){
                    paramsStr = "?";
                }
                else{
                    paramsStr += "&";
                }
                paramsStr = paramsStr + key + "=" + encodeURIComponent(params[key]);
            }
        }
    
        return paramsStr;
    }
    static sendEventToApp(eventName, params, callback){
        try {
            params = (typeof params === "undefined") ? {} : params;
            params.timestamp = new Date().getTime();
            callback = (typeof callback === "undefined") ? null : callback;
            //  Same scheme used for Mac and Win platform
            var eventScheme = "cemjsaction://";
            var eventURL = eventScheme + eventName + CEMHelper.getQueryParams(params);
            if(navigator.platform.indexOf("Win")!=-1){
                var xmlhttp = new XMLHttpRequest();
                xmlhttp.onreadystatechange = function() {
                    if (xmlhttp.readyState == 4 ) {
                        if(xmlhttp.status == 200) {
                            if(callback)
                                return callback(xmlhttp.responseText);
                        }
                    }
                }
                xmlhttp.open("GET", eventURL, true);
                xmlhttp.send();
            }
            else {
                webClient.sendMessage({
                    type: "macApp",
                    params: eventURL
                }).then((response) => {
                    if(callback)
                        return callback(atob(response));   
                }).catch((reason) => {
                    // Code reaches here in case of any exception
                });
            }
        }
        catch(err){
    
        }
    }
}

CEMHelper.sEventName = {};
// Event Name
CEMHelper.sEventName.kGetHoverThumbnail = "getHoverThumbnail";
CEMHelper.sEventName.kGetNormalThumbnail = "getNormalThumbnail";
CEMHelper.sEventName.kGetLocaleToken = "getLocaleToken";
CEMHelper.sEventName.kGetAccessToken = "getAccessToken";
CEMHelper.sEventName.kGetResourceData = "getResourceData";
CEMHelper.sEventName.kGetMapsAPIVersion = "getMapsAPIVersion";
CEMHelper.sEventName.kGetMapsPluginVersion = "getMapsPluginVersion";