var isRunningOnWindows = "yes";

window.addEventListener("keydown", keyPressHandler, false);
//window.addEventListener("keypress", keyPressHandler, false);
//window.addEventListener("keyup", keyPressHandler, false);
//window.addEventListener("mousedown", mousePressHandler, false);


//we need to disable default behaviour of key events in browser
function keyPressHandler(e) {
    if (e.which == 27) {
        e.preventDefault();
        sendEventToApp("jsEscapeAction", {}, null);
    }
}

function getQueryParams(params){
    var paramsStr = "";
    for (var key in params) {
        if (params.hasOwnProperty(key)){
            if(paramsStr == ""){
                paramsStr = "?";
            }else{
                paramsStr += "&";
            }
            paramsStr = paramsStr + key + "=" + encodeURIComponent(params[key]);
        }
    }

    return paramsStr;
}

function sendEventToApp(eventName, params, callback){
        try {
            params = (typeof params === "undefined") ? {} : params;
            params.timestamp = new Date().getTime();
            callback = (typeof callback === "undefined") ? null : callback;
            // params["kEventGroupKey"] = eventGroupKey;

            var eventScheme;
            if(isRunningOnWindows == "yes"){
                eventScheme = "cemjsaction://";
            }else if(isRunningOnWindows == "no"){
                eventScheme = "http://cemjsaction/";
            }else{
                return;
            }

            var eventURL = eventScheme + eventName + getQueryParams(params);
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState == 4 ) {
                    if(xmlhttp.status == 200){
                        if(callback != null)
                            callback(JSON.parse(xmlhttp.responseText));
                    }
                }
            }

            xmlhttp.open("GET", eventURL, true);
            xmlhttp.send();
        }catch(err){

        }
}
