# dcx-nan
Native Abstractions for Node.js wrapper around the [Adobe DCX-C++ Library](https://git.corp.adobe.com/DMA/dcx-cpp).

## Quick-Start
This repo contains the installable binary for the `AdobeDCXLibrary` Native Abstractions for Node.js wrapper. The binaries are built from sources in the repo: https://git.corp.adobe.com/mortimer/dcx-js-nan

Before running, you will need to have Node.js installed for the platform you are intending to run under. Supported platforms are 64-bit macOS, and Windows x64/x86.

Current developmental branch: `v4`

## Usage
```
const AdobeDCXLibrary = require('dcx-nan');

const DCXLIB_CONFIG = {
  appID: 'com.adobe.dcx.myapp.id',
  preserveFileExtensions: true,
  xhrBaseBranchSupport: false,
  maxClientDataLength: 4096,
  logLevel: DCX_LOG_LEVEL.ALWAYS,
  logCallback: console.log
};

let dcx = AdobeDCXLibrary.newInstance(DCXLIB_CONFIG);

```

## Testing
Unit testing is run through `npm test` to exectute the default [Jasmine](https://jasmine.github.io) based test set.  Testing is only available through the developmental branches and is not active on the `master` branch.


