/*
*  Copyright 2016 Adobe Systems Incorporated. All rights reserved.
*  This file is licensed to you under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License. You may obtain a copy
*  of the License at http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software distributed under
*  the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
*  OF ANY KIND, either express or implied. See the License for the specific language
*  governing permissions and limitations under the License.
*
*/

$._ADBE_LIBS_PPRO = {
  getTooltipState: function () {
    return 'true';
  },
  getIMSUserID: function () {
    return app.userGuid;
  },
  getSelectedLookData: function () {
    return app.getSelectedLookData;
  },
  isAnalyticsEnabled: function () {
    return app.isUserSharingAppUsageData();
  },
  getCurrentState: function () {
    return document.getDocumentState();
  },
  placeAsset: function (filePath, isPSD, libraryName, itemName, elementRef, modifiedTime, creationTime, adobeStockId, adobeStockLicense, isLinked) {
    app.project.placeAsset(filePath, isPSD, libraryName, itemName, elementRef, modifiedTime, creationTime, adobeStockId, adobeStockLicense, isLinked);
    return;
  },
  isFontAvailable: function () {
    return 'true';
  },
  replaceColor: function (colorData) {
    // Currently PPRO does not support replaceColor
    return false;
  },
  setColor: function (colorRec) {
    // to be implemented later
    return false;
  },
  getLayerColor: function () {
    // Currently PPRO does not support getLayerColor
    var colorObject = {};
    return JSON.stringify(colorObject);
  },
  getLayerInfo: function () {
    return app.getLookInfo;
  },
  getUserData: function (mode) {
    try {
      return app.getCCXUserJSONData(mode);
    } catch (ex) {
      $._ADBE_LIBS_CORE.writeToLog('PPRO.jsx-getCCXUserJSONData()', ex);
    }
  }
};