// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PhpExpectedFunctionArgument {
  protected final int myArgumentIndex;
  protected final int myOrder;
  @Nullable
  protected final String myArgumentSet;
  private final boolean myFlag;
  private final boolean myFromAttribute;

  protected PhpExpectedFunctionArgument(int argumentIndex, int order, @Nullable String argumentSet, boolean flag, boolean fromAttribute) {
    myArgumentIndex = argumentIndex;
    myOrder = order;
    myArgumentSet = argumentSet;
    myFlag = flag;
    myFromAttribute = fromAttribute;
  }

  public int getArgumentIndex() {
    return myArgumentIndex;
  }

  public int getOrder() {
    return myOrder;
  }

  public boolean isFlag() {
    return myFlag;
  }

  @Nullable
  public String getArgumentSet() {
    return myArgumentSet;
  }

  @Nullable
  public abstract PhpNamedElement getNamedElement(@NotNull Project project);

  @NotNull
  public abstract String getValue();

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    PhpExpectedFunctionArgument argument = (PhpExpectedFunctionArgument)o;

    if (myArgumentIndex != argument.myArgumentIndex) return false;
    if (myOrder != argument.myOrder) return false;
    if (myFlag != argument.myFlag) return false;
    if (!getValue().equals(argument.getValue())) return false;
    if (myArgumentSet != null ? !myArgumentSet.equals(argument.myArgumentSet) : argument.myArgumentSet != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = myArgumentIndex;
    result = 31 * result + myOrder;
    result = 31 * result + getValue().hashCode();
    result = 31 * result + (myArgumentSet != null ? myArgumentSet.hashCode() : 0);
    result = 31 * result + (myFlag ? 1 : 0);
    return result;
  }

  public abstract boolean matches(@NotNull PsiElement actualArgument);

  public boolean isFromAttribute() {
    return myFromAttribute;
  }

  public @NotNull PsiElement createReference(Project project) {
    throw new UnsupportedOperationException();
  }
}