// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.psi.stubs.NamedStub;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.Nullable;

public interface PhpNamedStub<T extends PhpNamedElement> extends NamedStub<T>, PhpTypedStub<T> {
  short getFlags();
  @Nullable
  String getDeprecatedSinceVersion();
  boolean isInternal();
}
