// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nullable;

import static com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner.*;

public interface PhpClassStub extends PhpNamedStub<PhpClass>, PhpDeprecationInfoOwnerStub {
  String getSuperclass();
  String[] getInterfaces();
  String[] getTraits();
  String[] getMixins();
  boolean isInterface();
  boolean isTrait();
  boolean isAbstract();
  boolean isFinal();
  boolean hasOwnStaticMembers();
  boolean hasMethodTags();
  boolean hasPropertyTags();
  boolean hasConstructorFields();
  PhpConstructorFieldStubData[] getConstructionFieldsStubData();
  boolean hasTraitUses();
  @Override
  short getFlags();
  String getNamespaceName();
  boolean isAlias();

  class PhpConstructorFieldStubData {
    private final TextRange myRange;
    private final boolean myDynamic;
    private final PhpType myType;
    private final String myName;

    public PhpConstructorFieldStubData(String name, PhpType type, TextRange range, boolean dynamic) {
      myRange = range;
      myDynamic = dynamic;
      myType = type;
      myName = name;
    }

    public TextRange getRange() {
      return myRange;
    }

    public boolean isDynamic() {
      return myDynamic;
    }

    public PhpType getType() {
      return myType;
    }

    public String getName() {
      return myName;
    }
  }
}
