// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PhpTypeSignatureKey implements PhpTypeKey {
  VARIABLE('V'),
  ARRAY_ELEMENT('E'), //TODO move to ArrayAccessTP
  PARAMETER('A'),
  DOC_OF_SUPER_MEMBER('Ё'),
  SUPER_MEMBER('Э'),
  FUNCTION('F'),
  CONSTANT('D'),
  CLASS('C'),
  CLASS_CONSTANT('K'),
  FIELD('P'),
  PARENT('Q'),
  POLYMORPHIC_CLASS('S'),
  METHOD('M'),
  SELF_CLASS('Ф');

  private final char myKey;

  PhpTypeSignatureKey(char key) {
    myKey = key;
  }

  @Override
  public boolean is(char key) {
    return myKey == key;
  }

  @Override
  @NotNull
  public String sign(@Nullable CharSequence name) {
    return "#" + myKey + name;
  }

  @NotNull
  public String signIfUnsigned(@NotNull String name) {
    return StringUtil.startsWith(name, "#") ? name : sign(name);
  }

  @NotNull
  public static String getSignature(Function function) {
    if (function instanceof Method) {
      return METHOD.sign(CLASS.sign(function.getFQN()));
    }
    return FUNCTION.sign(function.getFQN());
  }

  public boolean isSigned(@Nullable String name) {
    return name != null && StringUtil.startsWith(name,"#" + myKey);
  }
}
