// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;

import java.util.Set;

public interface Variable extends PhpNamedElement,
                                  PhpReference,
                                  RWAccess,
                                  PhpExpression,
                                  StubBasedPsiElement<PhpVariableStub>,
                                  PhpTypedElement {

  String THIS = "this";
  String $THIS = "$this";

  Set<String> SUPERGLOBALS = ContainerUtil.set(
    "GLOBALS",
    "_COOKIE",
    "_ENV",
    //"HTTP_ENV_VARS",
    "_FILES",
    //"HTTP_POST_FILES",
    "_GET",
    //"HTTP_GET_VARS",
    "_POST",
    //"HTTP_POST_VARS",
    "_REQUEST",
    "_SERVER",
    //"HTTP_SERVER_VARS",
    "_SESSION",
    //"HTTP_SESSION_VARS",
    //"argc",
    //"argv",
    //"HTTP_RAW_POST_DATA",
    "http_response_header",
    "php_errormsg"
  );
  Condition<PsiElement> INSTANCEOF = use -> use instanceof Variable;


  /**
   * @return true for variable is a plain $a variable, false for variable variable ($$a for instance),
   */
  boolean canReadName();

  /**
   * STUB-UNSAFE
   * @return flag
   */
  boolean isDeclarationGlobal();

  /**
   * STUB-SAFE
   * @return flag
   */
  boolean isDeclaration();

  /**
   * STUB-...
   * @param global true=UNSAFE false=SAFE
   * @return flag
   */
  boolean isWriteAccess(boolean global);

}
