// Copyright 2000-2019 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public interface PhpDeprecationProvider {
  ExtensionPointName<PhpDeprecationProvider> EP_NAME = ExtensionPointName.create("com.jetbrains.php.deprecationProvider");

  @NotNull
  static List<PhpDeprecationProvider> getProvidersForElement(@NotNull PhpNamedElement element) {
    return ContainerUtil.filter(EP_NAME.getExtensionList(),provider -> provider.isAvailable(element));
  }

  boolean isDeprecated(@NotNull PhpNamedElement element, @NotNull String version);

  boolean isNotAvailable(@NotNull PhpNamedElement element, @NotNull String version);

  boolean isAvailable(@NotNull PhpNamedElement element);
}
