// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.psi.PhpElementType;

public interface PhpTokenTypes extends PhpDocTokenTypes {

  IElementType PHP_OPENING_TAG = new PhpElementType("php opening tag"); // <?php or <?
  IElementType PHP_ECHO_OPENING_TAG = new PhpElementType("php echo opening tag"); // <?=
  IElementType PHP_CLOSING_TAG = new PhpElementType("php closing tag"); // ?>
  IElementType UNKNOWN_SYMBOL = new PhpElementType("dunno what's that");
  //IElementType SYNTAX_ERROR = new PhpElementType("syntax error");

  IElementType LINE_COMMENT = new PhpElementType("line comment");
  //IElementType DOC_COMMENT = new PhpElementType("doc comment");
  IElementType C_STYLE_COMMENT = new PhpElementType("C style comment");

  IElementType WHITE_SPACE = new PhpElementType("some whitespace");
  IElementType HTML = new PhpElementType("PHP_TEMPLATE_TEXT");

  //
  IElementType kwNAMESPACE = new PhpElementType("namespace");
  IElementType kwUSE = new PhpElementType("use");
  IElementType NAMESPACE_RESOLUTION = new PhpElementType("namespace resolution");
  IElementType kwGOTO = new PhpElementType("goto");

  IElementType SCOPE_RESOLUTION = new PhpElementType("scope resolution"); // ::

  IElementType kwIF = new PhpElementType("if");
  IElementType kwELSEIF = new PhpElementType("elseif");
  IElementType kwELSE = new PhpElementType("else");
  IElementType kwFOR = new PhpElementType("for");
  IElementType kwFOREACH = new PhpElementType("foreach keyword");
  IElementType kwWHILE = new PhpElementType("while");
  IElementType kwDO = new PhpElementType("do");
  IElementType kwSWITCH = new PhpElementType("switch");
  IElementType kwMATCH = new PhpElementType("match");
  IElementType kwCASE = new PhpElementType("case");
  IElementType kwDEFAULT = new PhpElementType("default keyword");
  IElementType kwTRY = new PhpElementType("try");
  IElementType kwCATCH = new PhpElementType("catch");
  IElementType kwDECLARE = new PhpElementType("declare");
  IElementType kwBREAK = new PhpElementType("break");
  IElementType kwENDIF = new PhpElementType("endif");
  IElementType kwENDFOR = new PhpElementType("endfor");
  IElementType kwENDFOREACH = new PhpElementType("endforeach");
  IElementType kwENDWHILE = new PhpElementType("endwhile");
  IElementType kwENDSWITCH = new PhpElementType("endswitch");
  IElementType kwENDDECLARE = new PhpElementType("enddeclare");

  IElementType kwDIE = new PhpElementType("die");
  IElementType kwEXIT = new PhpElementType("exit");
  IElementType kwPRIVATE = new PhpElementType("private");
  IElementType kwFUNCTION = new PhpElementType("function");
  IElementType kwNEW = new PhpElementType("new");
  IElementType kwINSTANCEOF = new PhpElementType("instanceof");
  IElementType kwFN = new PhpElementType("fn");
  IElementType kwCONST = new PhpElementType("const");
  IElementType kwLIST = new PhpElementType("list");
  IElementType kwIMPLEMENTS = new PhpElementType("implements");
  IElementType kwEVAL = new PhpElementType("eval");
  IElementType kwFINAL = new PhpElementType("final");
  IElementType kwAS = new PhpElementType("as");
  IElementType kwTHROW = new PhpElementType("throw");
  IElementType kwINCLUDE_ONCE = new PhpElementType("include_once");
  IElementType kwCLASS = new PhpElementType("class");
  IElementType kwABSTRACT = new PhpElementType("abstract");
  IElementType kwINTERFACE = new PhpElementType("interface keyword");
  IElementType kwPUBLIC = new PhpElementType("public keyword");
  IElementType kwSTATIC = new PhpElementType("static keyword");
  IElementType kwCLONE = new PhpElementType("clone keyword");
  IElementType kwISSET = new PhpElementType("isset keyword");
  IElementType kwEMPTY = new PhpElementType("empty keyword");
  IElementType kwRETURN = new PhpElementType("return");
  IElementType kwVAR = new PhpElementType("var");
  IElementType kwCONTINUE = new PhpElementType("continue");
  IElementType kwPROTECTED = new PhpElementType("protected");
  IElementType kwPRINT = new PhpElementType("print");
  IElementType kwECHO = new PhpElementType("echo");
  IElementType kwINCLUDE = new PhpElementType("include");
  IElementType kwGLOBAL = new PhpElementType("global");
  IElementType kwEXTENDS = new PhpElementType("extends");
  IElementType kwUNSET = new PhpElementType("unset");
  IElementType kwREQUIRE_ONCE = new PhpElementType("require_once");
  IElementType kwARRAY = new PhpElementType("array");
  IElementType kwCALLABLE = new PhpElementType("callable");
  IElementType kwREQUIRE = new PhpElementType("require");

  IElementType VARIABLE = new PhpElementType("variable");
  IElementType VARIABLE_VARIABLE = new PhpElementType("variable_variable");
  IElementType VARIABLE_NAME = new PhpElementType("variable name"); // ???
  //IElementType VARIABLE_OFFSET_NUMBER = new PhpElementType("array index"); // ???
  IElementType DOLLAR_LBRACE = new PhpElementType("${"); // ???
  IElementType IDENTIFIER = new PhpElementType("identifier");
  IElementType PREDEFINED_IDENTIFIER = new PhpElementType("identifier");
  IElementType ARROW = new PhpElementType("arrow"); //->

  IElementType FLOAT_LITERAL = new PhpElementType("float");
  IElementType BINARY_INTEGER = new PhpElementType("bin int");
  IElementType OCTAL_INTEGER = new PhpElementType("oct int");
  IElementType DECIMAL_INTEGER = new PhpElementType("integer");
  IElementType HEX_INTEGER = new PhpElementType("hex int");
  //IElementType INTEGER_LITERAL = new PhpElementType("integer");
  IElementType STRING_LITERAL = new PhpElementType("double quoted string");
  IElementType STRING_NEW_LINE = new PhpElementType("string new line");
  IElementType STRING_LITERAL_SINGLE_QUOTE = new PhpElementType("single quoted string");

  IElementType EXEC_COMMAND = new PhpElementType("exec command");
  IElementType ESCAPE_SEQUENCE = new PhpElementType("escape sequence");
  IElementType HEREDOC_START = new PhpElementType("heredoc start");
  IElementType HEREDOC_CONTENTS = new PhpElementType("heredoc");
  IElementType HEREDOC_END = new PhpElementType("heredoc end");


  IElementType chLSINGLE_QUOTE = new PhpElementType("left single quote");
  IElementType chRSINGLE_QUOTE = new PhpElementType("right single quote");
  IElementType chLDOUBLE_QUOTE = new PhpElementType("left double quote");
  IElementType chRDOUBLE_QUOTE = new PhpElementType("right double quote");
  IElementType chLBACKTRICK = new PhpElementType("left backtrick");
  IElementType chRBACKTRICK = new PhpElementType("right backtrick");
  IElementType chLBRACE = new PhpElementType("{");
  IElementType chRBRACE = new PhpElementType("}");
  IElementType chLPAREN = new PhpElementType("(");
  IElementType chRPAREN = new PhpElementType(")");
  IElementType chLBRACKET = new PhpElementType("[");
  IElementType chRBRACKET = new PhpElementType("]");


  IElementType opPLUS = new PhpElementType("plus"); //+
  IElementType opMINUS = new PhpElementType("minus"); //-
  IElementType opINCREMENT = new PhpElementType("increment"); //++
  IElementType opDECREMENT = new PhpElementType("decrement"); //--
  IElementType opASGN = new PhpElementType("assign"); //=
  IElementType opNOT = new PhpElementType("not"); //!
  IElementType opQUEST = new PhpElementType("ternary"); //?
  IElementType opCOMMA = new PhpElementType("comma"); //,
  IElementType opCONCAT = new PhpElementType("dot"); //.
  IElementType opCOLON = new PhpElementType("colon"); //:
  IElementType opSEMICOLON = new PhpElementType("semicolon"); //;
  IElementType opBIT_AND = new PhpElementType("bit and"); //&
  IElementType opBIT_OR = new PhpElementType("bit or"); //|
  IElementType opBIT_XOR = new PhpElementType("bit xor"); //^
  IElementType opBIT_NOT = new PhpElementType("bit not"); //~
  IElementType opLIT_AND = new PhpElementType("and keyword"); //and
  IElementType opLIT_OR = new PhpElementType("or keyword"); //or
  IElementType opLIT_XOR = new PhpElementType("xor keyword"); //xor
  IElementType opEQUAL = new PhpElementType("equals"); //==
  IElementType opNOT_EQUAL = new PhpElementType("not equals"); //!=
  IElementType opIDENTICAL = new PhpElementType("identical"); //===
  IElementType opNOT_IDENTICAL = new PhpElementType("not identical"); //!==
  IElementType opPLUS_ASGN = new PhpElementType("plus assign"); //+=
  IElementType opMINUS_ASGN = new PhpElementType("minus assign"); //-=
  IElementType opMUL_ASGN = new PhpElementType("multiply assign"); //*=
  IElementType opDIV_ASGN = new PhpElementType("division assign"); ///=
  IElementType opREM_ASGN = new PhpElementType("division remainder assign"); //%=
  IElementType opSHIFT_RIGHT = new PhpElementType("shift right"); //>>
  IElementType opSHIFT_RIGHT_ASGN = new PhpElementType("shift right assign"); //>>=
  IElementType opSHIFT_LEFT = new PhpElementType("shift left"); //<<
  IElementType opSHIFT_LEFT_ASGN = new PhpElementType("shift left assign"); //<<=
  IElementType opBIT_AND_ASGN = new PhpElementType("bit and assign"); //&=
  IElementType opBIT_OR_ASGN = new PhpElementType("bit or assign"); //|=
  IElementType opBIT_XOR_ASGN = new PhpElementType("bit xor assign"); //^=
  IElementType opAND = new PhpElementType("and"); //&&
  IElementType opOR = new PhpElementType("or"); //||
  IElementType opLESS = new PhpElementType("less than"); //<
  IElementType opLESS_OR_EQUAL = new PhpElementType("less than or equal"); //<=
  IElementType opGREATER = new PhpElementType("greater than"); //>
  IElementType opGREATER_OR_EQUAL = new PhpElementType("greater than or equal"); //>=
  IElementType opCONCAT_ASGN = new PhpElementType("concatenation assign"); //.=
  IElementType opSILENCE = new PhpElementType("error silence"); //@
  IElementType opDIV = new PhpElementType("division"); ///
  IElementType opMUL = new PhpElementType("multiply"); //*
  IElementType opREM = new PhpElementType("remainder"); //%
  IElementType opHASH_ARRAY = new PhpElementType("hash"); //=>

  //casting
  IElementType opINTEGER_CAST = new PhpElementType("integer cast");
  IElementType opFLOAT_CAST = new PhpElementType("float cast");
  IElementType opBOOLEAN_CAST = new PhpElementType("boolean cast");
  IElementType opSTRING_CAST = new PhpElementType("string cast");
  IElementType opARRAY_CAST = new PhpElementType("array cast");
  IElementType opOBJECT_CAST = new PhpElementType("object cast");
  IElementType opBINARY_CAST = new PhpElementType("binary cast");
  IElementType opUNSET_CAST = new PhpElementType("unset cast");

  IElementType DOLLAR = new PhpElementType("dollar");

  //PHP 5.4 START
  IElementType kwTRAIT = new PhpElementType("trait");
  IElementType kwINSTEADOF = new PhpElementType("insteadof");

  //PHP 5.5 START
  IElementType kwFINALLY = new PhpElementType("finally");
  IElementType kwYIELD = new PhpElementType("yield");

  //PHP 5.6 START
  IElementType opEXP = new PhpElementType("exponentiation"); //**
  IElementType opEXP_ASGN = new PhpElementType("exponentiation assign"); //**=
  IElementType opVARIADIC = new PhpElementType("variadic"); //...

  //PHP 7.0 START
  IElementType opCOALESCE = new PhpElementType("coalesce"); //??
  IElementType opSPACESHIP = new PhpElementType("spaceship"); //<=>

  //PHP 7.4 START
  IElementType opCOALESCE_ASGN = new PhpElementType("coalesce assign"); //??=

  //PHP 8.0 START
  IElementType ATTRIBUTE_START = new PhpElementType("Attribute start"); //#[


  TokenSet tsPHP_OPENING_TAGS = TokenSet.create(PHP_OPENING_TAG, PHP_ECHO_OPENING_TAG);

  TokenSet tsSTATEMENT_PRIMARY =
    TokenSet.create(kwIF, kwFOR, kwFOREACH, kwWHILE, kwDO, kwBREAK, kwCONTINUE, kwECHO, kwGLOBAL, kwFUNCTION, kwFN, kwUNSET, kwSWITCH, kwTRY);

  TokenSet tsKEYWORDS = TokenSet.orSet(tsSTATEMENT_PRIMARY,
                                       TokenSet.create(kwABSTRACT, kwARRAY, kwAS, kwCALLABLE, kwCASE, kwCATCH, kwCLASS, kwTRAIT, kwINSTEADOF,
                                                       kwCLONE, kwCONST,
                                                       kwDEFAULT, kwELSE, kwELSEIF, kwEMPTY, kwENDDECLARE,
                                                       kwENDFOR, kwENDFOREACH, kwENDIF, kwENDSWITCH, kwENDWHILE, kwEVAL,
                                                       kwDIE, kwEXIT, kwEXTENDS, kwFINAL, kwFINALLY, kwIMPLEMENTS, kwINCLUDE,
                                                       kwINCLUDE_ONCE, kwINTERFACE, kwISSET, kwLIST, kwPRINT, kwPRIVATE,
                                                       kwPROTECTED, kwPUBLIC, kwREQUIRE, kwREQUIRE_ONCE, kwRETURN, kwSTATIC, kwTHROW,
                                                       kwVAR, kwNEW, kwINSTANCEOF, kwNAMESPACE, kwUSE, kwGOTO,
                                                       kwDECLARE, opLIT_AND, opLIT_OR, opLIT_XOR, kwYIELD, kwMATCH));

  TokenSet ALT_SYNTAX_END_KEYWORDS = TokenSet.create(kwENDFOREACH, kwENDIF, kwENDDECLARE, kwENDFOR, kwENDSWITCH, kwENDWHILE);

  TokenSet tsMATH_OPS = TokenSet.create(opPLUS, opMINUS, opMUL, opEXP, opDIV, opREM);

  TokenSet tsSHIFT_OPS = TokenSet.create(opSHIFT_LEFT,opSHIFT_RIGHT);

  TokenSet tsBIT_UNARY_OPS = TokenSet.create(opBIT_NOT);
  TokenSet tsBIT_BINARY_OPS = TokenSet.orSet(TokenSet.create(opBIT_AND, opBIT_OR, opBIT_XOR),tsSHIFT_OPS);
  TokenSet tsBIT_OPS = TokenSet.orSet(tsBIT_UNARY_OPS, tsBIT_BINARY_OPS);

  TokenSet tsASGN_OPS = TokenSet
    .create(opBIT_AND_ASGN, opBIT_OR_ASGN, opBIT_XOR_ASGN, opCONCAT_ASGN, opMINUS_ASGN, opMUL_ASGN, opEXP_ASGN, opDIV_ASGN,
            opPLUS_ASGN,
            opSHIFT_RIGHT_ASGN, opSHIFT_LEFT_ASGN, opREM_ASGN, opCOALESCE_ASGN, opASGN);

  TokenSet tsCAST_OPS =
    TokenSet.create(opINTEGER_CAST, opFLOAT_CAST, opBOOLEAN_CAST, opSTRING_CAST, opARRAY_CAST, opOBJECT_CAST, opBINARY_CAST, opUNSET_CAST);

  TokenSet tsUNARY_PREFIX_OPS = TokenSet
    .orSet(TokenSet.create(opNOT, opDECREMENT, opINCREMENT, opSILENCE, opPLUS, opMINUS, kwPRINT, kwCLONE), tsBIT_UNARY_OPS, tsCAST_OPS);
  TokenSet tsUNARY_POSTFIX_OPS = TokenSet.create(opDECREMENT, opINCREMENT);
  TokenSet tsUNARY_OPS = TokenSet.orSet(tsUNARY_PREFIX_OPS, tsUNARY_POSTFIX_OPS);

  TokenSet tsCOMPARE_EQUALITY_OPS = TokenSet.create(opEQUAL, opNOT_EQUAL, opIDENTICAL, opNOT_IDENTICAL, kwINSTANCEOF);

  TokenSet tsCOMPARE_ORDER_OPS = TokenSet.create(opGREATER, opLESS, opGREATER_OR_EQUAL, opLESS_OR_EQUAL, opSPACESHIP);

  TokenSet tsCOMPARE_OPS = TokenSet.orSet(tsCOMPARE_EQUALITY_OPS, tsCOMPARE_ORDER_OPS);

  TokenSet tsLIT_OPS = TokenSet.create(opLIT_AND, opLIT_OR, opLIT_XOR);

  TokenSet tsLOGICAL_OPS = TokenSet.orSet(TokenSet.create(opAND, opOR), tsLIT_OPS);

  TokenSet tsBINARY_OPS = TokenSet
    .orSet(TokenSet.create(opCONCAT, opCOALESCE), tsLIT_OPS, tsASGN_OPS, tsBIT_BINARY_OPS, tsCOMPARE_OPS, tsMATH_OPS,
           tsLOGICAL_OPS);

  TokenSet tsOPERATORS = TokenSet.orSet(tsBINARY_OPS, tsUNARY_OPS, TokenSet.create(opHASH_ARRAY));

  TokenSet tsTERNARY_OPS = TokenSet.create(opQUEST, opCOLON);

  TokenSet tsINTEGERS = TokenSet.create(BINARY_INTEGER, OCTAL_INTEGER, HEX_INTEGER, DECIMAL_INTEGER);
  TokenSet tsNUMBERS = TokenSet.orSet(tsINTEGERS, TokenSet.create(FLOAT_LITERAL));

  TokenSet tsSTRINGS = TokenSet.create(STRING_LITERAL, STRING_LITERAL_SINGLE_QUOTE, HEREDOC_CONTENTS);

  TokenSet tsSTRING_EDGE = TokenSet.create(chLDOUBLE_QUOTE, chRDOUBLE_QUOTE, chLSINGLE_QUOTE, chRSINGLE_QUOTE, chLBACKTRICK);

  TokenSet tsBRACKETS = TokenSet.create(chLBRACKET, chRBRACKET);

  TokenSet tsPARENTHESES = TokenSet.create(chLPAREN, chRPAREN);

  TokenSet tsBRACES = TokenSet.create(chLBRACE, chRBRACE);

  TokenSet CAST_OPERATORS = TokenSet.create(opINTEGER_CAST, opARRAY_CAST, opBOOLEAN_CAST, opFLOAT_CAST, opOBJECT_CAST, opSTRING_CAST, opUNSET_CAST, opBINARY_CAST);
  //TokenSet tsWHITE_SPACE_OR_COMMENT = TokenSet.create(DOC_COMMENT, C_STYLE_COMMENT, LINE_COMMENT, WHITE_SPACE);

  //TokenSet tsREFERENCE_FIRST_TOKENS = TokenSet.create(VARIABLE, IDENTIFIER, DOLLAR);

  //TokenSet tsOPERAND_FIRST_TOKENS =
  //  TokenSet.orSet(tsREFERENCE_FIRST_TOKENS, tsNUMBERS, tsSTRING_EDGE, TokenSet.create(kwARRAY, kwEMPTY, kwEXIT, kwISSET));

  //TokenSet tsPRIMARY_TOKENS = TokenSet.orSet(tsOPERAND_FIRST_TOKENS, tsUNARY_OPS, TokenSet.create(chLPAREN));

  //TokenSet tsTERMINATOR = TokenSet.create(opSEMICOLON, PHP_CLOSING_TAG);

  TokenSet tsHEREDOC_IDS = TokenSet.create(HEREDOC_START, HEREDOC_END);

  TokenSet tsCOMMON_SCALARS = TokenSet.orSet(tsNUMBERS, TokenSet.create(chLSINGLE_QUOTE, chRDOUBLE_QUOTE));

  //TokenSet tsJUNKS = TokenSet.create(HTML, PHP_OPENING_TAG, PHP_ECHO_OPENING_TAG);

  TokenSet tsVISIBILITY_MODIFIERS = TokenSet.create(kwPUBLIC, kwPRIVATE, kwPROTECTED);
  TokenSet tsMODIFIERS = TokenSet.orSet(tsVISIBILITY_MODIFIERS, TokenSet.create(kwABSTRACT, kwFINAL, kwSTATIC));

  TokenSet tsVARIABLE_MODIFIERS = TokenSet.orSet(tsMODIFIERS, TokenSet.create(kwVAR));

  TokenSet tsSTATEMENT_FIRST_TOKENS = TokenSet
    .create(kwIF, kwWHILE, kwDO, kwFOR, kwSWITCH, kwBREAK, kwCONTINUE, kwRETURN, kwGLOBAL, kwSTATIC, kwECHO, kwUNSET, kwFOREACH, kwDECLARE,
            kwTRY, kwTHROW, kwGOTO, kwCONST, kwYIELD);

  TokenSet tsSHORT_CIRCUIT_AND_OPS = TokenSet.create(opLIT_AND, opAND);
  TokenSet tsSHORT_CIRCUIT_OR_OPS = TokenSet.create(opLIT_OR, opOR);

  TokenSet tsCOMMUTATIVE_OPS = TokenSet.orSet(
    TokenSet.create(opPLUS, opBIT_AND, opBIT_OR, opBIT_XOR, opLIT_XOR, opMUL),
    tsCOMPARE_EQUALITY_OPS,
    tsSHORT_CIRCUIT_AND_OPS,
    tsSHORT_CIRCUIT_OR_OPS
  );

  TokenSet COMMENTS = TokenSet.create(C_STYLE_COMMENT, LINE_COMMENT);

  TokenSet tsAND_OPS = TokenSet.create(opLIT_AND, opAND, opBIT_AND);
  TokenSet tsOR_OPS = TokenSet.create(opLIT_OR, opOR, opBIT_OR);
}
