// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.inspections.reference.PhpRefMetaData;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Map;

public interface PhpRefElement extends RefElement, PhpRefEntity {
  @Override
  @Deprecated
  default PsiElement getElement() {
    throw new UnsupportedOperationException();
  }

  @Override
  default PsiElement getPsiElement() {
    //noinspection deprecation
    return getElement();
  }

  boolean wasNotCalled();

  boolean wasCalled();
  
  @Nullable
  PhpPsiElement getPhpElement();

  boolean isInitialized();

  boolean isTraversed();

  boolean isFromCommon();

  default boolean isTraversable() {
    return this instanceof PhpRefFunction ||
           this instanceof PhpRefClass ||
           this instanceof PhpRefConstant ||
           this instanceof PhpRefClassMember;
  }

  /**
   * Can be used in annotators implementations for storing
   * custom data for reference analysis.
   */
  default void attachMetaData(final RefElement declaration, final PhpRefMetaData data, final Key<Map<RefElement, PhpRefMetaData>> key) {

  }

  default void attachMetaData(final PhpReference reference, final PhpRefElement declaration) {

  }
  
  Collection<RefElement> getPhpDocReferences();

  void addPhpDocReference(@NotNull PhpRefElement refElement);
}
