// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference.elements;

import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public interface PhpRefClassMember extends PhpRefElement {
  @NotNull
  String getAccessModifierString();

  @NotNull
  PhpModifier getAccessModifier();

  @Nullable
  @Override
  PhpClassMember getPhpElement();

  PhpRefClass getOwnerClass();

  boolean isFinal();

  boolean wasUsedByStaticReference();

  boolean wasUsedBySelfOrParentOnly();

  boolean isStatic();

  boolean isAbstract();

  boolean isPublic();

  boolean isProtected();

  boolean isPrivate();

  @NotNull
  Collection<? extends PhpRefClassMember> getDerivedMembers();

  @NotNull
  Collection<? extends PhpRefClassMember> getSuperMembers();

  @NotNull
  Collection<PhpRefClassMember> getDuplicates();
}
