// Copyright 2000-2019 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespace;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public abstract class PhpRefManager implements RefManagerExtension<PhpRefManager> {
  @NonNls public static final String CLASS = "phpClass";
  @NonNls public static final String METHOD = "phpMethod";
  @NonNls public static final String FUNCTION = "phpFunction";
  @NonNls public static final String FIELD = "phpField";
  @NonNls static final String PARAMETER = "phpParameter";
  @NonNls static final String CONST = "phpConst";
  @NonNls static final String NAMESPACE = "phpNamespace";
  @NotNull
  private static final Key<PhpRefManager> MANAGER = Key.create("PhpRefManager");

  @NotNull
  public static PhpRefManager getInstance(@NotNull RefManager refManager) {
    return refManager.getExtension(MANAGER);
  }

  @NotNull
  public static PhpEntryPointsManager getEntryPointsManager(@NotNull RefManager refManager) {
    return getInstance(refManager).getEntryPointsManager();
  }

  @NotNull
  abstract public PhpEntryPointsManager getEntryPointsManager();

  @Nullable
  abstract public PhpRefParameter createRefParameter(@NotNull final Parameter psi, final int order, final PhpRefFunction refFunction);

  @Override
  abstract public void onEntityInitialized(@NotNull RefElement refElement, @NotNull PsiElement psiElement);

  abstract public boolean isSuitedForEntryPoint(@NotNull RefElement refElement);

  @NotNull
  @Override
  public Key<PhpRefManager> getID() {
    return MANAGER;
  }

  @NotNull
  @Override
  public Collection<Language> getLanguages() {
    return new SmartList<>(Language.findInstance(PhpLanguage.class));
  }

  @NotNull
  @Override
  public Language getLanguage() {
    return Language.findInstance(PhpLanguage.class);
  }

  @NotNull
  @Override
  public RefEntity getRefinedElement(@NotNull RefEntity ref) {
    return ref;
  }

  @Nullable
  @Override
  public String getGroupName(@NotNull RefEntity entity) {
    return null;
  }


  @Override
  public void markExternalReferencesProcessed(@NotNull RefElement file) {
  }

  @Override
  public void iterate(@NotNull RefVisitor visitor) {
  }

  @Override
  public void removeReference(@NotNull RefElement refElement) {
  }

  @Override
  public boolean belongsToScope(@NotNull PsiElement psiElement) {
    return true;
  }

  @Nullable
  public abstract PhpRefNamespace getNamespace(@NotNull PhpNamespace refElement);
}
