// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang;

import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import org.jetbrains.annotations.NotNull;

public final class PhpLanguage extends Language implements TemplateLanguage {
  public static final PhpLanguage INSTANCE = new PhpLanguage();
  public static final PhpInjectableLanguage INJECTABLE_INSTANCE = new PhpInjectableLanguage();

  private PhpLanguage() {
    super("PHP");
  }

  private static final class PhpInjectableLanguage extends Language implements TemplateLanguage, InjectableLanguage {

    private static final String NAME = "Injectable PHP";

    private PhpInjectableLanguage() {
      super(INSTANCE, "InjectablePHP");
    }

    @NotNull
    @Override
    public String getDisplayName() {
      return NAME;
    }
  }
}
