/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigSyncPluginsAction
extends DumbAwareAction {
    public CloudConfigSyncPluginsAction() {
        super(CloudConfigBundle.messagePointer("update.plugins.action", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CloudConfigSyncPluginsAction.$$$reportNull$$$0(0);
        }
        CloudConfigManager manager = CloudConfigManager.getInstance();
        e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected() && (manager.hasPluginsUpdate() || manager.hasPluginsAnyUpdate()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloudConfigSyncPluginsAction.$$$reportNull$$$0(1);
        }
        CloudConfigSyncPluginsAction.showPluginsDialog();
    }

    public static void showPluginsDialog() {
        final PluginModel pluginModel = new PluginModel();
        TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(CloudConfigBundle.message("plugins.dialog.message", new Object[0]), CloudConfigBundle.message("plugins.dialog.title", new Object[0]), new String[]{CloudConfigBundle.message("plugins.dialog.button", new Object[0]), Messages.getCancelButton()}, null, false, 0, 0, null, (exitCode, checkBox) -> exitCode){
            PluginTable myTable;

            protected String getDimensionServiceKey() {
                return "cloudConfig.PluginsDialog";
            }

            protected JComponent createNorthPanel() {
                return null;
            }

            protected JComponent createCenterPanel() {
                JPanel messagePanel = this.createMessagePanel();
                messagePanel.add(this.createCheckComponent());
                return messagePanel;
            }

            @NotNull
            protected JComponent createCheckComponent() {
                this.myTable = new PluginTable((PluginTableModel)pluginModel);
                JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
                int width = this.myTable.getPreferredScrollableViewportSize().width;
                pane.setPreferredSize(new Dimension(width, JBUIScale.scale((int)200)));
                this.myTable.setColumnWidth(1, JBUIScale.scale((int)150));
                JScrollPane jScrollPane = pane;
                if (jScrollPane == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jScrollPane;
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTable;
            }

            protected Action @NotNull [] createActions() {
                Action[] actions = super.createActions();
                pluginModel.setOkButton(actions[0]);
                if (actions == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actions;
            }

            protected String getHelpId() {
                return "cloud-config.plugin-dialog";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/cloudConfig/CloudConfigSyncPluginsAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCheckComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        dialog.show();
        if (dialog.getExitCode() == 0) {
            CloudConfigManager.getInstance().executePlugins(pluginModel.myStates.values().stream().filter(editState -> editState.getOperation() != null).map(editState -> Pair.create((Object)editState.myState, (Object)((Object)editState.getOperation()))).collect(Collectors.toList()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/cloudConfig/CloudConfigSyncPluginsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EditPluginState {
        private final PluginState myState;
        private PluginState.Operation myOperation;

        EditPluginState(@NotNull PluginState state) {
            if (state == null) {
                EditPluginState.$$$reportNull$$$0(0);
            }
            this.myOperation = PluginState.Operation.Auto;
            this.myState = state;
            if (state.skip) {
                this.myOperation = state.local ? PluginState.Operation.SkipLocally : PluginState.Operation.SkipEverywhere;
            }
        }

        private EditPluginState(@NotNull PluginState.Operation operation) {
            if (operation == null) {
                EditPluginState.$$$reportNull$$$0(1);
            }
            this.myOperation = PluginState.Operation.Auto;
            this.myState = null;
            this.myOperation = operation;
        }

        public static EditPluginState @NotNull [] getStates() {
            PluginState.Operation[] values = PluginState.Operation.values();
            EditPluginState[] states = new EditPluginState[values.length];
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                states[i] = new EditPluginState(values[i]);
            }
            if (states == null) {
                EditPluginState.$$$reportNull$$$0(2);
            }
            return states;
        }

        @Nls
        @NotNull
        public String getPluginStatus() {
            switch (this.myState.type) {
                case Install: {
                    String string = CloudConfigBundle.message("cloud.sync.plugin.status.not.installed", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                case Uninstall: {
                    String string = CloudConfigBundle.message("cloud.sync.plugin.status.installed", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                case Disable: {
                    String string = CloudConfigBundle.message("cloud.sync.plugin.status.enabled", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(5);
                    }
                    return string;
                }
            }
            String string = CloudConfigBundle.message("cloud.sync.plugin.status.disabled", new Object[0]);
            if (string == null) {
                EditPluginState.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getOperationName(PluginState.Operation operation) {
            switch (operation) {
                case Revert: {
                    return this.getRevertName();
                }
                case SkipEverywhere: {
                    String string = CloudConfigBundle.message("plugin.sync.state.skip.everywhere", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                case SkipLocally: {
                    String string = CloudConfigBundle.message("plugin.sync.state.skip", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(8);
                    }
                    return string;
                }
            }
            String string = this.myState.type.getLocalizedName();
            if (string == null) {
                EditPluginState.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        @Nls
        private String getRevertName() {
            switch (this.myState.type) {
                case Install: {
                    String string = CloudConfigBundle.message("plugin.sync.state.uninstall.everywhere", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(10);
                    }
                    return string;
                }
                case Uninstall: {
                    String string = CloudConfigBundle.message("plugin.sync.state.install.everywhere", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                case Disable: {
                    String string = CloudConfigBundle.message("plugin.sync.state.enable.everywhere", new Object[0]);
                    if (string == null) {
                        EditPluginState.$$$reportNull$$$0(12);
                    }
                    return string;
                }
            }
            String string = CloudConfigBundle.message("plugin.sync.state.disable.everywhere", new Object[0]);
            if (string == null) {
                EditPluginState.$$$reportNull$$$0(13);
            }
            return string;
        }

        @Nullable
        public PluginState.Operation getOperation() {
            if (this.myState.skip && (this.myState.local ? this.myOperation == PluginState.Operation.SkipLocally : this.myOperation == PluginState.Operation.SkipEverywhere)) {
                return null;
            }
            return this.myOperation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EditPluginState)) {
                return false;
            }
            EditPluginState state = (EditPluginState)o;
            return this.myOperation == state.myOperation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/CloudConfigSyncPluginsAction$EditPluginState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/CloudConfigSyncPluginsAction$EditPluginState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStates";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginStatus";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOperationName";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevertName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PluginModel
    extends PluginTableModel {
        final Map<IdeaPluginDescriptor, EditPluginState> myStates = new HashMap<IdeaPluginDescriptor, EditPluginState>();
        Runnable myOkHandler;

        PluginModel() {
            this.columns = new ColumnInfo[]{new PluginManagerColumnInfo(0){

                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new PluginsTableRenderer(descriptor, false){
                        {
                            super(arg0, arg1);
                            this.myName.setFont(UIUtil.getLabelFont());
                        }

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            this.myName.append(" ").append(myStates.get(this.myPluginDescriptor).getPluginStatus(), isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
                            ((JComponent)component).setToolTipText(null);
                            this.myName.setForeground((Color)UIUtil.getCellColors((JTable)table, (boolean)isSelected, (int)row, (int)column).getFirst());
                            return component;
                        }
                    };
                }
            }, new ColumnInfo<IdeaPluginDescriptor, EditPluginState>(""){

                @Nullable
                public EditPluginState valueOf(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : myStates.get(descriptor);
                }

                public boolean isCellEditable(IdeaPluginDescriptor descriptor) {
                    return true;
                }

                @Nullable
                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new ComboBoxTableRenderer<EditPluginState>(null){

                        @NlsContexts.Label
                        protected String getTextFor(@NotNull EditPluginState value) {
                            if (value == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return value.getOperationName(value.myOperation);
                        }

                        protected void customizeComponent(EditPluginState value, JTable table, boolean isSelected) {
                            super.customizeComponent((Object)value, table, isSelected);
                            if (!isSelected && value.getOperation() == null) {
                                this.setForeground(SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigSyncPluginsAction$PluginModel$2$1", "getTextFor"));
                        }
                    };
                }

                public TableCellEditor getEditor(IdeaPluginDescriptor descriptor) {
                    return new ComboBoxTableRenderer<EditPluginState>(EditPluginState.getStates()){
                        private EditPluginState myValue;

                        public boolean isCellEditable(EventObject event) {
                            if (event instanceof MouseEvent) {
                                return ((MouseEvent)event).getClickCount() >= 1;
                            }
                            return false;
                        }

                        protected String getTextFor(@NotNull EditPluginState value) {
                            if (value == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return this.myValue.getOperationName(value.myOperation);
                        }

                        protected ListSeparator getSeparatorAbove(EditPluginState value) {
                            return value.myOperation == PluginState.Operation.SkipLocally ? new ListSeparator() : null;
                        }

                        protected void customizeComponent(EditPluginState value, JTable table, boolean isSelected) {
                            this.myValue = value;
                            super.customizeComponent((Object)value, table, isSelected);
                            if (value.getOperation() == null) {
                                this.setForeground(SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigSyncPluginsAction$PluginModel$2$2", "getTextFor"));
                        }
                    };
                }

                public void setValue(IdeaPluginDescriptor descriptor, EditPluginState value) {
                    myStates.get((Object)descriptor).myOperation = value.myOperation;
                    myOkHandler.run();
                }
            }};
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.addItems(manager.getInstalledUninstalledPlugins());
            this.addItems(manager.getEnabledDisabledPlugins());
        }

        public void setOkButton(@NotNull Action okButton) {
            if (okButton == null) {
                PluginModel.$$$reportNull$$$0(0);
            }
            this.myOkHandler = () -> {
                boolean result = false;
                for (EditPluginState renderer : this.myStates.values()) {
                    if (renderer.getOperation() == null) continue;
                    result = true;
                    break;
                }
                okButton.setEnabled(result);
            };
            this.myOkHandler.run();
        }

        private void addItems(@NotNull List<PluginState> states) {
            if (states == null) {
                PluginModel.$$$reportNull$$$0(1);
            }
            for (PluginState state : states) {
                if (this.myStates.containsKey(state.plugin)) continue;
                this.view.add(state.plugin);
                this.myStates.put(state.plugin, new EditPluginState(state));
            }
        }

        public int getNameColumn() {
            return 0;
        }

        public boolean isSortable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "okButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/CloudConfigSyncPluginsAction$PluginModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOkButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItems";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

