/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sqlite;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sqlite.SqliteTokens;
import com.intellij.sql.dialects.sqlite.SqliteTypeSystem;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqliteDialect
extends SqlLanguageDialectEx {
    public static final SqliteDialect INSTANCE = new SqliteDialect();

    public SqliteDialect() {
        super("SQLite");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SQLITE;
        if (dbms == null) {
            SqliteDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            SqliteDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqliteDialect.$$$reportNull$$$0(5);
        }
        if (!strict && type == ObjectKind.PACKAGE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            PsiElement p = place == null ? null : place.getParent();
            PsiElement pp = p == null ? null : p.getParent();
            return place == null || pp instanceof SqlFunctionCallTableExpressionImpl;
        }
        return type == ObjectKind.VIRTUAL_TABLE && expectedTypes.contains(ObjectKind.TABLE) || !strict && type == ObjectKind.PACKAGE && expectedTypes.contains(ObjectKind.TABLE);
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        SqliteTypeSystem sqliteTypeSystem = SqliteTypeSystem.INSTANCE;
        if (sqliteTypeSystem == null) {
            SqliteDialect.$$$reportNull$$$0(6);
        }
        return sqliteTypeSystem;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            SqliteDialect.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            SqliteDialect.$$$reportNull$$$0(8);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_SQLITE_MASTER.name, (boolean)resolve2) && !processor.executeTarget((DasSymbol)LazyData.RE_SQLITE_MASTER, (SqlType)SqlTableTypeBase.EMPTY_TABLE, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            SqlTypeSystemBase typeSystem = this.getTypeSystem();
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)LazyData.RE_OID, (SqlType)typeSystem.integerType(), (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)LazyData.RE_ROWID, (SqlType)typeSystem.integerType(), (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)LazyData.RE_ROWID2, (SqlType)typeSystem.integerType(), (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) {
                return false;
            }
        }
        if (processor.isExpected(ObjectKind.COLLATION) && place instanceof SqlReferenceExpression) {
            for (ReservedEntity function : LazyData.COLLATE_FUNCTIONS.values()) {
                if (SqliteDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)function, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor);
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != ObjectKind.PACKAGE && super.shallResolve(o2, type);
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create(Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}));
    }

    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqliteDialect.$$$reportNull$$$0(9);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), (boolean)true, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA});
        if (treePattern == null) {
            SqliteDialect.$$$reportNull$$$0(10);
        }
        return treePattern;
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sqlite/SqliteDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sqlite/SqliteDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(SqliteTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;
        static final Map<String, ReservedEntity> COLLATE_FUNCTIONS;
        static final ReservedEntity RE_SQLITE_MASTER;
        static final ReservedEntity RE_OID;
        static final ReservedEntity RE_ROWID;
        static final ReservedEntity RE_ROWID2;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqliteTypes.SQLITE_MATCH, SqliteTypes.SQLITE_REGEXP, SqliteTypes.SQLITE_GLOB, SqlTokens.SQL_OP_EQEQ, SqliteTypes.SQLITE_ISNULL, SqliteTypes.SQLITE_NOTNULL);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQLITE_DOT_END})});
            COLLATE_FUNCTIONS = SqlDialectImplUtil.buildEntities((Dbms)Dbms.SQLITE, (ObjectKind)ObjectKind.COLLATION, (String[])new String[]{"nocase", "rtrim", "binary"});
            RE_SQLITE_MASTER = new ReservedEntity(Dbms.SQLITE, "sqlite_master", ObjectKind.TABLE);
            RE_OID = new ReservedEntity(Dbms.SQLITE, "OID", ObjectKind.COLUMN);
            RE_ROWID = new ReservedEntity(Dbms.SQLITE, "ROWID", ObjectKind.COLUMN);
            RE_ROWID2 = new ReservedEntity(Dbms.SQLITE, "_ROWID_", ObjectKind.COLUMN);
        }
    }
}

