/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.refactoring;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgExtractVariableHelper
extends SqlExtractVariableHelper {
    public PgExtractVariableHelper(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(0);
        }
        super(dialect);
    }

    @Nullable
    public PsiElement createDeclaration(@NotNull Project project, @NotNull String name2, @NotNull DataType type, @NotNull String expressionText) {
        if (project == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(2);
        }
        if (type == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(3);
        }
        if (expressionText == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(4);
        }
        String varText = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().type(type).getStatement();
        String statementText = "declare " + varText + "; begin end";
        SqlCodeFragment fragment = SqlPsiElementFactory.createFragmentFromText((String)statementText, (SqlLanguageDialect)this.dialect, (IElementType)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT, (Project)project, null);
        return PsiTreeUtil.findChildOfType((PsiElement)fragment, SqlVariableDefinition.class);
    }

    @Nullable
    public PsiElement createInitializerDeclaration(@NotNull Project project, @NotNull String name2, @NotNull String text) {
        if (project == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(6);
        }
        if (text == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(7);
        }
        String initText = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().symbol(":=").space().plain(text).getStatement();
        return SqlPsiElementFactory.createStatementFromText((String)initText, (SqlLanguageDialect)this.dialect, (Project)project, null);
    }

    public PsiElement addDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement block, @NotNull PsiElement anchor2) {
        PsiElement first2;
        if (declaration == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(8);
        }
        if (block == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(9);
        }
        if (anchor2 == null) {
            PgExtractVariableHelper.$$$reportNull$$$0(10);
        }
        if ((first2 = block.getFirstChild()) != null && first2.getNode().getElementType() != PgTypes.PG_DECLARE) {
            PsiElement declare = SqlPsiElementFactory.createLeafFromText((Project)declaration.getProject(), (SqlLanguageDialect)this.dialect, (String)"declare");
            first2 = block.addBefore(declare, first2);
        }
        PsiElement element = block.addAfter(declaration, first2);
        PsiElement semi = SqlPsiElementFactory.createLeafFromText((Project)declaration.getProject(), (SqlLanguageDialect)this.dialect, (String)";");
        block.addAfter(semi, element);
        block.addBefore(SqlPsiElementFactory.newLine((Project)block.getProject()), element);
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/refactoring/PgExtractVariableHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeclaration";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitializerDeclaration";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

