/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Pg83Dialect
extends PgDialectBase {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    public Pg83Dialect(@NotNull String id) {
        if (id == null) {
            Pg83Dialect.$$$reportNull$$$0(0);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        Object preparedStatement;
        String nameUC;
        if (place == null) {
            Pg83Dialect.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            Pg83Dialect.$$$reportNull$$$0(2);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor)) {
            return false;
        }
        SqlTypeSystemBase typeSystem = this.getTypeSystem();
        String string = nameUC = name2 == null ? null : StringUtil.toUpperCase((String)name2);
        if (resolve2 && name2 != null && LazyData.ARG_PATTERN.matcher(name2).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(((PgCreatePreparedStatement)((Object)preparedStatement)).getArgument(name2), (SqlType)SqlType.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (Pg83Dialect.inPl(place) && this.getQualifier(place) == null) {
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)((LazyInstanceData)this.myInstanceData.getValue()).myFoundColumn.name, (String)name2, (boolean)resolve2) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).myFoundColumn, typeSystem.booleanType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)((LazyInstanceData)this.myInstanceData.getValue()).mySqlStateColumn.name, (String)name2, (boolean)resolve2) && Pg83Dialect.raiseStatement(place) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).mySqlStateColumn, typeSystem.integerType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)((LazyInstanceData)this.myInstanceData.getValue()).mySqlErrmColumn.name, (String)name2, (boolean)resolve2) && Pg83Dialect.raiseStatement(place) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).mySqlErrmColumn, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(ObjectKind.OPERATOR_CLASS)) {
            if (!resolve2) {
                for (ReservedEntity target2 : ((LazyInstanceData)this.myInstanceData.getValue()).myOperatorClasses.values()) {
                    if (processor.executeTarget((DasSymbol)target2, SqlTypeFactory.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) continue;
                    return false;
                }
            } else if (((LazyInstanceData)this.myInstanceData.getValue()).myOperatorClasses.containsKey(nameUC) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).myOperatorClasses.get(nameUC), SqlTypeFactory.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.ACCESS_METHOD)) {
            for (ReservedEntity am : ((LazyInstanceData)this.myInstanceData.getValue()).myAccessMethods) {
                if (Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)am, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, null)) continue;
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.COLUMN)) {
            SqlExpression expression;
            boolean process2 = true;
            if (!resolve2 && (expression = this.getQualifier(place)) != null && expression.getSqlType() == SqlType.UNKNOWN) {
                process2 = false;
            }
            if (process2) {
                for (ReservedEntity entity : ((LazyInstanceData)this.myInstanceData.getValue()).myIntegerEntities.values()) {
                    if (Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, (SqlType)this.getTypeSystem().integerType(), (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) continue;
                    return false;
                }
            }
        }
        if (place instanceof SqlReferenceExpression) {
            SqlReferenceElementType type = ((SqlReferenceExpression)place).getReferenceElementType();
            if (type == SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE) {
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)((LazyInstanceData)this.myInstanceData.getValue()).myPgDefaultTablespace, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple((ReservedEntity)((LazyInstanceData)this.myInstanceData.getValue()).myPgGlobalTablespace, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
            }
            if (((SqlReferenceExpression)place).getQualifierExpression() == null) {
                for (ReservedEntity object : this.getReservedObjects()) {
                    if (processor.executeTarget((DasSymbol)object, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            Pg83Dialect.$$$reportNull$$$0(3);
        }
        return 63;
    }

    @NotNull
    protected abstract List<ReservedEntity> getReservedObjects();

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == ObjectKind.OPERATOR_CLASS || type == ObjectKind.OPERATOR_FAMILY || type == PgElementTypes.Kinds.TEXT_SEARCH_PARSER || type == PgElementTypes.Kinds.TEXT_SEARCH_DICTIONARY || type == PgElementTypes.Kinds.TEXT_SEARCH_CONFIGURATION || type == PgElementTypes.Kinds.TEXT_SEARCH_TEMPLATE || type == ObjectKind.LANGUAGE) {
            result2.add((ObjectKind)SqlDbElementType.SCHEMA);
        }
        return super.getParentDbTypes(result2, type);
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName dbName = Pg83Dialect.getDbName(dataSource);
        DasNamespace namespace = Pg83Dialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create((ObjectName)PgDialect.LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                Pg83Dialect.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbName, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)PgDialect.LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            Pg83Dialect.$$$reportNull$$$0(5);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Collections.singletonList(ObjectName.quoted((String)"pg_catalog")), (boolean)true, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA});
        if (treePattern == null) {
            Pg83Dialect.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Pg83Dialect.$$$reportNull$$$0(7);
        }
        if (type == SqlDbElementType.OBJECT_ATTRIBUTE && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (strict) {
            return false;
        }
        if (SqlDialectImplUtil.isLabelOrRoutineQualification((PsiElement)(symbol instanceof PsiElement ? (PsiElement)symbol : null), (ObjectKind)type, (PsiElement)place, (boolean)isCompletion)) {
            return true;
        }
        if (expectedTypes.contains(SqlDbElementType.COLUMN) || expectedTypes.contains(SqlDbElementType.ANY)) {
            boolean isTable;
            boolean bl = isTable = type == SqlDbElementType.TABLE;
            if (type == SqlDbElementType.LOCAL_ALIAS) {
                if (symbol == null) {
                    isTable = true;
                } else {
                    PsiElement parent2 = symbol instanceof PsiElement ? ((PsiElement)symbol).getParent() : null;
                    boolean bl2 = isTable = parent2 instanceof SqlFromClause || parent2 instanceof SqlJoinExpression;
                }
            }
            if (isTable) {
                SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
                return ref2 == null || ref2.getQualifierExpression() == null;
            }
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, false, isCompletion);
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        if (column2 == null) {
            Pg83Dialect.$$$reportNull$$$0(8);
        }
        if (super.isAutoIncrementColumn(column2)) {
            return true;
        }
        String type = column2.getDataType().getSpecification();
        return LazyData.SERIAL_PATTERN.matcher(type).matches();
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Pg83Dialect.$$$reportNull$$$0(9);
        }
        return collection;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != SqlDbElementType.CURSOR && super.shallResolve(o2, type);
    }

    @Nullable
    protected SqlExpression getQualifier(@NotNull PsiElement element) {
        SqlReferenceExpression ref2;
        if (element == null) {
            Pg83Dialect.$$$reportNull$$$0(10);
        }
        return (ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element, SqlReferenceExpression.class)) == null ? null : ref2.getQualifierExpression();
    }

    @NotNull
    public JBIterable<? extends DasArgument> getParametersForCallCheck(@NotNull DasRoutine routine2) {
        if (routine2 == null) {
            Pg83Dialect.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = DasUtil.getParameters((DasRoutine)routine2).filter(p -> p.getArgumentDirection().isIn());
        if (jBIterable == null) {
            Pg83Dialect.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    private static boolean raiseStatement(@NotNull PsiElement element) {
        SqlStatement statement;
        if (element == null) {
            Pg83Dialect.$$$reportNull$$$0(13);
        }
        return (statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) != null && statement.getNode().getElementType() == PgElementTypes.Misc.PG_RAISE_STATEMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersForCallCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParametersForCallCheck";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "raiseStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LazyInstanceData {
        private final List<ReservedEntity> myAccessMethods;
        private final Map<String, ReservedEntity> myIntegerEntities;
        private final ReservedEntity myPgDefaultTablespace;
        private final ReservedEntity myPgGlobalTablespace;
        private final ReservedEntity myFoundColumn;
        private final ReservedEntity mySqlStateColumn;
        private final ReservedEntity mySqlErrmColumn;
        private final Map<String, ReservedEntity> myOperatorClasses;

        private LazyInstanceData() {
            this.myAccessMethods = Arrays.asList(new ReservedEntity(Pg83Dialect.this.getDbms(), "btree", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "hash", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "gist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "spgist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "gin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "brin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity(Pg83Dialect.this.getDbms(), "bloom", SqlDbElementType.ACCESS_METHOD));
            this.myIntegerEntities = SqlDialectImplUtil.buildEntities((Dbms)Pg83Dialect.this.getDbms(), (ObjectKind)SqlDbElementType.COLUMN, (String[])new String[]{"OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID"});
            this.myPgDefaultTablespace = new ReservedEntity(Pg83Dialect.this.getDbms(), "pg_default", SqlDbElementType.TABLESPACE);
            this.myPgGlobalTablespace = new ReservedEntity(Pg83Dialect.this.getDbms(), "pg_global", SqlDbElementType.TABLESPACE);
            this.myFoundColumn = new ReservedEntity(Pg83Dialect.this.getDbms(), "FOUND", SqlDbElementType.COLUMN);
            this.mySqlStateColumn = new ReservedEntity(Pg83Dialect.this.getDbms(), "SQLSTATE", SqlDbElementType.COLUMN);
            this.mySqlErrmColumn = new ReservedEntity(Pg83Dialect.this.getDbms(), "SQLERRM", SqlDbElementType.COLUMN);
            this.myOperatorClasses = SqlDialectImplUtil.buildEntities((Dbms)Pg83Dialect.this.getDbms(), (ObjectKind)ObjectKind.OPERATOR_CLASS, (String[])new String[]{"INTEGER_OPS", "TEXT_PATTERN_OPS", "INT8_OPS", "INT4_OPS", "INT2_OPS", "VARCHAR_PATTERN_OPS", "BPCHAR_PATTERN_OPS", "JSONB_PATH_OPS", "JSONB_OPS"});
        }
    }

    private static class LazyData {
        static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Pattern SERIAL_PATTERN = Pattern.compile("(?i)(?:big|small)?serial|serial[248]");
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.TRIGGER, SqlDbElementType.RULE, SqlDbElementType.POLICY);

        private LazyData() {
        }
    }
}

