/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.SqlDialectHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.oracle.OraDateTimeLanguageHelper;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.dataFlow.OraDFABuildingVisitor;
import com.intellij.sql.dialects.oracle.dataFlow.OraErrorSpecHelper;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractFunctionHelper;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OraDialectHelperBase
extends SqlDialectHelper {
    private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[]{new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})})});

    protected OraDialectHelperBase(OraDialect dialect) {
        super((SqlLanguageDialectEx)dialect);
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o2, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkIdentifierStartsWithLetter(o2, manager, onTheFly);
        if (result2 != null) {
            return result2;
        }
        SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)PsiTreeUtil.getTopmostParentOfType((PsiElement)o2, SqlStatement.class), SqlDefinition.class);
        boolean isPl = false;
        if (def != null && !PsiTreeUtil.isContextAncestor((PsiElement)def.getNameElement(), (PsiElement)o2, (boolean)false)) {
            ObjectKind kind = def.getKind();
            isPl = kind == ObjectKind.ROUTINE || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
        }
        return this.checkIdentifierIsKeyword(o2, manager, onTheFly, isPl);
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new OraExtractVariableHelper();
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return OraExtractFunctionHelper.INSTANCE;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return ENTER_HANDLER;
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        OraErrorSpecHelper oraErrorSpecHelper = OraErrorSpecHelper.INSTANCE;
        if (oraErrorSpecHelper == null) {
            OraDialectHelperBase.$$$reportNull$$$0(0);
        }
        return oraErrorSpecHelper;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new OraDFABuildingVisitor(this.getDialect());
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        OraDateTimeLanguageHelper oraDateTimeLanguageHelper = OraDateTimeLanguageHelper.INSTANCE;
        if (oraDateTimeLanguageHelper == null) {
            OraDialectHelperBase.$$$reportNull$$$0(1);
        }
        return oraDateTimeLanguageHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/dialects/oracle/OraDialectHelperBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

