/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dataFlow.SqlErrorSpecInfo;
import com.intellij.sql.dataFlow.SqlStateInfo;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSignalStatement;
import com.intellij.sql.psi.impl.SqlSpecialErrorSpec;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0004*\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/dialects/mysql/dataFlow/MysqlErrorSpecHelper;", "Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "()V", "ER_SIGNAL_EXCEPTION", "", "ER_SIGNAL_NOT_FOUND", "ER_SIGNAL_WARN", "NOT_FOUND_CODES", "", "WARNING_CODES", "getDefaultErrorCode", "", "sqlState", "Lcom/intellij/sql/dataFlow/SqlStateInfo;", "context", "Lcom/intellij/psi/PsiElement;", "getNotFoundErrorSpec", "Lcom/intellij/sql/dataFlow/SqlErrorSpecInfo;", "getSqlStateByErrorCode", "errorCode", "getExplicitErrorCode", "Lcom/intellij/sql/psi/impl/SqlSignalStatement;", "(Lcom/intellij/sql/psi/impl/SqlSignalStatement;)Ljava/lang/Integer;", "intellij.database.dialects.mysqlbase"})
public final class MysqlErrorSpecHelper
extends SqlErrorSpecHelper {
    private static final int ER_SIGNAL_WARN = 1642;
    private static final int ER_SIGNAL_NOT_FOUND = 1643;
    private static final int ER_SIGNAL_EXCEPTION = 1644;
    private static final Set<Integer> WARNING_CODES;
    private static final Set<Integer> NOT_FOUND_CODES;
    @NotNull
    public static final MysqlErrorSpecHelper INSTANCE;

    private final Integer getExplicitErrorCode(SqlSignalStatement $this$getExplicitErrorCode) {
        Iterator iterator = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)$this$getExplicitErrorCode.getOptionsClause())).filter(SqlSetAssignment.class).iterator();
        while (iterator.hasNext()) {
            Integer n;
            Object object;
            SqlSetAssignment infoItem;
            SqlSetAssignment sqlSetAssignment = infoItem = (SqlSetAssignment)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)sqlSetAssignment, (String)"infoItem");
            PsiElement psiElement = sqlSetAssignment.getFirstChild();
            if (!Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)MysqlTypes.MYSQL_MYSQL_ERRNO)) continue;
            SqlElement sqlElement = infoItem.getRValue();
            if (!(sqlElement instanceof SqlLiteralExpression)) {
                sqlElement = null;
            }
            if ((object = (SqlLiteralExpression)sqlElement) != null && (object = object.getText()) != null) {
                Object object2 = object;
                boolean bl = false;
                n = Integer.parseInt((String)object2);
            } else {
                n = null;
            }
            return n;
        }
        return null;
    }

    @Nullable
    public Object getDefaultErrorCode(@NotNull SqlStateInfo sqlState, @Nullable PsiElement context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sqlState, (String)"sqlState");
        PsiElement psiElement = context;
        if (!(psiElement instanceof SqlSignalStatement)) {
            psiElement = null;
        }
        SqlSignalStatement sqlSignalStatement = (SqlSignalStatement)psiElement;
        if (sqlSignalStatement == null) {
            return null;
        }
        SqlSignalStatement signalStatement = sqlSignalStatement;
        SqlStateInfo sqlStateInfo = sqlState;
        if (!(sqlStateInfo instanceof SqlStateInfo.Specific)) {
            sqlStateInfo = null;
        }
        if ((object = (SqlStateInfo.Specific)sqlStateInfo) == null || (object = object.getValue()) == null) {
            return null;
        }
        Object sqlStateValue = object;
        Integer n = this.getExplicitErrorCode(signalStatement);
        if (n == null) {
            n = StringsKt.startsWith$default((String)sqlStateValue, (String)"00", (boolean)false, (int)2, null) ? null : (StringsKt.startsWith$default((String)sqlStateValue, (String)"01", (boolean)false, (int)2, null) ? Integer.valueOf(1642) : (StringsKt.startsWith$default((String)sqlStateValue, (String)"02", (boolean)false, (int)2, null) ? Integer.valueOf(1643) : Integer.valueOf(1644)));
        }
        return n;
    }

    @Nullable
    public SqlStateInfo getSqlStateByErrorCode(@NotNull Object errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Object object = errorCode;
        return Intrinsics.areEqual((Object)object, (Object)0) ? null : (CollectionsKt.contains((Iterable)WARNING_CODES, (Object)object) ? (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.WARNING) : (CollectionsKt.contains((Iterable)NOT_FOUND_CODES, (Object)object) ? (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.NOT_FOUND) : (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.EXCEPTION)));
    }

    @Nullable
    public SqlErrorSpecInfo getNotFoundErrorSpec() {
        return new SqlErrorSpecInfo((SqlStateInfo)new SqlStateInfo.Specific("02000"), (Object)1643);
    }

    private MysqlErrorSpecHelper() {
    }

    static {
        MysqlErrorSpecHelper mysqlErrorSpecHelper;
        INSTANCE = mysqlErrorSpecHelper = new MysqlErrorSpecHelper();
        WARNING_CODES = SetsKt.setOf((Object[])new Integer[]{1249, 1261, 1262, 1265, 1311, 1642, 3519, 3565, 3713, 3715, 3751});
        NOT_FOUND_CODES = SetsKt.setOf((Object[])new Integer[]{1329, 1643});
    }
}

