/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.database.Dbms;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSHighlightInfoFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoFilter;", "()V", "accept", "", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "file", "Lcom/intellij/psi/PsiFile;", "shouldHighlightErrorElement", "element", "Lcom/intellij/psi/PsiErrorElement;", "intellij.database.dialects.mongo"})
public final class MongoJSHighlightInfoFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return true;
        }
        PsiFile vFile = psiFile;
        DbDataSource dbDataSource = DbVFSUtils.getDataSource((Project)file.getProject(), (VirtualFile)vFile);
        if (dbDataSource == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"DbVFSUtils.getDataSource\u2026ct, vFile) ?: return true");
        DbDataSource dataSource = dbDataSource;
        DbDataSource dbDataSource2 = dataSource.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource2, (String)"dataSource.dataSource");
        Dbms dbms = dbDataSource2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dataSource.dataSource.dbms");
        if (!dbms.isMongo()) {
            return true;
        }
        String string = highlightInfo.getDescription();
        if (string == null) {
            return true;
        }
        String description = string;
        return !StringUtil.startsWith((CharSequence)description, (CharSequence)"Unresolved") && Intrinsics.areEqual((Object)"Unterminated statement", (Object)description) ^ true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) return true;
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) return true;
        VirtualFile virtualFile2 = virtualFile;
        DbDataSource dataSource = DbVFSUtils.getDataSource((Project)element.getProject(), (VirtualFile)virtualFile2);
        if (dataSource == null) return true;
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dataSource.dbms");
        if (!dbms.isMongo()) return true;
        PsiElement psiElement = element.getPrevSibling();
        String string = psiElement != null ? psiElement.getText() : null;
        boolean bl = false;
        boolean bl2 = false;
        String prev = string;
        boolean bl3 = false;
        if (!(Intrinsics.areEqual((Object)prev, (Object)"show") ^ true)) return false;
        if (!(Intrinsics.areEqual((Object)prev, (Object)"use") ^ true)) return false;
        return true;
    }
}

