/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSMethod;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.sql.dialects.mongo.js.psi.resolve.types.MongoJSType;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.IsImpure;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "()V", "mySideEffectsProducingAnalyzer", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "SideEffectsProducingAnalyzer", "intellij.database.dialects.mongo"})
public final class MongoJSExecutionFlowAnalyzer
implements ExecutionFlowAnalyzer<PsiElement> {
    private final ExecutionFlowAnalyzer<PsiElement> mySideEffectsProducingAnalyzer = new SideEffectsProducingAnalyzer();

    @NotNull
    public ExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element) {
        ExecutionFlowAnalyzer.Flow flow;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.mySideEffectsProducingAnalyzer.isAcceptable(element)) {
            ExecutionFlowAnalyzer.Flow flow2 = this.mySideEffectsProducingAnalyzer.analyze(element);
            flow = flow2;
            Intrinsics.checkNotNullExpressionValue((Object)flow2, (String)"mySideEffectsProducingAnalyzer.analyze(element)");
        } else {
            ExecutionFlowAnalyzer.Flow flow3 = ExecutionFlowAnalyzer.UnknownFlow;
            flow = flow3;
            Intrinsics.checkNotNullExpressionValue((Object)flow3, (String)"ExecutionFlowAnalyzer.UnknownFlow");
        }
        return flow;
    }

    public boolean isAcceptable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.mySideEffectsProducingAnalyzer.isAcceptable(element);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSExecutionFlowAnalyzer$SideEffectsProducingAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "CommonFlow", "intellij.database.dialects.mongo"})
    private static final class SideEffectsProducingAnalyzer
    implements ExecutionFlowAnalyzer<PsiElement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)CommonFlow.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        public boolean isAcceptable(@NotNull PsiElement e2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            if (PsiUtilBase.getElementType((PsiElement)e2) instanceof IsImpure) {
                return false;
            }
            MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper(e2);
            if (mongoJSResolveHelper == null) {
                return false;
            }
            MongoJSResolveHelper helper = mongoJSResolveHelper;
            if (!helper.getExpressionStatementClass().isAssignableFrom(e2.getClass())) {
                return false;
            }
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)e2, helper.getReferenceExpressionClass());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.findChildren\u2026referenceExpressionClass)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl2 = false;
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                if (helper.getReferenceName(psiElement) == null) {
                    bl = false;
                } else if (helper.getReferenceQualifier(it) == null) {
                    bl = false;
                } else {
                    MongoJSMethod method;
                    String methodRefName;
                    PsiElement methodRefQualifier;
                    MongoJSType mongoJSType = helper.getMongoType(methodRefQualifier);
                    String string = methodRefQualifier.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodRefQualifier.text");
                    MongoJSSymbol mongoJSSymbol = mongoJSType.getMember(string, methodRefName);
                    if (!(mongoJSSymbol instanceof MongoJSMethod)) {
                        mongoJSSymbol = null;
                    }
                    bl = (MongoJSMethod)mongoJSSymbol == null ? false : !method.isPure();
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            boolean bl = false;
            return !collection2.isEmpty();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSExecutionFlowAnalyzer$SideEffectsProducingAnalyzer$CommonFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "()V", "transform", "T", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.dialects.mongo"})
        public static final class CommonFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final CommonFlow INSTANCE;

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.common();
            }

            private CommonFlow() {
                super(ThreeState.NO);
            }

            static {
                CommonFlow commonFlow;
                INSTANCE = commonFlow = new CommonFlow();
            }
        }
    }
}

