/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.maria;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasColumnSymbol;
import com.intellij.database.symbols.DasPsiSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.DasTableSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.maria.MariaTypeSystem;
import com.intellij.sql.dialects.mysql.MysqlDialectBase;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLockTableStatement;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MariaDialect
extends MysqlDialectBase {
    public static final MariaDialect INSTANCE = new MariaDialect();

    public MariaDialect() {
        super("MariaDB");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MARIA;
        if (dbms == null) {
            MariaDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MariaDialect.$$$reportNull$$$0(1);
        }
        if (type == SqlDbElementType.CURSOR && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        MariaTypeSystem mariaTypeSystem = MariaTypeSystem.INSTANCE;
        if (mariaTypeSystem == null) {
            MariaDialect.$$$reportNull$$$0(2);
        }
        return mariaTypeSystem;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            MariaDialect.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            MariaDialect.$$$reportNull$$$0(4);
        }
        if (!MariaDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)LazyData.RE_SYSTEM_TIME, null, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
            return false;
        }
        if (name2 != null && LazyData.SEQUENCE_TABLE_PATTERN.matcher(name2).matches()) {
            SequenceTable dasTable = new SequenceTable(name2, place);
            return processor.executeTarget((DasSymbol)dasTable, (SqlType)dasTable.createType(), Boolean.valueOf(false), ResolveState.initial());
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor);
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        ObjectKind kind;
        if (identifier == null) {
            MariaDialect.$$$reportNull$$$0(5);
        }
        return (kind = SqlImplUtil.getIdentifierKind((SqlIdentifier)identifier)) == ObjectKind.USER ? 80 : (kind == ObjectKind.ROLE ? 128 : super.getMaxIdentifierLength(identifier, version));
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            MariaDialect.$$$reportNull$$$0(6);
        }
        return builtinFunctions;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            MariaDialect.$$$reportNull$$$0(7);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlLockTableStatement.class}) != null;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            MariaDialect.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            MariaDialect.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/maria/MariaDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/maria/MariaDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SequenceTable
    extends FakePsiElement
    implements DasTable,
    DasTableSymbol,
    DasPsiSymbol {
        private final String myName;
        private final PsiElement myContext;
        private final MySeqColumn myColumn;

        private SequenceTable(@NotNull String name2, PsiElement element) {
            if (name2 == null) {
                SequenceTable.$$$reportNull$$$0(0);
            }
            if (element == null) {
                SequenceTable.$$$reportNull$$$0(1);
            }
            this.myColumn = new MySeqColumn();
            this.myName = name2;
            this.myContext = element;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.MARIA;
            if (dbms == null) {
                SequenceTable.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                SequenceTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SequenceTable.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SequenceTable.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean isQuoted() {
            return true;
        }

        @Nullable
        public DasTable getDasObject() {
            return this;
        }

        @NotNull
        public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = kind == ObjectKind.COLUMN ? JBIterable.of((Object)((Object)this.myColumn)) : JBIterable.empty();
            if (jBIterable == null) {
                SequenceTable.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        public PsiElement getParent() {
            return this.myContext.getContainingFile();
        }

        public SqlTableType createType() {
            SqlType sqlType = MariaDialect.this.getTypeSystem().integerType();
            DasType dasType = MariaDialect.this.getTypeService().getIntType();
            return SqlTableTypeBase.createType((PsiElement)this.myColumn, (SqlType)sqlType, (DasType)dasType, (String)this.myColumn.getName(), (boolean)false, (PsiElement)this, null);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
                return false;
            }
            SequenceTable table = (SequenceTable)((Object)o2);
            return this.myName.equals(table.myName) && this.myContext.equals(table.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myName, this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/maria/MariaDialect$SequenceTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/maria/MariaDialect$SequenceTable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        class MySeqColumn
        extends FakePsiElement
        implements DasColumn,
        PsiMetaOwner,
        PsiPresentableMetaData,
        DasColumnSymbol,
        DasPsiSymbol {
            MySeqColumn() {
            }

            @NotNull
            public Dbms getDbms() {
                Dbms dbms = Dbms.MARIA;
                if (dbms == null) {
                    MySeqColumn.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            public short getPosition() {
                return 1;
            }

            @NotNull
            public DasTable getTable() {
                SequenceTable sequenceTable = SequenceTable.this;
                if (sequenceTable == null) {
                    MySeqColumn.$$$reportNull$$$0(1);
                }
                return sequenceTable;
            }

            @NotNull
            public DataType getDataType() {
                DataType dataType = MariaDialect.this.getTypeSystem().integerType().getDataType();
                if (dataType == null) {
                    MySeqColumn.$$$reportNull$$$0(2);
                }
                return dataType;
            }

            public boolean isNotNull() {
                return true;
            }

            @Nullable
            public String getDefault() {
                return null;
            }

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    MySeqColumn.$$$reportNull$$$0(3);
                }
                return objectKind;
            }

            @NonNls
            @NotNull
            public String getName() {
                return "seq";
            }

            public boolean isQuoted() {
                return true;
            }

            public PsiElement getParent() {
                return SequenceTable.this;
            }

            @NotNull
            public PsiMetaData getMetaData() {
                MySeqColumn mySeqColumn = this;
                if (mySeqColumn == null) {
                    MySeqColumn.$$$reportNull$$$0(4);
                }
                return mySeqColumn;
            }

            @NlsSafe
            @NotNull
            public String getTypeName() {
                String string = StringUtil.toLowerCase((String)this.getKind().name());
                if (string == null) {
                    MySeqColumn.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            public PsiElement getDeclaration() {
                return null;
            }

            public String getName(PsiElement context) {
                return SequenceTable.this.myName;
            }

            @NotNull
            public DasColumn getDasObject() {
                MySeqColumn mySeqColumn = this;
                if (mySeqColumn == null) {
                    MySeqColumn.$$$reportNull$$$0(6);
                }
                return mySeqColumn;
            }

            public void init(PsiElement element) {
            }

            public boolean equals(Object o2) {
                if (this == o2) {
                    return true;
                }
                if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
                    return false;
                }
                MySeqColumn column2 = (MySeqColumn)((Object)o2);
                return this.getParent().equals(column2.getParent());
            }

            public int hashCode() {
                return Objects.hash(this.getParent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/dialects/maria/MariaDialect$SequenceTable$MySeqColumn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMetaData";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeName";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasObject";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(MysqlTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static final Set<String> ourKeywords;
        static final Set<String> ourReservedKeywords;
        static final ReservedEntity RE_SYSTEM_TIME;
        static final Pattern SEQUENCE_TABLE_PATTERN;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            RE_SYSTEM_TIME = new ReservedEntity(Dbms.MARIA, "system_time", ObjectKind.PERIOD);
            SEQUENCE_TABLE_PATTERN = Pattern.compile("seq_\\d+_to_\\d+(_step_\\d+)?", 2);
        }
    }
}

