/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.h2.H2OptionalKeywords;
import com.intellij.sql.dialects.h2.H2Tokens;
import com.intellij.sql.dialects.h2.H2TypeSystem;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class H2Dialect
extends SqlLanguageDialectEx {
    public static final H2Dialect INSTANCE = new H2Dialect();

    public H2Dialect() {
        super("H2");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.H2;
        if (dbms == null) {
            H2Dialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            H2Dialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        H2TypeSystem h2TypeSystem = H2TypeSystem.INSTANCE;
        if (h2TypeSystem == null) {
            H2Dialect.$$$reportNull$$$0(5);
        }
        return h2TypeSystem;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            H2Dialect.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            H2Dialect.$$$reportNull$$$0(7);
        }
        if (!this.processReservedEntitiesWithTypeDual(name2, place, resolve2, processor)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor);
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName[] dbAndSc = H2Dialect.getDatabaseAndSchema(dataSource);
        DasNamespace namespace = H2Dialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbAndSc[0]);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create((ObjectName)dbAndSc[1], (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                H2Dialect.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbAndSc[0], (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)dbAndSc[1], (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            H2Dialect.$$$reportNull$$$0(9);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlUpdateStatement.class}) != null;
    }

    @NotNull
    private static ObjectName[] getDatabaseAndSchema(@Nullable DbDataSource dataSource) {
        ObjectName[] dbAndSc = new ObjectName[2];
        JdbcUrlParser parsed = SqlDialectImplUtilCore.getParsed((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource));
        if (parsed != null) {
            dbAndSc[0] = ObjectName.plain((String)StringUtil.nullize((String)parsed.getParameter("database")));
            if (dbAndSc[0] == null) {
                String path = StringUtil.nullize((String)parsed.getParameter("file"));
                if (path == null) {
                    path = StringUtil.nullize((String)parsed.getParameter("path"));
                }
                if (path != null) {
                    dbAndSc[0] = ObjectName.plain((String)new File(path).getName());
                }
            }
            dbAndSc[1] = ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)parsed.findProperty("schema"), (Object)parsed.getParameter("schema"))));
        }
        if (dbAndSc[1] == null) {
            dbAndSc[1] = ObjectName.plain((String)"public");
        }
        if (dbAndSc == null) {
            H2Dialect.$$$reportNull$$$0(10);
        }
        return dbAndSc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/h2/H2Dialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/h2/H2Dialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseAndSchema";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(H2Tokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_MODULO, H2OptionalKeywords.H2_REGEXP);
        }
    }
}

