/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.greenplum;

import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlInjectionIdentifyingLexerUtil;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.greenplum.GPlumLexer;
import com.intellij.sql.dialects.greenplum.GPlumTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class GPlumInjectionIdentifyingLexer
extends GPlumLexer {
    private final SqlLexer.LookAheadHelper myLah = new SqlLexer.LookAheadHelper(){

        @Override
        protected void superLookAhead(Lexer lexer) {
            GPlumInjectionIdentifyingLexer.super.lookAhead(lexer);
        }
    };

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            GPlumInjectionIdentifyingLexer.$$$reportNull$$$0(0);
        }
        this.myLah.restart(baseLexer);
        IElementType type = this.myLah.getNextToken();
        if (type == SqlCommonKeywords.SQL_DO) {
            GPlumInjectionIdentifyingLexer.lookAheadDoBlock(this.myLah);
        } else if (type == SqlCommonKeywords.SQL_CREATE) {
            SqlInjectionIdentifyingLexerUtil.lookAheadCreateFunction(this.myLah, null, SqlInjectionIdentifyingLexerUtil.ourStopper, null);
        }
    }

    private static void lookAheadDoBlock(SqlLexer.LookAheadHelper lah) {
        String lang;
        IElementType type = lah.getNextToken();
        if (type == GPlumTypes.GPLUM_LANGUAGE) {
            lang = SqlInjectionIdentifyingLexerUtil.getNormalizedLanguage(lah);
            if (lang == null) {
                return;
            }
            type = lah.getNextToken();
        } else {
            lang = "pgsql";
        }
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE && lah.getNextToken() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            lah.replaceToken(lah.getPos(), (IElementType)SqlTokenType.SqlInjectionMark.get((String)lang));
            lah.getNextToken();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/greenplum/GPlumInjectionIdentifyingLexer", "lookAhead"));
    }
}

