/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.clickhouse.CHouseDialect;
import com.intellij.sql.dialects.clickhouse.psi.CHouseJoinExpression;
import com.intellij.sql.dialects.clickhouse.psi.CHouseLambdaLiteral;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlArrayType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHouseTypeSystem
extends SqlTypeSystemBase {
    public static final CHouseTypeSystem INSTANCE = new CHouseTypeSystem();

    private CHouseTypeSystem() {
        super((SqlLanguageDialectEx)CHouseDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            CHouseTypeSystem.$$$reportNull$$$0(0);
        }
        if (name2.equalsIgnoreCase("int")) {
            return "Int32";
        }
        if (name2.equalsIgnoreCase("integer")) {
            return "Int32";
        }
        String string = name2;
        if (string == null) {
            CHouseTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            CHouseTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "Int64";
            }
            case REAL: {
                return "Float64";
            }
            case STRING: {
                return "String";
            }
            case BOOLEAN: {
                return "UInt8";
            }
            case DATE_TIME: {
                return "DateTime";
            }
            case DATE: {
                return "Date";
            }
            case TIME: {
                return "DateTime";
            }
            case TIMESTAMP: {
                return "DateTime";
            }
            case INTERVAL: {
                return "Interval";
            }
            case BYTES: {
                return "FixedString";
            }
            case ARRAY: {
                return "Array";
            }
            case RECORD: {
                return "Tuple";
            }
            case TABLE: {
                return "Nested";
            }
        }
        return null;
    }

    @NotNull
    public SqlType getSqlType(@Nullable SqlReferenceImpl ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        SqlType type = super.getSqlType(ref2, resolved, symbol);
        if (ref2 == null) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CHouseTypeSystem.$$$reportNull$$$0(3);
            }
            return sqlType;
        }
        SqlExpression qualifier = ref2.getQualifier();
        if (qualifier == null) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CHouseTypeSystem.$$$reportNull$$$0(4);
            }
            return sqlType;
        }
        SqlType qualifierType = qualifier.getSqlType();
        Object object = qualifierType instanceof SqlArrayType ? SqlArrayType.of((SqlType)type, (int)((SqlArrayType)qualifierType).getDepth()) : type;
        if (object == null) {
            CHouseTypeSystem.$$$reportNull$$$0(5);
        }
        return object;
    }

    @Nullable
    public SqlType getUnqualifiedAsteriskType(@NotNull PsiElement element) {
        SqlQueryExpression queryExpression;
        SqlTableExpression tableExpression;
        if (element == null) {
            CHouseTypeSystem.$$$reportNull$$$0(6);
        }
        SqlTableExpression sqlTableExpression = tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression();
        if (tableExpression == null) {
            return null;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return this.getDummyType(tableExpression);
        }
        SqlExpression expr = fromClause.getFromExpression();
        if (expr == null) {
            return null;
        }
        SqlType type = expr instanceof CHouseJoinExpression ? ((CHouseJoinExpression)expr).calcJoinType(null, true) : expr.getSqlType();
        return type instanceof SqlTableType ? CHouseDialect.filterComputedColumns((SqlTableType)type) : type;
    }

    @Nullable
    public SqlType getBuiltinFunctionReturnType(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        if (prototype == null) {
            CHouseTypeSystem.$$$reportNull$$$0(7);
        }
        if (routineElement == null) {
            CHouseTypeSystem.$$$reportNull$$$0(8);
        }
        if (!(params instanceof SqlExpressionList) || nameElement == null) {
            return null;
        }
        SqlExpressionList expressionList = (SqlExpressionList)params;
        List expressions = expressionList.getExpressionList();
        switch (nameElement.getName()) {
            case "sumMap": {
                return SqlImplUtil.getTupleType((SqlExpressionList)expressionList);
            }
            case "arrayFirst": {
                if (expressions.size() < 1) {
                    return null;
                }
                SqlType arrayType = ((SqlExpression)expressions.get(0)).getSqlType();
                return arrayType instanceof SqlArrayType ? ((SqlArrayType)arrayType).getElementType() : null;
            }
            case "arrayMap": {
                CHouseLambdaLiteral lambda2 = (CHouseLambdaLiteral)PsiTreeUtil.getChildOfType((PsiElement)expressionList, CHouseLambdaLiteral.class);
                SqlType lambdaBodyType = lambda2 != null ? lambda2.getReturnType() : null;
                return lambdaBodyType != null ? SqlArrayType.of((SqlType)lambdaBodyType) : null;
            }
        }
        return null;
    }

    private SqlType getDummyType(@NotNull SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            CHouseTypeSystem.$$$reportNull$$$0(9);
        }
        return (SqlType)CachedValuesManager.getCachedValue((PsiElement)tableExpression, () -> CachedValueProvider.Result.create((Object)this.calcDummyType(tableExpression), (Object[])new Object[]{tableExpression}));
    }

    private SqlType calcDummyType(@NotNull SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            CHouseTypeSystem.$$$reportNull$$$0(10);
        }
        SqlType sqlType = this.booleanType();
        DasType dasType = this.getTypeService().getBooleanType();
        return SqlImplUtil.createType(Collections.singletonList(SqlDialectImplUtil.col((PsiElement)tableExpression, null, (String)"dummy", (SqlType)sqlType, (DasType)dasType)), (PsiElement)tableExpression.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUnqualifiedAsteriskType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinFunctionReturnType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDummyType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcDummyType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

