/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.cassandra.CassReservedKeywords;
import com.intellij.sql.dialects.cassandra.CassTokens;
import com.intellij.sql.dialects.cassandra.CassTypeSystem;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassDialect
extends SqlLanguageDialectEx {
    public static final CassDialect INSTANCE = new CassDialect();

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        CassTypeSystem cassTypeSystem = CassTypeSystem.INSTANCE;
        if (cassTypeSystem == null) {
            CassDialect.$$$reportNull$$$0(0);
        }
        return cassTypeSystem;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"timeuuid", (String)"timeuuid", (SqlLanguageDialectEx)this);
    }

    public CassDialect() {
        super("CassandraQL");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CASSANDRA;
        if (dbms == null) {
            CassDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        Collection res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add(ObjectKind.COLUMN);
        }
        return (T)res2;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            CassDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            CassDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            CassDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CassDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CassDialect.$$$reportNull$$$0(6);
        }
        if (type == ObjectKind.OBJECT_ATTRIBUTE && expectedTypes.contains(ObjectKind.COLUMN)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            CassDialect.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            CassDialect.$$$reportNull$$$0(8);
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor);
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = CassDialect.getDefaultNamespace((DbDataSource)dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                CassDialect.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, false);
        if (treePattern == null) {
            CassDialect.$$$reportNull$$$0(10);
        }
        return treePattern;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            CassDialect.$$$reportNull$$$0(11);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/CassDialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/CassDialect";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(CassTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens(CassTokens.class);
            ourReservedKeywords = SqlTokenRegistry.getTokens(CassReservedKeywords.class);
            ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_NOT, SqlTokens.SQL_IN, SqlTokens.SQL_OP_MODULO);
            ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;
        }
    }
}

