/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.Version;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;

public class VertRawPlanData
extends RawPlanData {
    public Version version;
    public String json;

    @Override
    public void load(@NotNull DatabaseConnection connection, final @NotNull String statement, boolean run2) {
        if (connection == null) {
            VertRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            VertRawPlanData.$$$reportNull$$$0(1);
        }
        this.version = connection.getVersion();
        final StringBuilder result2 = new StringBuilder();
        VertRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                s.noisy().execute((Object)("EXPLAIN VERBOSE JSON " + statement), VertRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    if (rs.getMetaData().getColumnCount() != 1) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    while (rs.next()) {
                        String str = rs.getString(1);
                        result2.append(str).append("\n");
                    }
                    String startMarker = "JSON format:\n";
                    int start2 = result2.indexOf(startMarker);
                    if (start2 != -1) {
                        result2.replace(0, start2 + startMarker.length(), "");
                        int end = result2.indexOf("End JSON format\n", start2);
                        if (end != -1) {
                            result2.replace(end, result2.length(), "");
                        }
                    }
                    if (result2.length() == 0) {
                        VertRawPlanData.failWithEmptyResultSetError();
                    }
                }));
            }
        }, new RawPlanData.StateSaver[0]);
        this.json = result2.toString();
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            VertRawPlanData.$$$reportNull$$$0(2);
        }
        this.json = dump;
        try {
            JSONObject object = new JSONObject(this.json);
            this.version = Version.of((String)object.optString("version", "0"));
        }
        catch (JSONException e2) {
            this.version = Version.ZERO;
        }
    }

    @Override
    public String dump() {
        try {
            JSONObject res2 = new JSONObject(this.json);
            res2.put("version", (Object)this.version.toString());
            return res2.toString(1);
        }
        catch (JSONException e2) {
            return this.json;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/vertica/plan/VertRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

